<?php
defined('BASEPATH') or exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/userguide3/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'welcome';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

// =============================================
// SUPER ADMIN ROUTES
// =============================================
$route['superadmin'] = 'superadmin/Superadmin/index';
$route['superadmin/action'] = 'superadmin/Superadmin/action';
$route['superadmin/dashboard'] = 'superadmin/Superadmin/dashboard';
$route['superadmin/logout'] = 'superadmin/Superadmin/logout';

// Admin Management
$route['superadmin/admin_list'] = 'superadmin/Superadmin/admin_list';
$route['superadmin/admin_form'] = 'superadmin/Superadmin/admin_form';
$route['superadmin/admin_form/(:num)'] = 'superadmin/Superadmin/admin_form/$1';
$route['superadmin/save_admin'] = 'superadmin/Superadmin/save_admin';
$route['superadmin/delete_admin/(:num)'] = 'superadmin/Superadmin/delete_admin/$1';

// Kos Management
$route['superadmin/kos_list'] = 'superadmin/Superadmin/kos_list';
$route['superadmin/kos_form'] = 'superadmin/Superadmin/kos_form';
$route['superadmin/kos_form/(:num)'] = 'superadmin/Superadmin/kos_form/$1';
$route['superadmin/save_kos'] = 'superadmin/Superadmin/save_kos';
$route['superadmin/delete_kos/(:num)'] = 'superadmin/Superadmin/delete_kos/$1';

// Report Management
$route['superadmin/report_list'] = 'superadmin/Superadmin/report_list';
$route['superadmin/report_detail/(:num)'] = 'superadmin/Superadmin/report_detail/$1';
$route['superadmin/process_report'] = 'superadmin/Superadmin/process_report';
$route['superadmin/activate_admin/(:num)'] = 'superadmin/Superadmin/activate_admin/$1';

// =============================================
// USER ROUTES
// =============================================
// Login/Logout
$route['user/login'] = 'user/Login/index';
$route['user/login/process'] = 'user/Login/process';
$route['user/logout'] = 'user/Login/logout';
$route['user/dashboard'] = 'user/Dashboard/index';

// Dashboard Routes
$route['user/dashboard/laporan'] = 'user/Dashboard/laporan';
$route['user/dashboard/tambah'] = 'user/Dashboard/tambah';
$route['user/dashboard/detail/(:num)'] = 'user/Dashboard/detail/$1';
$route['user/dashboard/edit/(:num)'] = 'user/Dashboard/edit/$1';
$route['user/dashboard/hapus/(:num)'] = 'user/Dashboard/hapus/$1';
$route['user/dashboard/profile'] = 'user/Dashboard/profile';

// Report Admin Routes
$route['user/laporan_admin'] = 'user/Laporan_admin/index';
$route['user/laporan_admin/tambah'] = 'user/Laporan_admin/tambah';
$route['user/laporan_admin/simpan'] = 'user/Laporan_admin/simpan';
$route['user/laporan_admin/detail/(:num)'] = 'user/Laporan_admin/detail/$1';
$route['user/laporan_admin/hapus/(:num)'] = 'user/Laporan_admin/hapus/$1';
$route['user/laporan_admin/edit/(:num)'] = 'user/Laporan_admin/edit/$1';
$route['user/laporan_admin/update/(:num)'] = 'user/Laporan_admin/update/$1';

// Tambahan untuk kemudahan navigasi
$route['user/dashboard/laporan_admin'] = 'user/Laporan_admin/index';
$route['user/dashboard/tambah_laporan_admin'] = 'user/Laporan_admin/tambah';

// =============================================
// USER FORGOT PASSWORD ROUTES
// =============================================
$route['user/forgot_password'] = 'user/Forgot_password/forgot_password';
$route['user/forgot_password/process'] = 'user/Forgot_password/process_forgot_password';
$route['user/reset_password/verify'] = 'user/Forgot_password/verify';
$route['user/reset_password/verify_otp'] = 'user/Forgot_password/verify_otp';
$route['user/reset_password'] = 'user/Forgot_password/reset_password';
$route['user/reset_password/process'] = 'user/Forgot_password/process_reset_password';
$route['user/reset_password/resend'] = 'user/Forgot_password/resend_otp';

// =============================================
// ADMIN ROUTES - TIDAK PERLU DIUBAH (sudah benar)
// =============================================
$route['admin'] = 'admin/Admin/index';
$route['admin/login'] = 'admin/Admin/login';
$route['admin/login/action'] = 'admin/Admin/action';
$route['admin/login/proses'] = 'admin/Admin/proses';
$route['admin/logout'] = 'admin/Admin/logout';
$route['admin/dashboard'] = 'admin/Admin/dashboard';
$route['admin/dashboard/set_kos/(:num)'] = 'admin/Admin/set_kos/$1';
// Tambahkan sebelum admin routes yang lain:
$route['admin/laporan_admin_reports'] = 'admin/Admin/laporan_admin_reports';
$route['admin/update_report_status/(:num)'] = 'admin/Admin/update_report_status/$1';

// Admin menu routes
$route['admin/chat'] = 'admin/chat';
$route['admin/iklan'] = 'admin/iklan';
$route['admin/kos'] = 'admin/kos';
$route['admin/laporan'] = 'admin/laporan';
$route['admin/pengaturan'] = 'admin/pengaturan';
$route['admin/penghuni'] = 'admin/penghuni';
$route['admin/register'] = 'admin/register';
$route['admin/subscription'] = 'admin/subscription';

// Admin Forgot Password Routes
$route['admin/forgot_password'] = 'admin/Forgot_password/index';
$route['admin/forgot_password/process_request'] = 'admin/Forgot_password/process_request';
$route['admin/forgot_password/verify'] = 'admin/Forgot_password/verify';
$route['admin/forgot_password/verify_code'] = 'admin/Forgot_password/verify_code';
$route['admin/forgot_password/reset'] = 'admin/Forgot_password/reset';
$route['admin/forgot_password/process_reset'] = 'admin/Forgot_password/process_reset';
$route['admin/forgot_password/resend_code'] = 'admin/Forgot_password/resend_code';
$route['admin/forgot_password/cancel'] = 'admin/Forgot_password/cancel';
$route['admin/forgot_password/test_email'] = 'admin/Forgot_password/test_email';
$route['admin/forgot_password/test_email/(:any)'] = 'admin/Forgot_password/test_email/$1';
$route['admin/forgot_password/test_process'] = 'admin/Forgot_password/test_process';

// =============================================
// CHAT API ROUTES
// =============================================
$route['api/chat/authenticate'] = 'api/Chat_api/authenticate';
$route['api/chat/messages'] = 'api/Chat_api/messages';
$route['api/chat/messages/(:num)'] = 'api/Chat_api/messages/id/$1';
$route['api/chat/read'] = 'api/Chat_api/read';
$route['api/chat/unread'] = 'api/Chat_api/unread';
$route['api/chat/online_status'] = 'Chat_api/online_status';

// =============================================
// CHAT WEB ROUTES (HAPUS YANG INI - KONFLIK)
// =============================================
// HAPUS BARIS-BARIS INI:
// $route['admin/chat'] = 'admin/chat';
// $route['admin/chat/(:num)'] = 'admin/chat/index/$1';
$route['user/chat'] = 'user/chat';

// =============================================
// ADMIN CHAT ROUTES (API)
// =============================================
$route['admin/chat/list'] = 'admin/chat/chat_list';
$route['admin/chat/api/send'] = 'admin/chat/send';
$route['admin/chat/api/messages'] = 'admin/chat/get_messages';
$route['admin/chat/api/list'] = 'admin/chat/get_chat_list';
$route['admin/chat/api/unread'] = 'admin/chat/get_unread_count';
$route['admin/chat/api/unread/(:num)'] = 'admin/chat/get_unread_count_penghuni/$1';
$route['admin/chat/api/mark-read'] = 'admin/chat/mark_as_read';
$route['admin/chat/api/online/(:num)'] = 'admin/chat/get_online_status/$1';
$route['admin/chat/api/search'] = 'admin/chat/search_penghuni';
$route['admin/chat/api/delete'] = 'admin/chat/delete_message';
$route['admin/chat/api/clear'] = 'admin/chat/clear_chat';
$route['admin/chat/api/stats'] = 'admin/chat/get_statistics';
$route['admin/chat/api/typing'] = 'admin/chat/typing_status';
$route['admin/chat/api/status'] = 'admin/chat/check_server_status';
$route['admin/chat/export/(:num)'] = 'admin/chat/export_chat/$1';
$route['admin/chat/test-ws'] = 'admin/chat/test_websocket';
// =============================================
// CRON JOB ROUTES
// =============================================
$route['cron/activate_suspended_admins'] = 'Cron/activate_suspended_admins';
$route['cron/check_suspend_status'] = 'Cron/check_suspend_status';
$route['cron/cleanup_logs'] = 'Cron/cleanup_logs';
$route['cron/test'] = 'Cron/test';

// =============================================
// DEFAULT ROUTES (Backward Compatibility)
// =============================================
// Untuk kemudahan akses, tambahkan juga routes lengkap dengan controller path
$route['superadmin/superadmin/dashboard'] = 'superadmin/Superadmin/dashboard';
$route['superadmin/superadmin/admin_list'] = 'superadmin/Superadmin/admin_list';
$route['superadmin/superadmin/admin_form'] = 'superadmin/Superadmin/admin_form';
$route['superadmin/superadmin/admin_form/(:num)'] = 'superadmin/Superadmin/admin_form/$1';
$route['superadmin/superadmin/save_admin'] = 'superadmin/Superadmin/save_admin';
$route['superadmin/superadmin/delete_admin/(:num)'] = 'superadmin/Superadmin/delete_admin/$1';
$route['superadmin/superadmin/kos_list'] = 'superadmin/Superadmin/kos_list';
$route['superadmin/superadmin/kos_form'] = 'superadmin/Superadmin/kos_form';
$route['superadmin/superadmin/kos_form/(:num)'] = 'superadmin/Superadmin/kos_form/$1';
$route['superadmin/superadmin/save_kos'] = 'superadmin/Superadmin/save_kos';
$route['superadmin/superadmin/delete_kos/(:num)'] = 'superadmin/Superadmin/delete_kos/$1';
$route['superadmin/superadmin/report_list'] = 'superadmin/Superadmin/report_list';
$route['superadmin/superadmin/report_detail/(:num)'] = 'superadmin/Superadmin/report_detail/$1';
$route['superadmin/superadmin/process_report'] = 'superadmin/Superadmin/process_report';
$route['superadmin/superadmin/activate_admin/(:num)'] = 'superadmin/Superadmin/activate_admin/$1';
$route['superadmin/superadmin/logout'] = 'superadmin/Superadmin/logout';

// =============================================
// SUPER ADMIN FORGOT PASSWORD ROUTES
// =============================================
$route['superadmin/forgot_password'] = 'superadmin/Forgot_password/index';
$route['superadmin/forgot_password/process_request'] = 'superadmin/Forgot_password/process_request';
$route['superadmin/forgot_password/verify'] = 'superadmin/Forgot_password/verify';
$route['superadmin/forgot_password/verify_code'] = 'superadmin/Forgot_password/verify_code';
$route['superadmin/forgot_password/reset'] = 'superadmin/Forgot_password/reset';
$route['superadmin/forgot_password/process_reset'] = 'superadmin/Forgot_password/process_reset';
$route['superadmin/forgot_password/resend_code'] = 'superadmin/Forgot_password/resend_code';
$route['superadmin/forgot_password/cancel'] = 'superadmin/Forgot_password/cancel';
$route['superadmin/forgot_password/test_email/(:any)'] = 'superadmin/Forgot_password/test_email/$1';
