<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Iklan extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();

        if (!$this->session->userdata('admin_logged_in')) {
            redirect('admin/login');
        }

        $this->load->model('admin/Iklan_model');
        $this->load->model('admin/Kos_model');
        $this->load->helper(['form', 'url']);
        $this->load->library(['upload', 'session']);
    }

    public function index()
    {
        $data['title'] = 'Manajemen Iklan';
        $id_admin = $this->session->userdata('id_admin');
        $data['iklan'] = $this->Iklan_model->get_all_by_admin($id_admin);
        $this->load->view('admin/iklan/index', $data);
    }

    public function tambah()
    {
        $data['title'] = 'Tambah Iklan';
        $id_admin = $this->session->userdata('id_admin');
        $data['list_kos'] = $this->Kos_model->get_by_admin($id_admin);

        if ($this->input->post()) {
            $config['upload_path'] = FCPATH . 'asset/iklan/';
            $config['allowed_types'] = 'jpg|jpeg|png|gif';
            $config['max_size'] = 2048;
            $config['encrypt_name'] = TRUE;

            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path'], 0777, TRUE);
            }

            $this->upload->initialize($config);

            if ($this->upload->do_upload('gambar')) {
                $upload_data = $this->upload->data();

                // DATA TANPA TIMESTAMP
                $data_iklan = [
                    'id_admin' => $this->session->userdata('id_admin'),
                    'id_kos' => $this->input->post('id_kos'),
                    'judul' => $this->input->post('judul'),
                    'deskripsi' => $this->input->post('deskripsi'),
                    'gambar' => $upload_data['file_name'],
                    'link' => $this->input->post('link'),
                    'urutan' => $this->input->post('urutan'),
                    'status' => $this->input->post('status'),
                ];

                if ($this->Iklan_model->insert($data_iklan)) {
                    $this->session->set_flashdata('success', 'Iklan berhasil ditambahkan!');
                    redirect('admin/iklan');
                } else {
                    $this->session->set_flashdata('error', 'Gagal menyimpan data ke database!');
                }
            } else {
                $data['error'] = $this->upload->display_errors();
            }
        }

        $this->load->view('admin/iklan/tambah', $data);
    }

    public function edit($id)
    {
        $data['iklan'] = $this->Iklan_model->get_by_id($id);

        if (!$data['iklan']) {
            show_404();
        }

        $id_admin = $this->session->userdata('id_admin');
        $data['list_kos'] = $this->Kos_model->get_by_admin($id_admin);
        $data['title'] = 'Edit Iklan';

        if ($this->input->post()) {
            // DATA TANPA TIMESTAMP
            $update_data = [
                'id_kos' => $this->input->post('id_kos'),
                'judul' => $this->input->post('judul'),
                'deskripsi' => $this->input->post('deskripsi'),
                'link' => $this->input->post('link'),
                'urutan' => $this->input->post('urutan'),
                'status' => $this->input->post('status'),
            ];

            if (!empty($_FILES['gambar']['name'])) {
                $config['upload_path'] = FCPATH . 'asset/iklan/';
                $config['allowed_types'] = 'jpg|jpeg|png|gif';
                $config['max_size'] = 2048;
                $config['encrypt_name'] = TRUE;

                $this->upload->initialize($config);

                if ($this->upload->do_upload('gambar')) {
                    $upload_data = $this->upload->data();

                    if (!empty($data['iklan']->gambar) && file_exists(FCPATH . 'asset/iklan/' . $data['iklan']->gambar)) {
                        unlink(FCPATH . 'asset/iklan/' . $data['iklan']->gambar);
                    }

                    $update_data['gambar'] = $upload_data['file_name'];
                } else {
                    $this->session->set_flashdata('error', $this->upload->display_errors());
                }
            }

            if ($this->Iklan_model->update($id, $update_data)) {
                $this->session->set_flashdata('success', 'Iklan berhasil diupdate!');
            } else {
                $this->session->set_flashdata('error', 'Gagal mengupdate data!');
            }

            redirect('admin/iklan');
        }

        $this->load->view('admin/iklan/edit', $data);
    }

    public function hapus($id)
    {
        $iklan = $this->Iklan_model->get_by_id($id);

        if ($iklan) {
            if (!empty($iklan->gambar)) {
                $file_path = FCPATH . 'asset/iklan/' . $iklan->gambar;
                if (file_exists($file_path)) {
                    unlink($file_path);
                }
            }

            if ($this->Iklan_model->delete($id)) {
                $this->session->set_flashdata('success', 'Iklan berhasil dihapus!');
            } else {
                $this->session->set_flashdata('error', 'Gagal menghapus iklan!');
            }
        }

        redirect('admin/iklan');
    }
}
