<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Forgot_password extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('superadmin/Forgot_password_model');
        $this->load->model('superadmin/Superadmin_model');
        $this->load->library('session');
        $this->load->helper(['url', 'form', 'string']);
    }

    // Halaman permintaan reset password
    public function index()
    {
        if ($this->session->userdata('super_admin_logged_in')) {
            redirect('superadmin/superadmin/dashboard');
        }
        $this->load->view('superadmin/forgot_password/request_form');
    }

    // Proses permintaan reset password - TAMPILKAN OTP LANGSUNG
    public function process_request()
    {
        $email = $this->input->post('email');

        // Validasi email
        $super_admin = $this->Forgot_password_model->get_by_email($email);

        if (!$super_admin) {
            $this->session->set_flashdata('error', 'Email tidak terdaftar');
            redirect('superadmin/forgot_password');
        }

        // Generate OTP (6 digit angka)
        $otp = str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT);

        // Simpan OTP ke database
        $this->Forgot_password_model->save_otp($email, $otp);

        // Simpan data di session
        $this->session->set_userdata([
            'reset_email' => $email,
            'otp_shown' => $otp // Simpan OTP di session untuk ditampilkan
        ]);

        // Redirect ke halaman show OTP
        redirect('superadmin/forgot_password/show_otp');
    }

    // Halaman TAMPILKAN OTP
    public function show_otp()
    {
        if (!$this->session->userdata('reset_email')) {
            redirect('superadmin/forgot_password');
        }

        $data['email'] = $this->session->userdata('reset_email');
        $data['otp'] = $this->session->userdata('otp_shown');

        $this->load->view('superadmin/forgot_password/show_otp', $data);
    }

    // Halaman verifikasi OTP
    public function verify()
    {
        if (!$this->session->userdata('reset_email')) {
            redirect('superadmin/forgot_password');
        }

        $data['email'] = $this->session->userdata('reset_email');
        $this->load->view('superadmin/forgot_password/verify_otp', $data);
    }

    // Proses verifikasi OTP
    public function verify_code()
    {
        if (!$this->session->userdata('reset_email')) {
            redirect('superadmin/forgot_password');
        }

        $email = $this->session->userdata('reset_email');
        $otp = $this->input->post('otp');

        // Validasi OTP
        $super_admin = $this->Forgot_password_model->validate_otp($email, $otp);

        if (!$super_admin) {
            $this->session->set_flashdata('error', 'Kode OTP tidak valid atau telah kadaluarsa');
            redirect('superadmin/forgot_password/verify');
        }

        // Set session untuk reset password
        $this->session->set_userdata('otp_verified', true);
        redirect('superadmin/forgot_password/reset');
    }

    // Halaman reset password
    public function reset()
    {
        if (!$this->session->userdata('reset_email') || !$this->session->userdata('otp_verified')) {
            redirect('superadmin/forgot_password');
        }

        $data['email'] = $this->session->userdata('reset_email');
        $this->load->view('superadmin/forgot_password/reset_password', $data);
    }

    // Proses reset password
    public function process_reset()
    {
        if (!$this->session->userdata('reset_email') || !$this->session->userdata('otp_verified')) {
            redirect('superadmin/forgot_password');
        }

        $email = $this->session->userdata('reset_email');
        $password = $this->input->post('password');
        $confirm_password = $this->input->post('confirm_password');

        // Validasi password
        if (strlen($password) < 6) {
            $this->session->set_flashdata('error', 'Password minimal 6 karakter');
            redirect('superadmin/forgot_password/reset');
        }

        if ($password !== $confirm_password) {
            $this->session->set_flashdata('error', 'Password dan konfirmasi password tidak cocok');
            redirect('superadmin/forgot_password/reset');
        }

        // Reset password di database
        $this->Forgot_password_model->reset_password($email, $password);

        // Clear session
        $this->session->unset_userdata(['reset_email', 'otp_verified', 'otp_shown']);

        $this->session->set_flashdata('success', 'Password berhasil direset! Silakan login dengan password baru');
        redirect('superadmin');
    }

    // Generate OTP baru
    public function resend_code()
    {
        if (!$this->session->userdata('reset_email')) {
            redirect('superadmin/forgot_password');
        }

        $email = $this->session->userdata('reset_email');

        // Generate OTP baru
        $otp = str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT);

        // Simpan OTP ke database
        $this->Forgot_password_model->save_otp($email, $otp);

        // Update session
        $this->session->set_userdata('otp_shown', $otp);

        redirect('superadmin/forgot_password/show_otp');
    }

    // Batalkan proses
    public function cancel()
    {
        $this->session->unset_userdata(['reset_email', 'otp_verified', 'otp_shown']);
        $this->session->set_flashdata('info', 'Proses reset password dibatalkan');
        redirect('superadmin');
    }

    // Testing - Generate OTP untuk email tertentu
    public function generate_otp($email = '')
    {
        if (empty($email)) {
            echo "Masukkan email: /superadmin/forgot_password/generate_otp/email@example.com";
            return;
        }

        $otp = str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT);
        $this->Forgot_password_model->save_otp($email, $otp);

        echo "<h3>OTP untuk $email</h3>";
        echo "<div style='font-size: 40px; font-weight: bold; color: #667eea;'>$otp</div>";
        echo "<p>OTP telah disimpan di database.</p>";
        echo "<p><a href='" . site_url('superadmin/forgot_password') . "'>Kembali ke Lupa Password</a></p>";
    }
}
