<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Laporan extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('user/Laporan_model');
        $this->load->model('user/Penghuni_model');
        $this->load->library('session');
        $this->load->helper(array('url', 'form', 'security', 'text'));
        if (!$this->session->userdata('user_logged_in')) {
            redirect('user/login');
        }
    }
    private function get_user_data()
    {
        $id_penghuni = $this->session->userdata('user_id');
        return $this->Penghuni_model->get_by_id($id_penghuni);
    }
    public function index()
    {
        $id_penghuni = $this->session->userdata('user_id');
        $data['user'] = $this->get_user_data();
        $data['laporan'] = $this->Laporan_model->get_by_penghuni($id_penghuni);
        $data['title'] = 'Laporan Saya';

        $this->load->view('user/dashboard/laporan', $data);
    }
    public function buat_laporan()
    {
        $data['user'] = $this->get_user_data();
        $data['title'] = 'Buat Laporan Baru';

        $this->load->view('user/dashboard/tambah', $data);
    }
    public function simpan()
    {
        $this->load->library('form_validation');
        $this->form_validation->set_rules('judul', 'Judul', 'required|trim|max_length[150]');
        $this->form_validation->set_rules('deskripsi', 'Deskripsi', 'required|trim');
        if ($this->form_validation->run() == FALSE) {
            $this->buat_laporan();
        } else {
            $config['upload_path']   = './asset/laporan/';
            $config['allowed_types'] = 'gif|jpg|jpeg|png';
            $config['max_size']      = 2048;
            $config['encrypt_name']  = TRUE;
            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path'], 0755, true);
            }
            $this->load->library('upload', $config);
            $gambar = NULL;
            if (!empty($_FILES['gambar']['name'])) {
                if ($this->upload->do_upload('gambar')) {
                    $upload_data = $this->upload->data();
                    $gambar = $upload_data['file_name'];
                } else {
                    $this->session->set_flashdata('error', 'Gagal upload gambar: ' . $this->upload->display_errors());
                    redirect('user/dashboard/tambah');
                    return;
                }
            }
            $id_penghuni = $this->session->userdata('user_id');
            $id_kos = $this->session->userdata('id_kos');
            $data = array(
                'id_penghuni' => $id_penghuni,
                'id_kos'      => $id_kos,
                'judul'       => $this->input->post('judul', true),
                'deskripsi'   => $this->input->post('deskripsi', true),
                'gambar'      => $gambar,
                'status'      => 'Diajukan'
            );
            if ($this->Laporan_model->insert($data)) {
                $this->session->set_flashdata('success', 'Laporan berhasil dibuat.');
                redirect('user/dashboard/laporan');
            } else {
                if ($gambar && file_exists('./asset/laporan/' . $gambar)) {
                    unlink('./asset/laporan/' . $gambar);
                }
                $this->session->set_flashdata('error', 'Gagal membuat laporan.');
                redirect('user/dashboard/tambah');
            }
        }
    }
    public function detail($id_laporan)
    {
        $id_penghuni = $this->session->userdata('user_id');
        $laporan = $this->Laporan_model->get_by_id($id_laporan);
        if (!$laporan || $laporan->id_penghuni != $id_penghuni) {
            $this->session->set_flashdata('error', 'Laporan tidak ditemukan.');
            redirect('user/dashboard/laporan');
        }
        $data['user'] = $this->get_user_data();
        $data['laporan'] = $laporan;
        $data['title'] = 'Detail Laporan';
        $this->load->view('user/dashboard/detail', $data);
    }
    public function edit($id_laporan)
    {
        $id_penghuni = $this->session->userdata('user_id');
        $laporan = $this->Laporan_model->get_by_id($id_laporan);
        if (!$laporan || $laporan->id_penghuni != $id_penghuni) {
            $this->session->set_flashdata('error', 'Laporan tidak ditemukan.');
            redirect('user/dashboard/laporan');
        }
        $data['user'] = $this->get_user_data();
        $data['laporan'] = $laporan;
        $data['title'] = 'Edit Laporan';
        $this->load->view('user/dashboard/edit', $data);
    }
    public function update()
    {
        $this->load->library('form_validation');
        $id_laporan = $this->input->post('id_laporan');
        $id_penghuni = $this->session->userdata('user_id');
        $laporan = $this->Laporan_model->get_by_id($id_laporan);
        if (!$laporan || $laporan->id_penghuni != $id_penghuni) {
            $this->session->set_flashdata('error', 'Laporan tidak ditemukan.');
            redirect('user/dashboard/laporan');
        }
        $this->form_validation->set_rules('judul', 'Judul', 'required|trim|max_length[150]');
        $this->form_validation->set_rules('deskripsi', 'Deskripsi', 'required|trim');
        if ($this->form_validation->run() == FALSE) {
            $this->edit($id_laporan);
        } else {
            $config['upload_path']   = './asset/laporan/';
            $config['allowed_types'] = 'gif|jpg|jpeg|png';
            $config['max_size']      = 2048;
            $config['encrypt_name']  = TRUE;
            $this->load->library('upload', $config);
            $gambar = $laporan->gambar;
            if (!empty($_FILES['gambar']['name'])) {
                if ($this->upload->do_upload('gambar')) {
                    if ($laporan->gambar && file_exists('./asset/laporan/' . $laporan->gambar)) {
                        unlink('./asset/laporan/' . $laporan->gambar);
                    }
                    $upload_data = $this->upload->data();
                    $gambar = $upload_data['file_name'];
                } else {
                    $this->session->set_flashdata('error', 'Gagal upload gambar: ' . $this->upload->display_errors());
                    redirect('user/dashboard/edit/' . $id_laporan);
                    return;
                }
            }
            $data = array(
                'judul' => $this->input->post('judul', true),
                'deskripsi' => $this->input->post('deskripsi', true),
                'gambar' => $gambar
            );
            if ($this->Laporan_model->update($id_laporan, $data)) {
                $this->session->set_flashdata('success', 'Laporan berhasil diperbarui.');
                redirect('user/dashboard/laporan');
            } else {
                $this->session->set_flashdata('error', 'Gagal memperbarui laporan.');
                redirect('user/dashboard/edit/' . $id_laporan);
            }
        }
    }
    public function hapus($id_laporan)
    {
        $id_penghuni = $this->session->userdata('user_id');
        $laporan = $this->Laporan_model->get_by_id($id_laporan);
        if (!$laporan || $laporan->id_penghuni != $id_penghuni) {
            $this->session->set_flashdata('error', 'Laporan tidak ditemukan.');
            redirect('user/dashboard/laporan');
        }
        if ($laporan->gambar && file_exists('./asset/laporan/' . $laporan->gambar)) {
            unlink('./asset/laporan/' . $laporan->gambar);
        }
        if ($this->Laporan_model->delete($id_laporan)) {
            $this->session->set_flashdata('success', 'Laporan berhasil dihapus.');
        } else {
            $this->session->set_flashdata('error', 'Gagal menghapus laporan.');
        }
        redirect('user/dashboard/laporan');
    }
}
