<?php
/**
 * 🔥 CUSTOM OVERRIDE untuk Midtrans ApiRequestor
 * Fix: Undefined array key 10023
 * 
 * Letakkan file ini di: application/libraries/Midtrans_override.php
 * Lalu load di controller Subscription:
 * $this->load->library('midtrans_override');
 */

defined('BASEPATH') or exit('No direct script access allowed');

class Midtrans_override
{
    protected $CI;

    public function __construct()
    {
        $this->CI =& get_instance();
        
        // Override default cURL error handling
        $this->setup_curl_error_suppression();
    }

    /**
     * Setup custom error suppression for cURL
     */
    private function setup_curl_error_suppression()
    {
        // Set custom error handler untuk suppress warning dari Midtrans
        set_error_handler(function($errno, $errstr, $errfile, $errline) {
            // Ignore Midtrans ApiRequestor warnings
            if (strpos($errfile, 'Midtrans/ApiRequestor.php') !== false) {
                if (strpos($errstr, 'Undefined array key') !== false) {
                    // Log it but don't display
                    log_message('debug', 'Suppressed Midtrans warning: ' . $errstr);
                    return true; // Suppress warning
                }
            }
            
            // Let other errors pass through
            return false;
        }, E_WARNING | E_NOTICE);
    }

    /**
     * Custom cURL options untuk Midtrans
     * Menambahkan error handling yang lebih baik
     */
    public function get_curl_options()
    {
        return [
            CURLOPT_SSL_VERIFYHOST => 0,
            CURLOPT_SSL_VERIFYPEER => 0,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 60,
            CURLOPT_CONNECTTIMEOUT => 30,
            CURLOPT_FAILONERROR => false, // Don't throw error on HTTP errors
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        ];
    }
}