<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Admin_model extends CI_Model
{
    protected $table = 'admin';
    public function __construct()
    {
        parent::__construct();
    }
    public function get_by_email($email)
    {
        return $this->db->get_where($this->table, ['email' => $email])->row();
    }
    public function is_admin_suspended($admin_id)
    {
        $this->db->select('is_suspended, suspended_until, status, suspension_reason');
        $this->db->from($this->table);
        $this->db->where('id', $admin_id);
        $admin = $this->db->get()->row();
        if (!$admin) {
            return ['suspended' => false, 'type' => 'unknown'];
        }
        if ($admin->status == 'nonaktif' && $admin->is_suspended == 1 && $admin->suspended_until === null) {
            return [
                'suspended' => true,
                'type' => 'permanent',
                'reason' => $admin->suspension_reason ?: 'Tidak disebutkan',
                'admin_data' => $admin
            ];
        }
        if ($admin->is_suspended == 1 && $admin->suspended_until !== null) {
            $suspended_until = strtotime($admin->suspended_until);
            $current_time = time();

            if ($suspended_until > $current_time) {
                $days_left = ceil(($suspended_until - $current_time) / (60 * 60 * 24));
                return [
                    'suspended' => true,
                    'type' => 'temporary',
                    'until' => $admin->suspended_until,
                    'days_left' => $days_left,
                    'reason' => $admin->suspension_reason ?: 'Tidak disebutkan',
                    'admin_data' => $admin
                ];
            } else {
                return [
                    'suspended' => false,
                    'type' => 'expired',
                    'was_suspended' => true
                ];
            }
        }
        return [
            'suspended' => false,
            'type' => 'active',
            'admin_data' => $admin
        ];
    }
    public function get_with_suspend_info($admin_id)
    {
        $this->db->select('*, 
            CASE 
                WHEN status = "nonaktif" AND is_suspended = 1 AND suspended_until IS NULL THEN "permanent"
                WHEN is_suspended = 1 AND suspended_until IS NOT NULL AND suspended_until > NOW() THEN "temporary"
                ELSE "active"
            END as suspend_status,
            DATEDIFF(suspended_until, NOW()) as suspend_days_left
        ');
        $this->db->from($this->table);
        $this->db->where('id', $admin_id);
        return $this->db->get()->row();
    }
    public function insert_admin($data)
    {
        $this->db->insert($this->table, $data);
        return $this->db->insert_id();
    }
    public function insert($data)
    {
        return $this->insert_admin($data);
    }
    public function get_all()
    {
        return $this->db->get($this->table)->result();
    }
    public function get($id)
    {
        return $this->db->get_where($this->table, ['id' => $id])->row();
    }
    public function update($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update($this->table, $data);
    }
    public function delete($id)
    {
        return $this->db->where('id', $id)->delete($this->table);
    }
    public function count_all()
    {
        return $this->db->count_all($this->table);
    }
    public function get_suspended_admins()
    {
        $this->db->where('is_suspended', 1);
        return $this->db->get($this->table)->result();
    }
    public function get_expired_suspensions()
    {
        $this->db->where('is_suspended', 1);
        $this->db->where('suspended_until IS NOT NULL');
        $this->db->where('suspended_until <=', date('Y-m-d H:i:s'));
        return $this->db->get($this->table)->result();
    }
    public function activate_after_suspension($admin_id)
    {
        $data = [
            'is_suspended' => 0,
            'suspended_until' => null,
            'suspension_reason' => null,
            'status' => 'aktif',
            'updated_at' => date('Y-m-d H:i:s')
        ];

        return $this->update($admin_id, $data);
    }
    public function get_admin_by_kos($id_kos)
    {
        $this->db->select('admin.*');
        $this->db->from('admin');
        $this->db->join('kos', 'kos.id_admin = admin.id');
        $this->db->where('kos.id_kos', $id_kos);
        return $this->db->get()->row();
    }
}
