<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Iklan_model extends CI_Model
{
    protected $table = 'iklan';

    // Ambil semua iklan milik admin yang login
    public function get_all()
    {
        $id_admin = $this->session->userdata('id_admin');
        $this->db->where('id_admin', $id_admin);
        $this->db->order_by('urutan', 'ASC');
        return $this->db->get($this->table)->result();
    }

    // Ambil iklan berdasarkan id_admin
    public function get_all_by_admin($id_admin)
    {
        $this->db->where('id_admin', $id_admin);
        $this->db->order_by('urutan', 'ASC');
        return $this->db->get($this->table)->result();
    }

    // Ambil iklan berdasarkan ID
    public function get_by_id($id)
    {
        return $this->db->get_where($this->table, ['id_iklan' => $id])->row();
    }

    // Ambil iklan berdasarkan kos
    public function get_by_kos($id_kos)
    {
        $this->db->where('id_kos', $id_kos);
        $this->db->where('status', 'Aktif');
        $this->db->order_by('urutan', 'ASC');
        return $this->db->get($this->table)->result();
    }

    // Tambah iklan
    public function insert($data)
    {
        return $this->db->insert($this->table, $data);
    }

    // Update iklan
    public function update($id, $data)
    {
        $this->db->where('id_iklan', $id);
        return $this->db->update($this->table, $data);
    }

    // Hapus iklan
    public function delete($id)
    {
        $this->db->where('id_iklan', $id);
        return $this->db->delete($this->table);
    }

    // Hitung total iklan per admin
    public function count_by_admin($id_admin)
    {
        $this->db->where('id_admin', $id_admin);
        return $this->db->count_all_results($this->table);
    }

    // Ambil iklan aktif untuk slider
    public function get_aktif_for_slider($limit = 5)
    {
        $id_admin = $this->session->userdata('id_admin');
        $this->db->where('id_admin', $id_admin);
        $this->db->where('status', 'Aktif');
        $this->db->order_by('urutan', 'ASC');
        $this->db->limit($limit);
        return $this->db->get($this->table)->result();
    }
}
