<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Kos_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    // ✅ Ambil semua kos milik admin tertentu
    public function get_by_admin($id_admin)
    {
        $this->db->where('id_admin', $id_admin);
        return $this->db->get('kos')->result();
    }

    // ✅ Ambil semua kos
    public function get_all()
    {
        return $this->db->get('kos')->result();
    }

    // ✅ Ambil satu kos berdasarkan ID
    public function get_by_id($id)
    {
        return $this->db->get_where('kos', ['id_kos' => $id])->row();
    }

    // ✅ Tambah kos
    public function insert($data)
    {
        return $this->db->insert('kos', $data);
    }

    // ✅ Update kos
    public function update($id, $data)
    {
        $this->db->where('id_kos', $id);
        return $this->db->update('kos', $data);
    }

    // ✅ Hapus kos
    public function delete($id)
    {
        return $this->db->delete('kos', ['id_kos' => $id]);
    }
    public function get_all_penghuni_by_admin($id_admin)
    {
        $this->db->select('penghuni.id_penghuni, penghuni.nama_penghuni, kos.nama_kos');
        $this->db->from('penghuni');
        $this->db->join('kos', 'kos.id_kos = penghuni.id_kos');
        $this->db->where('kos.id_admin', $id_admin);
        return $this->db->get()->result();
    }
}
