<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Laporan_model extends CI_Model
{

    private $table = 'laporan';

    public function __construct()
    {
        parent::__construct();
    }

    // ========== METHOD UNTUK DASHBOARD ==========

    // Hitung semua laporan
    public function count_all()
    {
        return $this->db->count_all($this->table);
    }

    // Hitung laporan berdasarkan status
    public function count_by_status($status)
    {
        $this->db->where('status', $status);
        return $this->db->count_all_results($this->table);
    }

    // Ambil aktivitas terbaru untuk dashboard
    public function get_recent_activities($limit = 10)
    {
        $this->db->select('laporan.*, penghuni.nama_penghuni');
        $this->db->from($this->table);
        $this->db->join('penghuni', 'penghuni.id_penghuni = laporan.id_penghuni', 'left');
        $this->db->order_by('laporan.tanggal_laporan', 'DESC');
        $this->db->limit($limit);
        $query = $this->db->get();
        return $query->result();
    }

    // ========== METHOD UNTUK LAPORAN (CRUD) ==========

    // Ambil semua laporan (join dengan tabel penghuni)
    // DITAMBAHKAN FILTER OPSIONAL BERDASARKAN id_kos
    public function get_all($id_kos = null)
    {
        $this->db->select('laporan.*, penghuni.nama_penghuni');
        $this->db->from('laporan');
        $this->db->join('penghuni', 'laporan.id_penghuni = penghuni.id_penghuni', 'left');

        // 🔹 Filter agar hanya laporan dari kos admin login yang tampil
        if ($id_kos !== null) {
            $this->db->where('laporan.id_kos', $id_kos);
        }

        $this->db->order_by('laporan.tanggal_laporan', 'DESC');
        return $this->db->get()->result();
    }

    // Ambil laporan berdasarkan id
    public function get_by_id($id)
    {
        $this->db->select('laporan.*, penghuni.nama_penghuni');
        $this->db->from('laporan');
        $this->db->join('penghuni', 'laporan.id_penghuni = penghuni.id_penghuni', 'left');
        $this->db->where('laporan.id_laporan', $id);
        return $this->db->get()->row();
    }

    // 🔹 Ambil laporan berdasarkan id_kos (untuk keamanan edit/detail)
    public function get_by_kos($id_kos)
    {
        $this->db->select('laporan.*, penghuni.nama_penghuni');
        $this->db->from('laporan');
        $this->db->join('penghuni', 'laporan.id_penghuni = penghuni.id_penghuni', 'left');
        $this->db->where('laporan.id_kos', $id_kos);
        $this->db->order_by('laporan.tanggal_laporan', 'DESC');
        return $this->db->get()->result();
    }

    // Insert laporan baru
    public function insert($data)
    {
        return $this->db->insert($this->table, $data);
    }

    // Update laporan
    public function update($id, $data)
    {
        $this->db->where('id_laporan', $id);
        return $this->db->update($this->table, $data);
    }

    // Update status laporan
    public function update_status($id, $status)
    {
        $data = ['status' => $status];
        if ($status == 'Selesai') {
            $data['tanggal_selesai'] = date('Y-m-d H:i:s');
        }
        $this->db->where('id_laporan', $id);
        return $this->db->update('laporan', $data);
    }

    // Hapus laporan
    public function delete($id)
    {
        return $this->db->delete('laporan', ['id_laporan' => $id]);
    }

    // ========== EXPORT LAPORAN 1 BULAN TERAKHIR ==========

    // Model Laporan_model.php
    public function get_laporan_1_bulan_terakhir($id_kos = null)
    {
        $this->db->select('laporan.*, penghuni.nama_penghuni, kos.nama_kos');
        $this->db->from('laporan');
        $this->db->join('penghuni', 'laporan.id_penghuni = penghuni.id_penghuni', 'left');
        $this->db->join('kos', 'laporan.id_kos = kos.id_kos', 'left');

        // Jika id_kos diberikan, filter berdasarkan id_kos
        if ($id_kos !== null) {
            $this->db->where('laporan.id_kos', $id_kos);
        }

        // Hapus filter 1 bulan atau buat optional
        // $this->db->where('laporan.tanggal_laporan >=', date('Y-m-d', strtotime('-1 month')));

        $this->db->order_by('laporan.tanggal_laporan', 'DESC');
        return $this->db->get()->result_array();
    }
    public function count_all_by_kos($id_kos)
    {
        $this->db->where('id_kos', $id_kos);
        return $this->db->count_all_results($this->table);
    }

    // Hitung laporan berdasarkan status dan id_kos
    public function count_by_status_kos($status, $id_kos)
    {
        $this->db->where('status', $status);
        $this->db->where('id_kos', $id_kos);
        return $this->db->count_all_results($this->table);
    }

    // Ambil aktivitas terbaru berdasarkan id_kos
    public function get_recent_activities_kos($id_kos, $limit = 10)
    {
        $this->db->select('laporan.*, penghuni.nama_penghuni');
        $this->db->from($this->table);
        $this->db->join('penghuni', 'penghuni.id_penghuni = laporan.id_penghuni', 'left');
        $this->db->where('laporan.id_kos', $id_kos);
        $this->db->order_by('laporan.tanggal_laporan', 'DESC');
        $this->db->limit($limit);
        return $this->db->get()->result();
    }
    // Ambil aktivitas terbaru dari semua kos milik admin tertentu
    public function get_recent_activities_by_admin($id_admin, $limit = 10)
    {
        $this->db->select('laporan.*, penghuni.nama_penghuni, kos.nama_kos');
        $this->db->from('laporan');
        $this->db->join('penghuni', 'penghuni.id_penghuni = laporan.id_penghuni', 'left');
        $this->db->join('kos', 'kos.id_kos = laporan.id_kos', 'left');
        $this->db->where('kos.id_admin', $id_admin);
        $this->db->order_by('laporan.tanggal_laporan', 'DESC');
        $this->db->limit($limit);
        return $this->db->get()->result();
    }
}
