<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Landing_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    /**
     * Get statistics for landing page
     * @return array
     */
    public function get_statistics() {
        $stats = array(
            'total_penghuni' => $this->get_total_penghuni(),
            'total_laporan' => $this->get_total_laporan(),
            'laporan_selesai' => $this->get_laporan_selesai(),
            'kamar_tersedia' => $this->get_kamar_tersedia()
        );
        
        return $stats;
    }

    /**
     * Get total penghuni
     * @return int
     */
    private function get_total_penghuni() {
        return $this->db->count_all('penghuni');
    }

    /**
     * Get total laporan
     * @return int
     */
    private function get_total_laporan() {
        return $this->db->count_all('laporan');
    }

    /**
     * Get total laporan selesai
     * @return int
     */
    private function get_laporan_selesai() {
        $this->db->where('status', 'Selesai');
        return $this->db->count_all_results('laporan');
    }

    /**
     * Get total kamar tersedia
     * @return int
     */
    private function get_kamar_tersedia() {
        // Sesuaikan dengan struktur tabel kamar Anda
        $this->db->where('status', 'Tersedia'); // atau kondisi lain
        return $this->db->count_all_results('kamar');
    }

    /**
     * Get testimoni (jika ada tabel testimoni)
     * @param int $limit
     * @return array
     */
    public function get_testimoni($limit = 3) {
        $this->db->limit($limit);
        $this->db->order_by('created_at', 'DESC');
        $query = $this->db->get('testimoni');
        
        if ($query->num_rows() > 0) {
            return $query->result();
        }
        
        return array();
    }

    /**
     * Save contact form (jika ada form kontak)
     * @param array $data
     * @return bool
     */
    public function save_contact($data) {
        return $this->db->insert('contact_messages', $data);
    }
}