<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard_model extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Get user by ID
     */
    public function get_user_by_id($user_id)
    {
        $this->db->select('penghuni.*, kos.nama_kos'); // ambil juga nama kos
        $this->db->from('penghuni');
        $this->db->join('kos', 'kos.id_kos = penghuni.id_kos', 'left'); // join ke tabel kos
        $this->db->where('penghuni.id_penghuni', $user_id);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->row();
        }

        return null;
    }


    /**
     * Get user statistics
     */
    public function get_user_statistics($user_id)
    {
        $stats = array();

        // Total laporan
        $this->db->where('id_penghuni', $user_id);
        $stats['total_laporan'] = $this->db->count_all_results('laporan');

        // Laporan pending
        $this->db->where('id_penghuni', $user_id);
        $this->db->where('status', 'Diajukan');
        $stats['laporan_pending'] = $this->db->count_all_results('laporan');

        // Laporan diproses
        $this->db->where('id_penghuni', $user_id);
        $this->db->where('status', 'Diproses');
        $stats['laporan_proses'] = $this->db->count_all_results('laporan');

        // Laporan selesai
        $this->db->where('id_penghuni', $user_id);
        $this->db->where('status', 'Selesai');
        $stats['laporan_selesai'] = $this->db->count_all_results('laporan');

        return $stats;
    }

    /**
     * Get user laporan/reports
     */
    public function get_user_laporan($user_id, $limit = null)
    {
        $this->db->select('laporan.*, penghuni.nama_penghuni, penghuni.kamar');
        $this->db->from('laporan');
        $this->db->join('penghuni', 'penghuni.id_penghuni = laporan.id_penghuni');
        $this->db->where('laporan.id_penghuni', $user_id);
        $this->db->order_by('laporan.tanggal_laporan', 'DESC');

        if ($limit) {
            $this->db->limit($limit);
        }

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result();
        }

        return array();
    }

    /**
     * Get recent activities
     */
    public function get_recent_activities($user_id, $limit = 5)
    {
        $this->db->select('laporan.id_laporan, laporan.judul, laporan.status, laporan.tanggal_laporan');
        $this->db->from('laporan');
        $this->db->where('id_penghuni', $user_id);
        $this->db->order_by('tanggal_laporan', 'DESC');
        $this->db->limit($limit);

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result();
        }

        return array();
    }

    /**
     * Update user data
     */
    public function update_user($user_id, $data)
    {
        $this->db->where('id_penghuni', $user_id);
        return $this->db->update('penghuni', $data);
    }

    /**
     * Insert new laporan
     */
    public function insert_laporan($data)
    {
        return $this->db->insert('laporan', $data);
    }

    /**
     * Get laporan by ID (Unified - menggabungkan kedua versi)
     */
    public function get_laporan_by_id($id_laporan, $user_id = null)
    {
        $this->db->where('id_laporan', $id_laporan);

        // Jika user_id diberikan, tambahkan validasi kepemilikan
        if ($user_id !== null) {
            $this->db->where('id_penghuni', $user_id);
        }

        $query = $this->db->get('laporan');

        if ($query->num_rows() > 0) {
            return $query->row();
        }

        return null;
    }

    /**
     * Update laporan
     */
    public function update_laporan($id_laporan, $data)
    {
        $this->db->where('id_laporan', $id_laporan);
        return $this->db->update('laporan', $data);
    }

    /**
     * Delete laporan
     */
    public function delete_laporan($id_laporan)
    {
        $this->db->where('id_laporan', $id_laporan);
        return $this->db->delete('laporan');
    }

    /**
     * Get active advertisements/iklan
     * Mengambil iklan yang statusnya Aktif, diurutkan berdasarkan urutan
     */
    public function get_active_iklan($limit = null)
    {
        $this->db->select('*');
        $this->db->from('iklan');
        $this->db->where('status', 'Aktif');
        $this->db->order_by('urutan', 'ASC');
        $this->db->order_by('tanggal_dibuat', 'DESC');

        if ($limit) {
            $this->db->limit($limit);
        }

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result();
        }

        return array();
    }
    /**
     * Get iklan berdasarkan id_kos
     * Hanya menampilkan iklan yang statusnya Aktif dan sesuai dengan kos penghuni
     */
    public function get_iklan_by_kos($id_kos)
    {
        if (empty($id_kos)) {
            return array(); // Jika tidak ada id_kos, kembalikan kosong
        }

        $this->db->select('*');
        $this->db->from('iklan');
        $this->db->where('id_kos', $id_kos);
        $this->db->where('status', 'Aktif');
        $this->db->order_by('urutan', 'ASC');
        $this->db->order_by('tanggal_dibuat', 'DESC');

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result();
        }

        return array();
    }
}
