<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Report_user_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    // Create new report
    public function create($data)
    {
        $this->db->insert('reports', $data);
        return $this->db->insert_id();
    }

    // Get reports by penghuni
    public function get_by_penghuni($id_penghuni)
    {
        $this->db->select('r.*, a.nama as admin_nama, a.email as admin_email');
        $this->db->from('reports r');
        $this->db->join('admin a', 'a.id = r.id_admin', 'left');
        $this->db->where('r.id_penghuni', $id_penghuni);
        $this->db->order_by('r.created_at', 'DESC');
        return $this->db->get()->result();
    }

    // Get report by ID and penghuni
    public function get_by_id($id_report, $id_penghuni)
    {
        $this->db->select('r.*, a.nama as admin_nama, a.email as admin_email');
        $this->db->from('reports r');
        $this->db->join('admin a', 'a.id = r.id_admin', 'left');
        $this->db->where('r.id_report', $id_report);
        $this->db->where('r.id_penghuni', $id_penghuni);
        return $this->db->get()->row();
    }

    // Update report
    public function update($id_report, $data)
    {
        $this->db->where('id_report', $id_report);
        return $this->db->update('reports', $data);
    }

    // Delete report
    public function delete($id_report, $id_penghuni)
    {
        $this->db->where('id_report', $id_report);
        $this->db->where('id_penghuni', $id_penghuni);
        $this->db->where('status', 'pending'); // Hanya bisa hapus yang masih pending
        return $this->db->delete('reports');
    }

    // Get admin list for dropdown - PERBAIKAN: tidak mencari id_kos di tabel admin
    public function get_admin_options($id_kos)
    {
        // PERBAIKAN: Ambil admin berdasarkan id_admin di tabel kos
        // 1. Cari id_admin dari tabel kos
        $this->db->select('id_admin');
        $this->db->where('id_kos', $id_kos);
        $kos = $this->db->get('kos')->row();
        
        if (!$kos || !$kos->id_admin) {
            return array(); // Tidak ada admin untuk kos ini
        }
        
        // 2. Ambil detail admin berdasarkan id_admin
        $this->db->select('id, nama, email');
        $this->db->where('id', $kos->id_admin);
        $this->db->where('status', 'aktif');
        
        // Tambahkan kondisi untuk admin yang tidak disuspended
        $this->db->group_start();
        $this->db->where('is_suspended', 0);
        $this->db->or_where('suspended_until IS NULL', null, false);
        $this->db->or_where('suspended_until <', date('Y-m-d H:i:s'));
        $this->db->group_end();
        
        return $this->db->get('admin')->result();
    }

    // Get all active admins (alternative method)
    public function get_all_active_admins()
    {
        $this->db->select('id, nama, email');
        $this->db->where('status', 'aktif');
        
        // Tambahkan kondisi untuk admin yang tidak disuspended
        $this->db->group_start();
        $this->db->where('is_suspended', 0);
        $this->db->or_where('suspended_until IS NULL', null, false);
        $this->db->or_where('suspended_until <', date('Y-m-d H:i:s'));
        $this->db->group_end();
        
        $this->db->order_by('nama', 'ASC');
        return $this->db->get('admin')->result();
    }

    // Get admin by kos ID (for reporting)
    public function get_admin_by_kos_id($id_kos)
    {
        // Method 1: Join tables
        $this->db->select('a.id, a.nama, a.email');
        $this->db->from('admin a');
        $this->db->join('kos k', 'k.id_admin = a.id', 'inner');
        $this->db->where('k.id_kos', $id_kos);
        $this->db->where('a.status', 'aktif');
        
        // Tambahkan kondisi untuk admin yang tidak disuspended
        $this->db->group_start();
        $this->db->where('a.is_suspended', 0);
        $this->db->or_where('a.suspended_until IS NULL', null, false);
        $this->db->or_where('a.suspended_until <', date('Y-m-d H:i:s'));
        $this->db->group_end();
        
        return $this->db->get()->result();
    }
    
    // Check if admin exists and is active
    public function is_admin_active($admin_id)
    {
        $this->db->where('id', $admin_id);
        $this->db->where('status', 'aktif');
        
        // Tambahkan kondisi untuk admin yang tidak disuspended
        $this->db->group_start();
        $this->db->where('is_suspended', 0);
        $this->db->or_where('suspended_until IS NULL', null, false);
        $this->db->or_where('suspended_until <', date('Y-m-d H:i:s'));
        $this->db->group_end();
        
        return $this->db->get('admin')->num_rows() > 0;
    }
}