<?php
// Check subscription status - data passed from controller
// Variables: $has_subscription, $active_subscription
?>
<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?= $title ?></title>
  <link rel="stylesheet" href="<?= base_url('asset/css/bootstrap.min.css') ?>">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: #f0f8ff;
      color: #333;
    }

    /* TOPBAR IMPROVED */
    .topbar {
      background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
      padding: 12px 0;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      z-index: 1030;
      height: 60px;
    }

    .topbar-container {
      display: flex;
      justify-content: space-between;
      align-items: center;
      height: 100%;
      padding: 0 15px;
    }

    .brand-section {
      display: flex;
      align-items: center;
      gap: 15px;
      flex-shrink: 0;
    }

    .brand-logo {
      width: 50px;
      height: auto;
      transition: transform 0.3s;
    }

    .brand-logo:hover {
      transform: scale(1.05);
    }

    .brand-text {
      color: white;
    }

    .brand-text h4 {
      font-weight: 600;
      font-size: 1.3rem;
      margin: 0;
      line-height: 1.2;
    }

    .brand-text span {
      font-size: 0.9rem;
      opacity: 0.9;
      display: block;
      margin-top: 2px;
    }

    .user-section {
      display: flex;
      align-items: center;
      gap: 15px;
      flex-shrink: 0;
    }

    .user-info {
      display: flex;
      align-items: center;
      gap: 8px;
      color: white;
      font-size: 0.95rem;
      padding: 6px 12px;
      border-radius: 6px;
      transition: background 0.3s;
    }

    .user-info:hover {
      background: rgba(255, 255, 255, 0.1);
    }

    .user-info i {
      font-size: 1.2rem;
    }

    .logout-btn {
      display: flex;
      align-items: center;
      gap: 8px;
      color: white;
      text-decoration: none;
      padding: 8px 16px;
      border-radius: 6px;
      background: rgba(255, 255, 255, 0.15);
      transition: all 0.3s;
      font-size: 0.9rem;
      font-weight: 500;
    }

    .logout-btn:hover {
      background: rgba(255, 255, 255, 0.25);
      transform: translateY(-1px);
      color: white;
    }

    /* SIDEBAR STYLES */
    .sidebar {
      background: white;
      min-height: calc(100vh - 60px);
      padding: 25px 15px;
      box-shadow: 2px 0 10px rgba(0, 0, 0, 0.05);
      position: fixed;
      top: 60px;
      left: 0;
      width: 16.666667%;
      height: calc(100vh - 60px);
      overflow-y: auto;
      z-index: 1020;
    }

    .sidebar h5 {
      color: #4a90e2;
      margin-bottom: 20px;
      font-weight: 600;
      padding-bottom: 10px;
      border-bottom: 2px solid #e3f2fd;
    }

    .sidebar ul {
      list-style: none;
    }

    .sidebar ul li {
      margin-bottom: 8px;
    }

    .sidebar ul li a {
      display: block;
      padding: 12px 15px;
      color: #555;
      text-decoration: none;
      border-radius: 8px;
      transition: all 0.3s;
      font-size: 0.95rem;
    }

    .sidebar ul li a:hover,
    .sidebar ul li a.active {
      background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
      color: white;
      transform: translateX(5px);
    }

    .sidebar ul li a i {
      width: 20px;
      margin-right: 10px;
    }

    /* MAIN CONTENT */
    .main-content {
      margin-left: 16.666667%;
      margin-top: 60px;
      padding: 25px;
      background: #f0f8ff;
      min-height: calc(100vh - 60px);
    }

    .page-header {
      background: white;
      padding: 25px;
      border-radius: 12px;
      margin-bottom: 25px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
      display: flex;
      justify-content: space-between;
      align-items: center;
      flex-wrap: wrap;
      gap: 15px;
    }

    .page-header-left h4 {
      color: #4a90e2;
      margin: 0 0 5px 0;
      font-weight: 600;
    }

    .page-header-left p {
      color: #888;
      margin: 0;
      font-size: 0.9rem;
    }

    .breadcrumb-custom {
      display: flex;
      align-items: center;
      gap: 8px;
      color: #888;
      font-size: 0.9rem;
    }

    .breadcrumb-custom a {
      color: #4a90e2;
      text-decoration: none;
      transition: color 0.3s;
    }

    .breadcrumb-custom a:hover {
      color: #357abd;
    }

    /* DETAIL CARD */
    .detail-card {
      background: white;
      border-radius: 12px;
      padding: 30px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
      margin-bottom: 25px;
    }

    .detail-header {
      border-bottom: 2px solid #e3f2fd;
      padding-bottom: 20px;
      margin-bottom: 25px;
    }

    .detail-header h3 {
      color: #333;
      margin: 0 0 15px 0;
      font-weight: 600;
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .detail-header h3 i {
      color: #4a90e2;
    }

    .status-badge-large {
      display: inline-block;
      padding: 8px 20px;
      border-radius: 25px;
      font-size: 0.9rem;
      font-weight: 500;
      margin-top: 10px;
    }

    .status-diajukan {
      background: #fff3cd;
      color: #856404;
    }

    .status-diproses {
      background: #cce5ff;
      color: #004085;
    }

    .status-selesai {
      background: #d4edda;
      color: #155724;
    }

    /* INFO GRID */
    .info-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
      gap: 20px;
      margin-bottom: 30px;
    }

    .info-item {
      background: #f8fbff;
      padding: 20px;
      border-radius: 10px;
      border-left: 4px solid #4a90e2;
      transition: all 0.3s;
    }

    .info-item:hover {
      transform: translateY(-3px);
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    }

    .info-item-label {
      color: #888;
      font-size: 0.85rem;
      font-weight: 500;
      margin-bottom: 8px;
      display: flex;
      align-items: center;
      gap: 8px;
    }

    .info-item-label i {
      color: #4a90e2;
    }

    .info-item-value {
      color: #333;
      font-size: 1rem;
      font-weight: 600;
    }

    /* IMAGE SECTION */
    .image-section {
      background: #f8fbff;
      padding: 25px;
      border-radius: 10px;
      border: 2px solid #e3f2fd;
      margin-bottom: 25px;
      text-align: center;
    }

    .image-section h5 {
      color: #4a90e2;
      margin: 0 0 15px 0;
      font-weight: 600;
      display: flex;
      align-items: center;
      gap: 10px;
      justify-content: center;
    }

    .image-section img {
      max-width: 100%;
      height: auto;
      border-radius: 10px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
      cursor: pointer;
      transition: transform 0.3s;
    }

    .image-section img:hover {
      transform: scale(1.02);
    }

    .no-image {
      color: #888;
      font-style: italic;
      padding: 40px;
      background: #f8f9fa;
      border-radius: 10px;
      border: 2px dashed #ddd;
    }

    /* DESCRIPTION SECTION */
    .description-section {
      background: #f8fbff;
      padding: 25px;
      border-radius: 10px;
      border: 2px solid #e3f2fd;
    }

    .description-section h5 {
      color: #4a90e2;
      margin: 0 0 15px 0;
      font-weight: 600;
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .description-section h5 i {
      font-size: 1.2rem;
    }

    .description-content {
      color: #555;
      line-height: 1.8;
      font-size: 0.95rem;
      white-space: pre-wrap;
    }

    /* ACTION BUTTONS */
    .action-buttons {
      display: flex;
      gap: 10px;
      flex-wrap: wrap;
      margin-top: 30px;
      padding-top: 25px;
      border-top: 2px solid #e3f2fd;
    }

    .btn-custom {
      padding: 12px 25px;
      border-radius: 8px;
      border: none;
      cursor: pointer;
      transition: all 0.3s;
      font-size: 0.9rem;
      text-decoration: none;
      display: inline-flex;
      align-items: center;
      gap: 10px;
      font-weight: 500;
    }

    .btn-back {
      background: #6c757d;
      color: white;
    }

    .btn-back:hover {
      background: #5a6268;
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(108, 117, 125, 0.3);
      color: white;
    }

    .btn-edit {
      background: linear-gradient(135deg, #ffc107 0%, #e0a800 100%);
      color: #333;
    }

    .btn-edit:hover {
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(255, 193, 7, 0.3);
      color: #333;
    }

    .btn-delete {
      background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
      color: white;
    }

    .btn-delete:hover {
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(220, 53, 69, 0.3);
      color: white;
    }

    .btn-print {
      background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
      color: white;
    }

    .btn-print:hover {
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(23, 162, 184, 0.3);
      color: white;
    }

    /* TIMELINE SECTION */
    .timeline-section {
      margin-top: 25px;
      background: white;
      border-radius: 12px;
      padding: 30px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
    }

    .timeline-section h5 {
      color: #4a90e2;
      margin: 0 0 20px 0;
      font-weight: 600;
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .timeline-item {
      display: flex;
      gap: 15px;
      padding: 15px 0;
      border-left: 3px solid #e3f2fd;
      padding-left: 20px;
      margin-left: 10px;
      position: relative;
    }

    .timeline-item::before {
      content: '';
      position: absolute;
      left: -8px;
      top: 20px;
      width: 13px;
      height: 13px;
      background: #4a90e2;
      border-radius: 50%;
      border: 3px solid white;
      box-shadow: 0 0 0 2px #4a90e2;
    }

    .timeline-item:last-child {
      border-left-color: transparent;
    }

    .timeline-date {
      color: #888;
      font-size: 0.85rem;
      min-width: 120px;
    }

    .timeline-content {
      color: #555;
      font-size: 0.9rem;
    }

    /* IMAGE MODAL */
    .image-modal {
      display: none;
      position: fixed;
      z-index: 9999;
      left: 0;
      top: 0;
      width: 100%;
      height: 100%;
      background-color: rgba(0, 0, 0, 0.9);
      cursor: pointer;
    }

    .image-modal img {
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      max-width: 90%;
      max-height: 90%;
      box-shadow: 0 0 30px rgba(255, 255, 255, 0.3);
    }

    .close-modal {
      position: absolute;
      top: 20px;
      right: 40px;
      color: white;
      font-size: 40px;
      font-weight: bold;
      cursor: pointer;
    }

    /* SIDEBAR SCROLLBAR */
    .sidebar::-webkit-scrollbar {
      width: 6px;
    }

    .sidebar::-webkit-scrollbar-track {
      background: #f1f1f1;
    }

    .sidebar::-webkit-scrollbar-thumb {
      background: #4a90e2;
      border-radius: 3px;
    }

    .sidebar::-webkit-scrollbar-thumb:hover {
      background: #357abd;
    }

    /* RESPONSIVE DESIGN */
    @media (max-width: 992px) {
      .sidebar {
        width: 25%;
      }
      .main-content {
        margin-left: 25%;
      }
    }

    @media (max-width: 768px) {
      .sidebar {
        position: relative;
        width: 100%;
        height: auto;
        min-height: auto;
        top: 0;
      }
      
      .main-content {
        margin-left: 0;
        margin-top: 0;
        padding: 15px;
      }
      
      .topbar {
        height: auto;
        padding: 10px 0;
      }
      
      .topbar-container {
        flex-direction: column;
        gap: 10px;
        height: auto;
      }
      
      .brand-section, .user-section {
        width: 100%;
        justify-content: center;
      }
      
      .detail-card {
        padding: 20px;
      }
      
      .info-grid {
        grid-template-columns: 1fr;
      }
      
      .action-buttons {
        flex-direction: column;
      }
      
      .btn-custom {
        width: 100%;
        justify-content: center;
      }
      
      .brand-text h4 {
        font-size: 1.1rem;
      }
      
      .brand-text span {
        font-size: 0.8rem;
      }
      
      .user-info, .logout-btn {
        font-size: 0.85rem;
      }
      
      .timeline-item {
        flex-direction: column;
        gap: 5px;
      }
      
      .timeline-date {
        min-width: auto;
      }
    }

    @media (max-width: 576px) {
      .page-header {
        flex-direction: column;
        align-items: flex-start;
      }
      
      .breadcrumb-custom {
        font-size: 0.8rem;
      }
      
      .detail-header h3 {
        font-size: 1.2rem;
      }
    }

    /* PRINT STYLES */
    @media print {
      .topbar,
      .sidebar,
      .action-buttons,
      .breadcrumb-custom {
        display: none !important;
      }
      
      .main-content {
        margin-left: 0;
        margin-top: 0;
      }
      
      body {
        background: white;
      }
      
      .image-section img {
        max-height: 400px;
      }
      
      .btn-custom {
        display: none !important;
      }
    }
  </style>
</head>

<body>
  <!-- TOPBAR IMPROVED -->
  <div class="topbar">
    <div class="container-fluid">
      <div class="topbar-container">
        <!-- Brand Section (Left) -->
        <div class="brand-section">
          <img src="<?= base_url('asset/logo 2.png'); ?>" alt="Logo KosCare" class="brand-logo">
          <div class="brand-text">
            <h4>KosCare</h4>
            <span>Dashboard Admin</span>
          </div>
        </div>
        
        <!-- User Section (Right) -->
        <div class="user-section">
          <div class="user-info">
            <i class="fas fa-user-circle"></i>
            <div>
              <span>Halo, <strong><?= $this->session->userdata('admin_name') ?></strong></span>
            </div>
          </div>
          <a href="<?= site_url('admin/login/logout') ?>" class="logout-btn">
            <i class="fas fa-sign-out-alt"></i> Logout
          </a>
        </div>
      </div>
    </div>
  </div>

  <!-- SIDEBAR -->
  <div class="sidebar" id="sidebar">
    <h5><i class="fas fa-bars"></i> Menu</h5>
    <ul>
      <li><a href="<?= site_url('admin/dashboard'); ?>"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
      <li><a href="<?= site_url('admin/laporan'); ?>" class="active"><i class="fas fa-clipboard-list"></i> Laporan</a></li>
      <li><a href="<?= site_url('admin/penghuni'); ?>"><i class="fas fa-users"></i> Penghuni</a></li>
      <li><a href="<?= site_url('admin/iklan'); ?>"><i class="fas fa-bullhorn"></i> Iklan</a></li>
      <li><a href="<?= site_url('admin/kos'); ?>"><i class="fas fa-building"></i> Kos</a></li>
      <li><a href="<?= site_url('admin/pengaturan'); ?>"><i class="fas fa-cog"></i> Pengaturan</a></li>
    </ul>
  </div>

  <!-- MAIN CONTENT -->
  <div class="main-content">
    <div class="page-header">
      <div class="page-header-left">
        <h4><i class="fas fa-file-alt"></i> Detail Laporan</h4>
        <div class="breadcrumb-custom">
          <a href="<?= site_url('admin/dashboard') ?>"><i class="fas fa-home"></i> Dashboard</a>
          <i class="fas fa-chevron-right"></i>
          <a href="<?= site_url('admin/laporan') ?>">Laporan</a>
          <i class="fas fa-chevron-right"></i>
          <span>Detail</span>
        </div>
      </div>
    </div>

    <div class="detail-card">
      <div class="detail-header">
        <h3>
          <i class="fas fa-clipboard-list"></i>
          <?= $laporan->judul ?>
        </h3>
        <span class="status-badge-large status-<?= strtolower($laporan->status) ?>">
          <?php if ($laporan->status == 'Diajukan'): ?>
            <i class="fas fa-clock"></i> Diajukan
          <?php elseif ($laporan->status == 'Diproses'): ?>
            <i class="fas fa-spinner"></i> Diproses
          <?php else: ?>
            <i class="fas fa-check-circle"></i> Selesai
          <?php endif; ?>
        </span>
      </div>

      <div class="info-grid">
        <div class="info-item">
          <div class="info-item-label">
            <i class="fas fa-user"></i>
            Nama Penghuni
          </div>
          <div class="info-item-value"><?= $laporan->nama_penghuni ?></div>
        </div>

        <div class="info-item">
          <div class="info-item-label">
            <i class="fas fa-calendar-alt"></i>
            Tanggal Laporan
          </div>
          <div class="info-item-value">
            <?= date('d F Y', strtotime($laporan->tanggal_laporan)) ?>
          </div>
        </div>

        <div class="info-item">
          <div class="info-item-label">
            <i class="fas fa-info-circle"></i>
            Status
          </div>
          <div class="info-item-value"><?= $laporan->status ?></div>
        </div>

        <?php if ($laporan->tanggal_selesai): ?>
          <div class="info-item" style="border-left-color: #28a745;">
            <div class="info-item-label">
              <i class="fas fa-check-circle"></i>
              Tanggal Selesai
            </div>
            <div class="info-item-value">
              <?= date('d F Y', strtotime($laporan->tanggal_selesai)) ?>
            </div>
          </div>
        <?php endif; ?>
      </div>

      <?php if (!empty($laporan->gambar)): ?>
        <div class="image-section">
          <h5>
            <i class="fas fa-image"></i>
            Dokumentasi Laporan
          </h5>
          <img src="<?= base_url('asset/laporan/' . $laporan->gambar) ?>"
            alt="<?= $laporan->judul ?>"
            id="laporan-image"
            onclick="openImageModal(this.src)">
        </div>
      <?php endif; ?>

      <div class="description-section">
        <h5>
          <i class="fas fa-align-left"></i>
          Deskripsi Laporan
        </h5>
        <div class="description-content"><?= nl2br(htmlspecialchars($laporan->deskripsi)) ?></div>
      </div>

      <div class="action-buttons">
        <a href="<?= site_url('admin/laporan') ?>" class="btn-custom btn-back">
          <i class="fas fa-arrow-left"></i>
          Kembali
        </a>
        <a href="<?= site_url('admin/laporan/edit/' . $laporan->id_laporan) ?>" class="btn-custom btn-edit">
          <i class="fas fa-edit"></i>
          Edit Laporan
        </a>
        <a href="#" onclick="window.print(); return false;" class="btn-custom btn-print">
          <i class="fas fa-print"></i>
          Cetak
        </a>
        <a href="<?= site_url('admin/laporan/hapus/' . $laporan->id_laporan) ?>"
          class="btn-custom btn-delete"
          onclick="return confirm('Apakah Anda yakin ingin menghapus laporan ini?')">
          <i class="fas fa-trash"></i>
          Hapus
        </a>
      </div>
    </div>

    <?php if ($laporan->tanggal_selesai): ?>
      <div class="timeline-section">
        <h5>
          <i class="fas fa-history"></i>
          Timeline Laporan
        </h5>
        <div class="timeline-item">
          <div class="timeline-date">
            <i class="far fa-calendar"></i>
            <?= date('d M Y', strtotime($laporan->tanggal_laporan)) ?>
          </div>
          <div class="timeline-content">
            <strong>Laporan Diajukan</strong><br>
            Laporan dibuat oleh <?= $laporan->nama_penghuni ?>
          </div>
        </div>

        <?php if ($laporan->status == 'Diproses' || $laporan->status == 'Selesai'): ?>
          <div class="timeline-item">
            <div class="timeline-date">
              <i class="far fa-calendar"></i>
              -
            </div>
            <div class="timeline-content">
              <strong>Laporan Diproses</strong><br>
              Laporan sedang dalam proses penanganan
            </div>
          </div>
        <?php endif; ?>

        <?php if ($laporan->tanggal_selesai): ?>
          <div class="timeline-item">
            <div class="timeline-date">
              <i class="far fa-calendar"></i>
              <?= date('d M Y', strtotime($laporan->tanggal_selesai)) ?>
            </div>
            <div class="timeline-content">
              <strong>Laporan Selesai</strong><br>
              Laporan telah diselesaikan dan ditutup
            </div>
          </div>
        <?php endif; ?>
      </div>
    <?php endif; ?>
  </div>

  <!-- Modal untuk zoom image -->
  <div id="imageModal" class="image-modal" onclick="closeImageModal()">
    <span class="close-modal">&times;</span>
    <img id="modalImage" src="" alt="Zoomed Image">
  </div>

  <script src="<?= base_url('asset/js/jquery-3.6.0.min.js') ?>"></script>
  <script src="<?= base_url('asset/js/bootstrap.bundle.min.js') ?>"></script>

  <script>
    // Active menu highlight
    document.addEventListener('DOMContentLoaded', function() {
      document.querySelectorAll('.sidebar a').forEach(link => {
        link.classList.remove('active');
        if (link.getAttribute('href') && link.getAttribute('href').includes('laporan')) {
          link.classList.add('active');
        }
      });
    });

    // Image modal functions
    function openImageModal(src) {
      document.getElementById('imageModal').style.display = 'block';
      document.getElementById('modalImage').src = src;
    }

    function closeImageModal() {
      document.getElementById('imageModal').style.display = 'none';
    }

    // Close modal dengan ESC key
    document.addEventListener('keydown', function(event) {
      if (event.key === 'Escape') {
        closeImageModal();
      }
    });

    // Add hover effects to logout button
    document.addEventListener('DOMContentLoaded', function() {
      const logoutBtn = document.querySelector('.logout-btn');
      if (logoutBtn) {
        logoutBtn.addEventListener('mouseenter', function() {
          this.style.transform = 'translateY(-1px) scale(1.02)';
        });
        logoutBtn.addEventListener('mouseleave', function() {
          this.style.transform = 'translateY(0) scale(1)';
        });
      }
    });
  </script>
</body>
</html>