<?php
// Check subscription status - data passed from controller
// Variables: $has_subscription, $active_subscription
?>
<!doctype html>
<html>

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?php echo isset($title) ? $title : 'Dashboard'; ?></title>
  <link rel="stylesheet" href="<?php echo base_url('asset/css/bootstrap.min.css'); ?>">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: #f0f8ff;
      color: #333;
    }

    /* TOPBAR STYLES - IMPROVED */
    .topbar {
      background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
      padding: 12px 0;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      z-index: 1030;
      height: 60px;
    }

    .topbar-container {
      display: flex;
      justify-content: space-between;
      align-items: center;
      height: 100%;
    }

    .brand-section {
      display: flex;
      align-items: center;
      gap: 15px;
    }

    .brand-logo {
      width: 50px;
      height: auto;
      transition: transform 0.3s;
    }

    .brand-logo:hover {
      transform: scale(1.05);
    }

    .brand-title {
      color: white;
      font-weight: 600;
      font-size: 1.3rem;
      margin: 0;
    }

    .brand-subtitle {
      color: rgba(255, 255, 255, 0.9);
      font-size: 0.9rem;
      margin-left: 5px;
      font-weight: 400;
    }

    .user-section {
      display: flex;
      align-items: center;
      gap: 20px;
    }

    .user-info {
      display: flex;
      align-items: center;
      gap: 10px;
      color: white;
      font-size: 0.95rem;
      padding: 5px 12px;
      border-radius: 6px;
      transition: background 0.3s;
    }

    .user-info:hover {
      background: rgba(255, 255, 255, 0.1);
    }

    .user-avatar {
      font-size: 1.3rem;
      color: white;
    }

    .logout-btn {
      display: flex;
      align-items: center;
      gap: 8px;
      color: white;
      text-decoration: none;
      padding: 8px 15px;
      border-radius: 6px;
      background: rgba(255, 255, 255, 0.15);
      transition: all 0.3s;
      font-size: 0.9rem;
    }

    .logout-btn:hover {
      background: rgba(255, 255, 255, 0.25);
      color: white;
      transform: translateY(-1px);
    }

    /* SIDEBAR STYLES */
    .sidebar {
      background: white;
      min-height: calc(100vh - 60px);
      padding: 25px 15px;
      box-shadow: 2px 0 10px rgba(0, 0, 0, 0.05);
      position: fixed;
      top: 60px;
      left: 0;
      width: 16.666667%;
      height: calc(100vh - 60px);
      overflow-y: auto;
      z-index: 1020;
    }

    .sidebar h5 {
      color: #4a90e2;
      margin-bottom: 20px;
      font-weight: 600;
      padding-bottom: 10px;
      border-bottom: 2px solid #e3f2fd;
    }

    .sidebar ul {
      list-style: none;
    }

    .sidebar ul li {
      margin-bottom: 8px;
    }

    .sidebar ul li a {
      display: block;
      padding: 12px 15px;
      color: #555;
      text-decoration: none;
      border-radius: 8px;
      transition: all 0.3s;
      font-size: 0.95rem;
      position: relative;
    }

    .sidebar ul li a:hover,
    .sidebar ul li a.active {
      background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
      color: white;
      transform: translateX(5px);
    }

    .sidebar ul li a i {
      width: 20px;
      margin-right: 10px;
    }

    /* MAIN CONTENT */
    .main-content {
      margin-left: 16.666667%;
      margin-top: 60px;
      padding: 25px;
      background: #f0f8ff;
      min-height: calc(100vh - 60px);
    }

    /* STAT CARDS */
    .stat-card {
      background: white;
      border-radius: 12px;
      padding: 25px;
      margin-bottom: 20px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
      transition: all 0.3s;
      border-left: 4px solid #4a90e2;
      position: relative;
      overflow: hidden;
    }

    .stat-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
    }

    .stat-card.card-blue {
      background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
      color: white;
      border-left: none;
    }

    .stat-card.card-success {
      border-left-color: #28a745;
    }

    .stat-card.card-warning {
      border-left-color: #ffc107;
    }

    .stat-card.card-danger {
      border-left-color: #dc3545;
    }

    .stat-card.card-purple {
      border-left-color: #6f42c1;
      background: linear-gradient(135deg, #6f42c1 0%, #59319e 100%);
      color: white;
    }

    .stat-card.card-info {
      border-left-color: #17a2b8;
      background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
      color: white;
    }

    .stat-card h5 {
      font-size: 0.9rem;
      font-weight: 500;
      margin-bottom: 10px;
      opacity: 0.9;
    }

    .stat-card h2 {
      font-size: 2.5rem;
      font-weight: 700;
      margin-bottom: 5px;
    }

    .stat-card .icon {
      position: absolute;
      right: 20px;
      top: 20px;
      font-size: 3rem;
      opacity: 0.2;
    }

    /* ACTIVITY CARD */
    .activity-card {
      background: white;
      border-radius: 12px;
      padding: 25px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
    }

    .activity-card h5 {
      color: #4a90e2;
      margin-bottom: 20px;
      font-weight: 600;
    }

    .activity-item {
      padding: 15px;
      border-left: 3px solid #4a90e2;
      margin-bottom: 15px;
      background: #f8fbff;
      border-radius: 8px;
      transition: all 0.3s;
    }

    .activity-item:hover {
      background: #e3f2fd;
      transform: translateX(5px);
    }

    .activity-item .time {
      color: #888;
      font-size: 0.85rem;
    }

    .activity-item .description {
      margin-top: 5px;
      color: #555;
    }

    .activity-item .badge {
      font-size: 0.75rem;
      padding: 4px 10px;
      border-radius: 12px;
      margin-left: 10px;
    }

    /* QUICK ACTIONS */
    .quick-actions {
      display: flex;
      gap: 10px;
      margin-bottom: 25px;
      flex-wrap: wrap;
    }

    .quick-action-btn {
      background: white;
      border: 2px solid #4a90e2;
      color: #4a90e2;
      padding: 10px 20px;
      border-radius: 8px;
      text-decoration: none;
      transition: all 0.3s;
      font-size: 0.9rem;
      font-weight: 500;
    }

    .quick-action-btn:hover {
      background: #4a90e2;
      color: white;
      transform: translateY(-2px);
    }

    .quick-action-btn i {
      margin-right: 8px;
    }

    /* EMPTY STATE */
    .empty-state {
      text-align: center;
      padding: 40px;
      color: #888;
    }

    .empty-state i {
      font-size: 4rem;
      color: #ccc;
      margin-bottom: 15px;
    }

    /* PROGRESS BARS */
    .progress-bar-custom {
      height: 8px;
      background: rgba(255, 255, 255, 0.3);
      border-radius: 10px;
      overflow: hidden;
      margin-top: 10px;
    }

    .progress-bar-fill {
      height: 100%;
      background: white;
      border-radius: 10px;
      transition: width 0.5s ease;
    }

    .progress-bg {
      height: 8px;
      background: #e9ecef;
      border-radius: 10px;
      overflow: hidden;
      margin-bottom: 10px;
    }

    .progress-fill {
      height: 100%;
      border-radius: 10px;
      transition: width 0.5s ease;
    }

    /* BADGES */
    .badge-status {
      display: inline-block;
      padding: 5px 12px;
      border-radius: 20px;
      font-size: 0.8rem;
      font-weight: 500;
    }

    .badge-pending {
      background: #fff3cd;
      color: #856404;
    }

    .badge-process {
      background: #cce5ff;
      color: #004085;
    }

    .badge-done {
      background: #d4edda;
      color: #155724;
    }

    .badge-reported {
      background: #f8d7da;
      color: #721c24;
    }

    .badge-warning {
      background: #fff3cd;
      color: #856404;
    }

    /* SIDEBAR SCROLLBAR */
    .sidebar::-webkit-scrollbar {
      width: 6px;
    }

    .sidebar::-webkit-scrollbar-track {
      background: #f1f1f1;
    }

    .sidebar::-webkit-scrollbar-thumb {
      background: #4a90e2;
      border-radius: 3px;
    }

    .sidebar::-webkit-scrollbar-thumb:hover {
      background: #357abd;
    }

    /* DEBUG BOX */
    .debug-box {
      background: #fff3cd;
      padding: 15px;
      margin-bottom: 20px;
      border-radius: 8px;
      border-left: 4px solid #ffc107;
    }

    /* SUBSCRIPTION ALERT */
    .subscription-alert {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      padding: 20px;
      border-radius: 10px;
      margin-bottom: 20px;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }

    .subscription-alert .btn {
      background: white;
      color: #667eea;
      font-weight: 600;
      border: none;
      padding: 10px 25px;
      border-radius: 20px;
    }

    /* CHAT DISABLED */
    .chat-disabled-overlay {
      position: relative;
      opacity: 0.5;
      pointer-events: none;
    }

    .chat-disabled-overlay::after {
      content: "🔒 Chat Locked - Subscription Required";
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      background: rgba(0, 0, 0, 0.8);
      color: white;
      padding: 10px 20px;
      border-radius: 5px;
      font-size: 14px;
      white-space: nowrap;
    }

    /* ALERT STYLES */
    .alert {
      padding: 15px 20px;
      border-radius: 10px;
      margin-bottom: 20px;
      display: flex;
      align-items: center;
      gap: 12px;
      animation: slideDown 0.5s ease-out;
    }

    .alert-warning {
      background: #fff3cd;
      color: #856404;
      border-left: 4px solid #ffc107;
    }

    .alert-danger {
      background: #f8d7da;
      color: #721c24;
      border-left: 4px solid #dc3545;
    }

    .alert-info {
      background: #d1ecf1;
      color: #0c5460;
      border-left: 4px solid #17a2b8;
    }

    .alert-success {
      background: #d4edda;
      color: #155724;
      border-left: 4px solid #28a745;
    }

    @keyframes slideDown {
      from {
        opacity: 0;
        transform: translateY(-20px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    /* NOTIFICATION BADGE */
    .notification-badge {
      position: absolute;
      top: -5px;
      right: -5px;
      background: #dc3545;
      color: white;
      border-radius: 50%;
      width: 20px;
      height: 20px;
      font-size: 0.7rem;
      display: flex;
      align-items: center;
      justify-content: center;
      font-weight: bold;
    }

    .menu-item-wrapper {
      position: relative;
      display: inline-block;
      width: 100%;
    }

    /* RESPONSIVE */
    @media (max-width: 992px) {
      .sidebar {
        width: 25%;
      }
      .main-content {
        margin-left: 25%;
      }
    }

    @media (max-width: 768px) {
      .sidebar {
        position: relative;
        width: 100%;
        height: auto;
        min-height: auto;
        top: 0;
      }
      .main-content {
        margin-left: 0;
        margin-top: 0;
        padding: 15px;
      }
      .stat-card h2 {
        font-size: 2rem;
      }
      .brand-section {
        gap: 10px;
      }
      .brand-title {
        font-size: 1.1rem;
      }
      .brand-subtitle {
        font-size: 0.8rem;
      }
      .user-info {
        font-size: 0.85rem;
      }
      .logout-btn {
        padding: 6px 12px;
        font-size: 0.85rem;
      }
    }

    @media (max-width: 576px) {
      .topbar-container {
        flex-direction: column;
        gap: 10px;
        padding: 10px 0;
        height: auto;
      }
      .topbar {
        height: auto;
        padding: 10px 0;
      }
      .brand-section, .user-section {
        width: 100%;
        justify-content: center;
      }
    }

    /* TABLE STYLES */
    .table-responsive {
      border-radius: 10px;
      overflow: hidden;
      box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    }

    .table {
      margin-bottom: 0;
    }

    .table th {
      background: #f8f9fa;
      border-bottom: 2px solid #dee2e6;
      font-weight: 600;
      color: #495057;
    }

    .table td {
      vertical-align: middle;
    }

    .table-hover tbody tr:hover {
      background-color: #f8fbff;
    }
  </style>
</head>

<body>
  <!-- TOPBAR - IMPROVED LAYOUT -->
  <div class="topbar">
    <div class="container-fluid">
      <div class="topbar-container">
        <!-- Brand Section (Left) -->
        <div class="brand-section">
          <img src="<?= base_url('asset/logo 2.png'); ?>" alt="Logo KosCare" class="brand-logo">
          <div>
            <h4 class="brand-title m-0">
              KosCare<span class="brand-subtitle">- Dashboard Admin</span>
            </h4>
          </div>
        </div>
        
        <!-- User Section (Right) -->
        <div class="user-section">
          <div class="user-info">
            <i class="fas fa-user-circle user-avatar"></i>
            <div>
              <span>Halo, <strong><?= $this->session->userdata('admin_name'); ?></strong></span>
            </div>
          </div>
          <a href="<?= site_url('admin/login/logout'); ?>" class="logout-btn">
            <i class="fas fa-sign-out-alt"></i> Logout
          </a>
        </div>
      </div>
    </div>
  </div>

  <!-- SIDEBAR -->
  <div class="sidebar" id="sidebar">
    <h5><i class="fas fa-bars"></i> Menu</h5>
    <ul>
      <li><a href="<?= site_url('admin/dashboard'); ?>" class="active"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
      <li><a href="<?= site_url('admin/laporan'); ?>"><i class="fas fa-clipboard-list"></i> Laporan</a></li>
      <li><a href="<?= site_url('admin/penghuni'); ?>"><i class="fas fa-users"></i> Penghuni</a></li>
      <li class="nav-item">
        <a class="nav-link" href="<?php echo site_url('admin/subscription'); ?>">
          <i class="fas fa-crown"></i>
          Berlangganan
          <?php if (!$has_subscription): ?>
            <span class="badge bg-danger">Inactive</span>
          <?php else: ?>
            <span class="badge bg-success">Active</span>
          <?php endif; ?>
        </a>
      </li>
      <li class="<?= !$has_subscription ? 'chat-disabled-overlay' : '' ?>">
        <a href="<?= $has_subscription ? site_url('admin/chat_v2') : '#' ?>"
          <?= !$has_subscription ? 'onclick="return false;"' : '' ?>>
          <i class="fas fa-comments"></i> Chat
          <?php if (!$has_subscription): ?>
            <i class="fas fa-lock" style="float: right; color: #ffc107;"></i>
          <?php endif; ?>
        </a>
      </li>
      <li><a href="<?= site_url('admin/iklan'); ?>"><i class="fas fa-bullhorn"></i> Iklan</a></li>
      <li><a href="<?= site_url('admin/kos'); ?>"><i class="fas fa-building"></i> Kos</a></li>
      <li class="menu-item-wrapper">
        <a href="<?= site_url('admin/laporan_admin_reports'); ?>">
          <i class="fas fa-flag"></i> Laporan Admin
          <?php if ($user_reports_count > 0): ?>
            <span class="notification-badge"><?= $user_reports_count; ?></span>
          <?php endif; ?>
        </a>
      </li>
      <li><a href="<?= site_url('admin/pengaturan'); ?>"><i class="fas fa-cog"></i> Pengaturan</a></li>
    </ul>
  </div>

  <!-- MAIN CONTENT -->
  <div class="main-content">
    <?php if ($warning_count > 0): ?>
      <div class="alert alert-warning">
        <i class="fas fa-exclamation-triangle"></i>
        <div>
          <strong>Peringatan: Anda memiliki <?= $warning_count; ?> peringatan</strong>
          <p style="margin: 5px 0 0; font-size: 0.9rem;">
            Terdapat <?= $warning_count; ?> laporan dari penghuni yang mengakibatkan peringatan.
            <?php if ($last_warning_date): ?>
              <br>Peringatan terakhir: <?= date('d M Y', strtotime($last_warning_date)); ?>
            <?php endif; ?>
          </p>
        </div>
      </div>
    <?php endif; ?>
    
    <?php if ($user_reports_count > 0): ?>
      <div class="alert alert-danger">
        <i class="fas fa-user-shield"></i>
        <div>
          <strong>Laporan dari Penghuni: <?= $user_reports_count; ?> laporan</strong>
          <p style="margin: 5px 0 0; font-size: 0.9rem;">
            Terdapat <?= $user_reports_count; ?> laporan dari penghuni yang perlu perhatian Anda.
            <?php if ($pending_reports_count > 0): ?>
              <br><?= $pending_reports_count; ?> laporan masih pending.
            <?php endif; ?>
          </p>
        </div>
        <div style="margin-left: auto;">
          <a href="<?= site_url('admin/laporan_admin_reports'); ?>" class="btn btn-sm btn-danger">
            <i class="fas fa-eye"></i> Lihat Laporan
          </a>
        </div>
      </div>
    <?php endif; ?>
    
    <?php if ($is_suspended && $suspended_until): ?>
      <div class="alert alert-danger">
        <i class="fas fa-user-lock"></i>
        <div>
          <strong>Akun Anda dinonaktifkan sementara</strong>
          <p style="margin: 5px 0 0; font-size: 0.9rem;">
            Hingga: <?= date('d M Y H:i', strtotime($suspended_until)); ?>
            <?php if ($suspension_reason): ?>
              <br>Alasan: <?= htmlspecialchars($suspension_reason); ?>
            <?php endif; ?>
          </p>
        </div>
      </div>
    <?php elseif ($is_suspended && !$suspended_until): ?>
      <div class="alert alert-danger">
        <i class="fas fa-user-slash"></i>
        <div>
          <strong>Akun Anda dinonaktifkan permanen</strong>
          <p style="margin: 5px 0 0; font-size: 0.9rem;">
            Hubungi Super Admin untuk informasi lebih lanjut.
            <?php if ($suspension_reason): ?>
              <br>Alasan: <?= htmlspecialchars($suspension_reason); ?>
            <?php endif; ?>
          </p>
        </div>
      </div>
    <?php endif; ?>
    
    <?php if (!$has_subscription): ?>
      <div class="subscription-alert">
        <div>
          <h5 style="margin: 0;"><i class="fas fa-exclamation-triangle"></i> No Active Subscription</h5>
          <p style="margin: 5px 0 0 0; opacity: 0.9;">Upgrade now to unlock chat features and communicate with your tenants!</p>
        </div>
        <a href="<?= site_url('admin/subscription/pricing') ?>" class="btn">
          <i class="fas fa-crown"></i> Upgrade Now
        </a>
      </div>
    <?php elseif ($active_subscription): ?>
      <?php
      $days_left = ceil((strtotime($active_subscription->end_date) - time()) / 86400);
      if ($days_left <= 7):
      ?>
        <div class="alert alert-warning">
          <i class="fas fa-clock"></i>
          Your subscription expires in <strong><?= $days_left ?> days</strong>.
          <a href="<?= site_url('admin/subscription/pricing') ?>" style="text-decoration: underline;">Renew now</a>
        </div>
      <?php endif; ?>
    <?php endif; ?>
    
    <div class="debug-box">
      <strong><i class="fas fa-bug"></i> DEBUG INFO:</strong><br>
      Total Laporan Kos: <strong><?= $total_laporan; ?></strong> |
      Diajukan: <strong><?= $laporan_pending; ?></strong> |
      Diproses: <strong><?= $laporan_proses; ?></strong> |
      Selesai: <strong><?= $laporan_selesai; ?></strong> |
      Laporan dari User: <strong><?= $user_reports_count; ?></strong> |
      Peringatan: <strong><?= $warning_count; ?></strong> |
      <strong style="color: <?= $has_subscription ? '#28a745' : '#dc3545' ?>;">
        Subscription: <?= $has_subscription ? 'ACTIVE ✓' : 'INACTIVE ✗' ?>
      </strong>
    </div>
    
    <div class="quick-actions">
      <a href="<?= site_url('admin/laporan/export'); ?>" class="quick-action-btn">
        <i class="fas fa-file-export"></i> Export Data
      </a>
      <?php if ($user_reports_count > 0): ?>
        <a href="<?= site_url('admin/laporan_admin_reports'); ?>" class="quick-action-btn" style="background: #dc3545; color: white; border-color: #dc3545;">
          <i class="fas fa-flag"></i> Lihat Laporan User (<?= $user_reports_count; ?>)
        </a>
      <?php endif; ?>
    </div>
    
    <div class="row mt-4">
      <div class="col-md-3">
        <div class="stat-card card-blue">
          <i class="fas fa-clipboard-list icon"></i>
          <h5>Total Laporan Kos</h5>
          <h2><?= $total_laporan; ?></h2>
          <small>Semua laporan kos</small>
          <div class="progress-bar-custom">
            <div class="progress-bar-fill" style="width: 100%"></div>
          </div>
        </div>
      </div>
      <div class="col-md-3">
        <div class="stat-card card-warning">
          <i class="fas fa-clock icon"></i>
          <h5>Laporan Diajukan</h5>
          <h2><?= $laporan_pending; ?></h2>
          <small>Menunggu tindakan</small>
        </div>
      </div>
      <div class="col-md-3">
        <div class="stat-card card-success">
          <i class="fas fa-spinner icon"></i>
          <h5>Laporan Diproses</h5>
          <h2><?= $laporan_proses; ?></h2>
          <small>Sedang ditangani</small>
        </div>
      </div>
      <div class="col-md-3">
        <div class="stat-card card-danger">
          <i class="fas fa-flag icon"></i>
          <h5>Laporan dari User</h5>
          <h2><?= $user_reports_count; ?></h2>
          <small>Laporan untuk admin</small>
          <?php if ($pending_reports_count > 0): ?>
            <div style="margin-top: 10px;">
              <span class="badge-status badge-reported"><?= $pending_reports_count; ?> pending</span>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
    
    <div class="row mt-3">
      <div class="col-md-3">
        <div class="stat-card card-success">
          <i class="fas fa-check-circle icon"></i>
          <h5>Laporan Selesai</h5>
          <h2><?= $laporan_selesai; ?></h2>
          <small>Sudah ditangani</small>
        </div>
      </div>
      <div class="col-md-3">
        <div class="stat-card card-purple">
          <i class="fas fa-exclamation-triangle icon"></i>
          <h5>Peringatan</h5>
          <h2><?= $warning_count; ?></h2>
          <small>Total peringatan</small>
        </div>
      </div>
      <div class="col-md-3">
        <div class="stat-card card-info">
          <i class="fas fa-users icon"></i>
          <h5>Total Penghuni</h5>
          <h2><?= $total_penghuni ?? 0; ?></h2>
          <small>Penghuni aktif</small>
        </div>
      </div>
      
      <div class="row mt-4">
        <div class="col-md-8">
          <div class="activity-card">
            <h5><i class="fas fa-history"></i> Aktivitas Terbaru</h5>
            <div id="activityContainer">
              <?php if (!empty($recent_activities)): ?>
                <?php foreach ($recent_activities as $activity): ?>
                  <?php
                  $tanggal = strtotime($activity->tanggal_laporan);
                  $selisih = time() - $tanggal;
                  if ($selisih < 60) $waktu_lalu = $selisih . ' detik yang lalu';
                  elseif ($selisih < 3600) $waktu_lalu = floor($selisih / 60) . ' menit yang lalu';
                  elseif ($selisih < 86400) $waktu_lalu = floor($selisih / 3600) . ' jam yang lalu';
                  else $waktu_lalu = floor($selisih / 86400) . ' hari yang lalu';
                  $status_color = [
                    'Diajukan' => '#ffc107',
                    'Diproses' => '#4a90e2',
                    'Selesai'  => '#28a745'
                  ][$activity->status] ?? '#4a90e2';
                  $badge_class = [
                    'Diajukan' => 'badge-pending',
                    'Diproses' => 'badge-process',
                    'Selesai'  => 'badge-done'
                  ][$activity->status] ?? 'badge-process';
                  ?>
                  <div class="activity-item" style="border-left-color: <?= $status_color; ?>">
                    <div class="time">
                      <i class="far fa-clock"></i> <?= $waktu_lalu; ?>
                      <span class="badge <?= $badge_class; ?>"><?= $activity->status; ?></span>
                    </div>
                    <div class="description">
                      <strong><?= $activity->judul; ?></strong> - oleh
                      <?= $activity->nama_penghuni ?? 'Unknown'; ?>
                    </div>
                  </div>
                <?php endforeach; ?>
              <?php else: ?>
                <div class="empty-state">
                  <i class="fas fa-inbox"></i>
                  <p>Belum ada aktivitas terbaru</p>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
        
        <div class="col-md-4">
          <div class="activity-card">
            <h5><i class="fas fa-chart-pie"></i> Status Laporan</h5>
            <?php
            $total = max($total_laporan, 1);
            $pending_percent = round(($laporan_pending / $total) * 100);
            $proses_percent = round(($laporan_proses / $total) * 100);
            $selesai_percent = round(($laporan_selesai / $total) * 100);
            ?>
            <div style="padding: 20px 0;">
              <div class="mb-3">
                <div class="d-flex justify-content-between mb-2">
                  <span>Diajukan</span>
                  <span class="badge-status badge-pending"><?= $pending_percent; ?>%</span>
                </div>
                <div class="progress-bg">
                  <div class="progress-fill" style="background:#ffc107; width:<?= $pending_percent; ?>%"></div>
                </div>
              </div>
              <div class="mb-3">
                <div class="d-flex justify-content-between mb-2">
                  <span>Diproses</span>
                  <span class="badge-status badge-process"><?= $proses_percent; ?>%</span>
                </div>
                <div class="progress-bg">
                  <div class="progress-fill" style="background:#4a90e2; width:<?= $proses_percent; ?>%"></div>
                </div>
              </div>
              <div>
                <div class="d-flex justify-content-between mb-2">
                  <span>Selesai</span>
                  <span class="badge-status badge-done"><?= $selesai_percent; ?>%</span>
                </div>
                <div class="progress-bg">
                  <div class="progress-fill" style="background:#28a745; width:<?= $selesai_percent; ?>%"></div>
                </div>
              </div>
            </div>
            
            <?php if ($user_reports_count > 0): ?>
              <hr style="margin: 20px 0;">
              <h6><i class="fas fa-user-shield"></i> Laporan dari Penghuni</h6>
              <div style="padding: 10px 0;">
                <div class="mb-2">
                  <div class="d-flex justify-content-between">
                    <span>Total Laporan</span>
                    <strong><?= $user_reports_count; ?></strong>
                  </div>
                </div>
                <div class="mb-2">
                  <div class="d-flex justify-content-between">
                    <span>Pending</span>
                    <span class="badge-status badge-reported"><?= $pending_reports_count; ?></span>
                  </div>
                </div>
                <?php if ($last_user_report): ?>
                  <div class="mb-2">
                    <div class="d-flex justify-content-between">
                      <span>Terakhir</span>
                      <small><?= date('d M', strtotime($last_user_report)); ?></small>
                    </div>
                  </div>
                <?php endif; ?>
                <div class="mt-3">
                  <a href="<?= site_url('admin/laporan_admin_reports'); ?>" class="btn btn-sm btn-danger w-100">
                    <i class="fas fa-eye"></i> Lihat Detail
                  </a>
                </div>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
      
      <?php if (!empty($user_reports_list)): ?>
        <div class="row mt-4">
          <div class="col-12">
            <div class="activity-card">
              <h5><i class="fas fa-flag"></i> Laporan Terbaru dari Penghuni</h5>
              <div class="table-responsive">
                <table class="table table-hover">
                  <thead>
                    <tr>
                      <th width="5%">No</th>
                      <th width="20%">Penghuni</th>
                      <th width="30%">Judul</th>
                      <th width="15%">Status</th>
                      <th width="15%">Tindakan</th>
                      <th width="15%">Tanggal</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php $no = 1;
                    foreach ($user_reports_list as $report): ?>
                      <tr>
                        <td><?= $no++; ?></td>
                        <td>
                          <div style="display: flex; align-items: center; gap: 8px;">
                            <div style="width: 30px; height: 30px; border-radius: 50%; background: #4a90e2; color: white; display: flex; align-items: center; justify-content: center; font-weight: 600;">
                              <?= strtoupper(substr($report->nama_penghuni, 0, 1)); ?>
                            </div>
                            <div>
                              <div style="font-weight: 600;"><?= $report->nama_penghuni; ?></div>
                              <small style="color: #888;"><?= $report->penghuni_email; ?></small>
                            </div>
                          </div>
                        </td>
                        <td style="max-width: 250px; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">
                          <?= htmlspecialchars($report->judul); ?>
                        </td>
                        <td>
                          <?php if ($report->status == 'pending'): ?>
                            <span class="badge-status badge-pending">Pending</span>
                          <?php elseif ($report->status == 'diproses'): ?>
                            <span class="badge-status badge-process">Diproses</span>
                          <?php else: ?>
                            <span class="badge-status badge-done">Selesai</span>
                          <?php endif; ?>
                        </td>
                        <td>
                          <?php if ($report->tindakan == 'none'): ?>
                            <span class="badge-status" style="background: #e2e3e5; color: #383d41;">Belum Ada</span>
                          <?php elseif ($report->tindakan == 'peringatan'): ?>
                            <span class="badge-status badge-warning">Peringatan</span>
                          <?php elseif ($report->tindakan == 'nonaktif_sementara'): ?>
                            <span class="badge-status badge-reported">Nonaktif Sementara</span>
                          <?php else: ?>
                            <span class="badge-status" style="background: #dc3545; color: white;">Nonaktif Permanen</span>
                          <?php endif; ?>
                        </td>
                        <td>
                          <small><?= date('d M Y', strtotime($report->created_at)); ?></small>
                        </td>
                      </tr>
                    <?php endforeach; ?>
                  </tbody>
                </table>
              </div>
              <div class="text-center mt-3">
                <a href="<?= site_url('admin/laporan_admin_reports'); ?>" class="btn btn-primary">
                  <i class="fas fa-list"></i> Lihat Semua Laporan
                </a>
              </div>
            </div>
          </div>
        </div>
      <?php endif; ?>
    </div>
  </div>

  <script src="<?php echo base_url('asset/js/jquery-3.6.0.min.js'); ?>"></script>
  <script src="<?php echo base_url('asset/js/bootstrap.bundle.min.js'); ?>"></script>

  <script>
    // Active menu highlight
    const currentPath = window.location.pathname;
    document.querySelectorAll('.sidebar a').forEach(link => {
      const href = link.getAttribute('href');
      if (currentPath.includes(href) && href !== '<?php echo site_url('admin/dashboard'); ?>') {
        document.querySelectorAll('.sidebar a').forEach(l => l.classList.remove('active'));
        link.classList.add('active');
      }
    });

    // Show subscription warning when clicking locked chat
    <?php if (!$has_subscription): ?>
      document.addEventListener('DOMContentLoaded', function() {
        const chatLink = document.querySelector('a[href*="chat"]');
        if (chatLink) {
          chatLink.addEventListener('click', function(e) {
            e.preventDefault();
            if (confirm('Chat feature requires an active subscription. Would you like to upgrade now?')) {
              window.location.href = '<?= site_url('admin/subscription/pricing') ?>';
            }
          });
        }
      });
    <?php endif; ?>

    // Auto-hide alerts after 10 seconds
    document.addEventListener('DOMContentLoaded', function() {
      const alerts = document.querySelectorAll('.alert');
      alerts.forEach(alert => {
        setTimeout(() => {
          alert.style.opacity = '0';
          alert.style.transform = 'translateY(-10px)';
          setTimeout(() => alert.remove(), 300);
        }, 10000);
      });
    });

    // Refresh page every 2 minutes for real-time updates
    setTimeout(() => {
      window.location.reload();
    }, 120000);

    // Add hover effect to logout button
    document.addEventListener('DOMContentLoaded', function() {
      const logoutBtn = document.querySelector('.logout-btn');
      if (logoutBtn) {
        logoutBtn.addEventListener('mouseenter', function() {
          this.style.transform = 'translateY(-1px) scale(1.02)';
        });
        logoutBtn.addEventListener('mouseleave', function() {
          this.style.transform = 'translateY(0) scale(1)';
        });
      }
    });
  </script>
</body>
</html>