<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Password Berhasil Diubah - KosCare</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 20px;
            color: #333;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }
        .header {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
        .content {
            padding: 40px;
        }
        .success-icon {
            text-align: center;
            font-size: 60px;
            color: #28a745;
            margin-bottom: 20px;
        }
        .info-box {
            background: #f8fff9;
            border: 1px solid #d4edda;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
        }
        .info-item {
            margin: 10px 0;
            padding: 8px 0;
            border-bottom: 1px solid #eee;
        }
        .info-item:last-child {
            border-bottom: none;
        }
        .footer {
            text-align: center;
            padding: 20px;
            background: #f8f9fa;
            color: #666;
            font-size: 13px;
            border-top: 1px solid #eee;
        }
        .security-tips {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 15px;
            border-radius: 5px;
            margin: 25px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Password Berhasil Diubah</h1>
            <p>KosCare Admin System</p>
        </div>
        
        <div class="content">
            <div class="success-icon">✅</div>
            
            <h2 style="text-align: center; color: #28a745;">Password Berhasil Diperbarui!</h2>
            
            <p>Halo <strong><?= htmlspecialchars($name) ?></strong>,</p>
            
            <p>Password akun admin KosCare Anda telah berhasil direset pada:</p>
            
            <div class="info-box">
                <div class="info-item">
                    <strong>📅 Waktu:</strong> <?= $time ?>
                </div>
                <div class="info-item">
                    <strong>🌐 IP Address:</strong> <?= $ip_address ?>
                </div>
                <div class="info-item">
                    <strong>🔐 Status:</strong> Password telah diperbarui dengan aman
                </div>
            </div>
            
            <div class="security-tips">
                <h3>🔒 Tips Keamanan Akun:</h3>
                <ul>
                    <li>Gunakan password yang unik dan kompleks</li>
                    <li>Jangan gunakan password yang sama untuk akun lain</li>
                    <li>Jangan bagikan password Anda kepada siapa pun</li>
                    <li>Selalu logout setelah menggunakan perangkat publik</li>
                    <li>Periksa aktivitas akun secara berkala</li>
                </ul>
            </div>
            
            <p style="text-align: center; margin-top: 30px;">
                <a href="<?= base_url('admin/login') ?>" style="
                    display: inline-block;
                    background: #28a745;
                    color: white;
                    padding: 12px 30px;
                    text-decoration: none;
                    border-radius: 6px;
                    font-weight: bold;
                ">Login ke Akun Saya</a>
            </p>
            
            <p style="color: #dc3545; text-align: center; font-size: 14px;">
                <strong>⚠️ PERHATIAN:</strong> Jika Anda tidak melakukan perubahan ini,<br>
                segera hubungi administrator sistem!
            </p>
        </div>
        
        <div class="footer">
            <p>© <?= $current_year ?> KosCare. All rights reserved.</p>
            <p>Email ini dikirim secara otomatis untuk keamanan akun Anda.</p>
        </div>
    </div>
</body>
</html>