<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Reset Password - KosCare Admin</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f4f4f4;
            margin: 0;
            padding: 20px;
        }
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }
        .email-header {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .email-header h1 {
            margin: 0;
            font-size: 24px;
            font-weight: 600;
        }
        .email-header p {
            margin: 10px 0 0;
            opacity: 0.9;
            font-size: 14px;
        }
        .email-body {
            padding: 40px;
        }
        .greeting {
            font-size: 16px;
            margin-bottom: 20px;
            color: #555;
        }
        .code-container {
            background: #f8fbff;
            border: 2px dashed #4a90e2;
            border-radius: 10px;
            padding: 25px;
            text-align: center;
            margin: 30px 0;
        }
        .reset-code {
            font-size: 42px;
            font-weight: bold;
            letter-spacing: 8px;
            color: #4a90e2;
            font-family: 'Courier New', monospace;
            margin: 10px 0;
        }
        .instructions {
            background: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 15px;
            border-radius: 5px;
            margin: 25px 0;
        }
        .instructions h3 {
            margin-top: 0;
            color: #856404;
        }
        .instructions ul {
            margin: 10px 0;
            padding-left: 20px;
        }
        .instructions li {
            margin-bottom: 8px;
        }
        .cta-button {
            display: inline-block;
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
            text-decoration: none;
            padding: 14px 30px;
            border-radius: 8px;
            font-weight: 600;
            font-size: 16px;
            margin: 20px 0;
            transition: transform 0.3s, box-shadow 0.3s;
        }
        .cta-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(74, 144, 226, 0.3);
        }
        .footer {
            text-align: center;
            padding: 25px;
            background: #f8f9fa;
            color: #666;
            font-size: 13px;
            border-top: 1px solid #eee;
        }
        .footer a {
            color: #4a90e2;
            text-decoration: none;
        }
        .timer {
            color: #dc3545;
            font-weight: bold;
            font-size: 14px;
        }
        .support {
            margin-top: 25px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            color: #777;
            font-size: 13px;
        }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="email-header">
            <h1>Reset Password Admin</h1>
            <p>KosCare Management System</p>
        </div>
        
        <div class="email-body">
            <div class="greeting">
                <p>Halo <strong><?= htmlspecialchars($name) ?></strong>,</p>
                <p>Kami menerima permintaan reset password untuk akun admin KosCare Anda. Berikut adalah kode verifikasi untuk melanjutkan proses reset password:</p>
            </div>
            
            <div class="code-container">
                <p style="margin-top: 0; color: #666;">Kode Verifikasi Anda:</p>
                <div class="reset-code"><?= $reset_code ?></div>
                <p class="timer">⏰ Kode ini berlaku selama <?= $expiry_time ?></p>
            </div>
            
            <div class="instructions">
                <h3>📋 Petunjuk Penggunaan:</h3>
                <ul>
                    <li>Masukkan kode di atas pada halaman verifikasi reset password</li>
                    <li>Kode hanya dapat digunakan satu kali</li>
                    <li>Jangan berikan kode ini kepada siapa pun</li>
                    <li>Jika Anda tidak meminta reset password, abaikan email ini</li>
                    <li>Password Anda tidak akan berubah hingga proses selesai</li>
                </ul>
            </div>
            
            <div style="text-align: center;">
                <a href="#" class="cta-button">Masuk ke Halaman Verifikasi</a>
                <p style="color: #777; font-size: 14px;">Atau salin dan tempel link berikut di browser Anda:<br>
                <code style="font-size: 12px; color: #4a90e2;"><?= base_url('admin/forgot_password/verify') ?></code></p>
            </div>
            
            <div class="support">
                <p><strong>Butuh Bantuan?</strong></p>
                <p>Jika Anda mengalami kendala atau memiliki pertanyaan, silakan hubungi tim support kami:</p>
                <p>📧 Email: support@koscare.com<br>
                📞 Telepon: (021) 1234-5678</p>
            </div>
        </div>
        
        <div class="footer">
            <p>© <?= $current_year ?> <strong>KosCare</strong>. All rights reserved.</p>
            <p>Jl. Contoh No. 123, Jakarta Selatan, Indonesia</p>
            <p>Email ini dikirim secara otomatis. Mohon tidak membalas email ini.</p>
        </div>
    </div>
</body>
</html>