<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lupa Password - KosCare Admin</title>
    <link rel="stylesheet" href="<?= base_url('asset/css/bootstrap.min.css') ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            width: 100%;
            max-width: 450px;
            padding: 40px 30px;
        }
        .icon-wrapper {
            width: 80px;
            height: 80px;
            background: #4a90e2;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            color: white;
            font-size: 2rem;
        }
        .alert {
            border-radius: 10px;
            border: none;
            padding: 15px;
            margin-bottom: 20px;
        }
        .alert-success {
            background: #d4edda;
            color: #155724;
            border-left: 4px solid #28a745;
        }
        .alert-info {
            background: #d1ecf1;
            color: #0c5460;
            border-left: 4px solid #17a2b8;
        }
        .alert-danger {
            background: #f8d7da;
            color: #721c24;
            border-left: 4px solid #dc3545;
        }
        .back-link {
            margin-top: 20px;
            text-align: center;
            display: block;
        }
        .info-box {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
            border-left: 4px solid #4a90e2;
        }
        .btn-submit {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
            border: none;
            padding: 14px;
            font-size: 16px;
            font-weight: 600;
            border-radius: 10px;
            transition: all 0.3s;
        }
        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(74, 144, 226, 0.4);
        }
        .btn-submit:disabled {
            opacity: 0.7;
            cursor: not-allowed;
        }
    </style>
</head>
<body>
    <div class="card">
        <div class="icon-wrapper">
            <i class="fas fa-key"></i>
        </div>
        
        <h3 class="text-center mb-4">Reset Password Admin</h3>
        
        <div class="info-box">
            <p class="mb-1">
                <i class="fas fa-info-circle text-primary mr-2"></i>
                <strong>Cara Reset Password:</strong>
            </p>
            <ol class="mb-0 pl-3" style="font-size: 14px;">
                <li>Masukkan email admin yang terdaftar</li>
                <li>Kami akan membuat kode reset 6 digit</li>
                <li>Kode akan ditampilkan di halaman berikutnya</li>
                <li>Masukkan kode untuk verifikasi</li>
                <li>Buat password baru</li>
            </ol>
        </div>
        
        <?php if ($this->session->flashdata('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle mr-2"></i>
                <?= $this->session->flashdata('success') ?>
            </div>
        <?php endif; ?>
        
        <?php if ($this->session->flashdata('info')): ?>
            <div class="alert alert-info">
                <i class="fas fa-info-circle mr-2"></i>
                <?= $this->session->flashdata('info') ?>
            </div>
        <?php endif; ?>
        
        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle mr-2"></i>
                <?= $this->session->flashdata('error') ?>
            </div>
        <?php endif; ?>
        
        <form method="post" action="<?= site_url('admin/forgot_password/process_request') ?>" id="resetForm">
            <div class="form-group mb-4">
                <label for="email" class="font-weight-bold">
                    <i class="fas fa-envelope mr-2"></i>Email Admin
                </label>
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text bg-light">
                            <i class="fas fa-at"></i>
                        </span>
                    </div>
                    <input type="email" 
                           class="form-control" 
                           id="email" 
                           name="email" 
                           placeholder="contoh@admin.com" 
                           required
                           autocomplete="email">
                </div>
                <small class="form-text text-muted">
                    <i class="fas fa-shield-alt mr-1"></i> 
                    Email harus terdaftar sebagai admin di sistem
                </small>
            </div>
            
            <button type="submit" class="btn-submit btn-block" id="submitBtn">
                <i class="fas fa-paper-plane mr-2"></i> Buat Kode Reset
            </button>
        </form>
        
        <a href="<?= site_url('admin/login') ?>" class="back-link">
            <i class="fas fa-arrow-left mr-1"></i> Kembali ke Login
        </a>
    </div>
    
    <script>
        // Auto focus on email input
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('email').focus();
        });
        
        // Form validation and loading state
        document.getElementById('resetForm').addEventListener('submit', function(e) {
            const email = document.getElementById('email').value;
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            
            if (!emailRegex.test(email)) {
                e.preventDefault();
                alert('Format email tidak valid!');
                return false;
            }
            
            // Show loading state
            const btn = document.getElementById('submitBtn');
            const originalHTML = btn.innerHTML;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Membuat kode...';
            btn.disabled = true;
            
            // Re-enable button after 5 seconds (in case of error)
            setTimeout(() => {
                btn.innerHTML = originalHTML;
                btn.disabled = false;
            }, 5000);
            
            return true;
        });
    </script>
</body>
</html>