<?php
// Determine active menu based on current URL
$current_url = uri_string(); // Get current URI segment
?>
<!doctype html>
<html>

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Tambah Kos - SistemKOS</title>
  <link rel="stylesheet" href="<?php echo base_url('asset/css/bootstrap.min.css'); ?>">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: #f0f8ff;
      color: #333;
    }

    /* TOPBAR IMPROVED */
    .topbar {
      background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
      padding: 12px 0;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      z-index: 1030;
      height: 60px;
    }

    .topbar-container {
      display: flex;
      justify-content: space-between;
      align-items: center;
      height: 100%;
      padding: 0 15px;
    }

    .brand-section {
      display: flex;
      align-items: center;
      gap: 15px;
      flex-shrink: 0;
    }

    .brand-logo {
      width: 50px;
      height: auto;
      transition: transform 0.3s;
    }

    .brand-logo:hover {
      transform: scale(1.05);
    }

    .brand-text {
      color: white;
    }

    .brand-text h4 {
      font-weight: 600;
      font-size: 1.3rem;
      margin: 0;
      line-height: 1.2;
    }

    .brand-text span {
      font-size: 0.9rem;
      opacity: 0.9;
      display: block;
      margin-top: 2px;
    }

    .user-section {
      display: flex;
      align-items: center;
      gap: 15px;
      flex-shrink: 0;
    }

    .user-info {
      display: flex;
      align-items: center;
      gap: 8px;
      color: white;
      font-size: 0.95rem;
      padding: 6px 12px;
      border-radius: 6px;
      transition: background 0.3s;
    }

    .user-info:hover {
      background: rgba(255, 255, 255, 0.1);
    }

    .user-info i {
      font-size: 1.2rem;
    }

    .logout-btn {
      display: flex;
      align-items: center;
      gap: 8px;
      color: white;
      text-decoration: none;
      padding: 8px 16px;
      border-radius: 6px;
      background: rgba(255, 255, 255, 0.15);
      transition: all 0.3s;
      font-size: 0.9rem;
      font-weight: 500;
    }

    .logout-btn:hover {
      background: rgba(255, 255, 255, 0.25);
      transform: translateY(-1px);
      color: white;
    }

    /* SIDEBAR STYLES */
    .sidebar {
      background: white;
      min-height: calc(100vh - 60px);
      padding: 25px 15px;
      box-shadow: 2px 0 10px rgba(0, 0, 0, 0.05);
      position: fixed;
      top: 60px;
      left: 0;
      width: 16.666667%;
      height: calc(100vh - 60px);
      overflow-y: auto;
      z-index: 1020;
    }

    .sidebar h5 {
      color: #4a90e2;
      margin-bottom: 20px;
      font-weight: 600;
      padding-bottom: 10px;
      border-bottom: 2px solid #e3f2fd;
    }

    .sidebar ul {
      list-style: none;
    }

    .sidebar ul li {
      margin-bottom: 8px;
    }

    .sidebar ul li a {
      display: block;
      padding: 12px 15px;
      color: #555;
      text-decoration: none;
      border-radius: 8px;
      transition: all 0.3s;
      font-size: 0.95rem;
      position: relative;
      overflow: hidden;
    }

    .sidebar ul li a:hover {
      background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
      color: white;
      transform: translateX(5px);
    }

    .sidebar ul li a.active {
      background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
      color: white;
      transform: translateX(5px);
      box-shadow: 0 4px 15px rgba(74, 144, 226, 0.3);
    }

    .sidebar ul li a.active:before {
      content: '';
      position: absolute;
      left: 0;
      top: 0;
      height: 100%;
      width: 4px;
      background: white;
      border-radius: 0 4px 4px 0;
    }

    .sidebar ul li a i {
      width: 20px;
      margin-right: 10px;
    }

    /* MAIN CONTENT */
    .main-content {
      margin-left: 16.666667%;
      margin-top: 60px;
      padding: 25px;
      background: #f0f8ff;
      min-height: calc(100vh - 60px);
    }

    .content-header {
      background: white;
      border-radius: 12px;
      padding: 20px 25px;
      margin-bottom: 25px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
    }

    .content-header h3 {
      color: #4a90e2;
      font-weight: 600;
      margin: 0;
    }

    .content-header .breadcrumb {
      background: transparent;
      padding: 0;
      margin: 10px 0 0 0;
      font-size: 0.9rem;
    }

    .content-header .breadcrumb-item {
      color: #888;
    }

    .content-header .breadcrumb-item.active {
      color: #4a90e2;
    }

    .content-header .breadcrumb-item a {
      color: #4a90e2;
      text-decoration: none;
    }

    .content-header .breadcrumb-item a:hover {
      text-decoration: underline;
    }

    .form-card {
      background: white;
      border-radius: 12px;
      padding: 30px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
    }

    .form-label {
      font-weight: 500;
      color: #555;
      margin-bottom: 8px;
      font-size: 0.95rem;
    }

    .form-label i {
      margin-right: 5px;
      color: #4a90e2;
    }

    .form-control,
    .form-select {
      border: 2px solid #e9ecef;
      border-radius: 8px;
      padding: 12px 15px;
      transition: all 0.3s;
      font-size: 0.95rem;
    }

    .form-control:focus,
    .form-select:focus {
      border-color: #4a90e2;
      box-shadow: 0 0 0 0.2rem rgba(74, 144, 226, 0.25);
    }

    textarea.form-control {
      min-height: 100px;
      resize: vertical;
    }

    .btn-success-custom {
      background: linear-gradient(135deg, #28a745 0%, #218838 100%);
      border: none;
      color: white;
      padding: 12px 30px;
      border-radius: 8px;
      text-decoration: none;
      transition: all 0.3s;
      font-size: 0.95rem;
      font-weight: 500;
      display: inline-block;
    }

    .btn-success-custom:hover {
      transform: translateY(-2px);
      box-shadow: 0 4px 15px rgba(40, 167, 69, 0.4);
      color: white;
    }

    .btn-secondary-custom {
      background: #6c757d;
      border: none;
      color: white;
      padding: 12px 30px;
      border-radius: 8px;
      text-decoration: none;
      transition: all 0.3s;
      font-size: 0.95rem;
      font-weight: 500;
      display: inline-block;
    }

    .btn-secondary-custom:hover {
      background: #5a6268;
      transform: translateY(-2px);
      box-shadow: 0 4px 15px rgba(108, 117, 125, 0.4);
      color: white;
    }

    .btn-success-custom i,
    .btn-secondary-custom i {
      margin-right: 8px;
    }

    .form-actions {
      margin-top: 30px;
      padding-top: 20px;
      border-top: 2px solid #e9ecef;
      display: flex;
      gap: 10px;
    }

    .info-box {
      background: #e3f2fd;
      border-left: 4px solid #4a90e2;
      padding: 15px;
      border-radius: 8px;
      margin-bottom: 25px;
      color: #555;
      font-size: 0.9rem;
    }

    .info-box i {
      color: #4a90e2;
      margin-right: 8px;
    }

    .sidebar::-webkit-scrollbar {
      width: 6px;
    }

    .sidebar::-webkit-scrollbar-track {
      background: #f1f1f1;
    }

    .sidebar::-webkit-scrollbar-thumb {
      background: #4a90e2;
      border-radius: 3px;
    }

    .sidebar::-webkit-scrollbar-thumb:hover {
      background: #357abd;
    }

    /* RESPONSIVE DESIGN */
    @media (max-width: 992px) {
      .sidebar {
        width: 25%;
      }

      .main-content {
        margin-left: 25%;
      }
    }

    @media (max-width: 768px) {
      .sidebar {
        position: relative;
        width: 100%;
        height: auto;
        min-height: auto;
        top: 0;
      }

      .main-content {
        margin-left: 0;
        margin-top: 0;
        padding: 15px;
      }

      .topbar {
        height: auto;
        padding: 10px 0;
      }

      .topbar-container {
        flex-direction: column;
        gap: 10px;
        height: auto;
      }

      .brand-section,
      .user-section {
        width: 100%;
        justify-content: center;
      }

      .form-card {
        padding: 20px;
      }

      .form-actions {
        flex-direction: column;
      }

      .btn-success-custom,
      .btn-secondary-custom {
        width: 100%;
        text-align: center;
      }

      .brand-text h4 {
        font-size: 1.1rem;
      }

      .brand-text span {
        font-size: 0.8rem;
      }

      .user-info,
      .logout-btn {
        font-size: 0.85rem;
      }
    }

    .required {
      color: #dc3545;
      margin-left: 3px;
    }

    @media (max-width: 576px) {
      .btn-success-custom,
      .btn-secondary-custom {
        padding: 10px 20px;
        font-size: 0.9rem;
      }
    }
  </style>
</head>

<body>
  <!-- TOPBAR IMPROVED -->
  <div class="topbar">
    <div class="container-fluid">
      <div class="topbar-container">
        <!-- Brand Section (Left) -->
        <div class="brand-section">
          <img src="<?= base_url('asset/logo 2.png'); ?>" alt="Logo KosCare" class="brand-logo">
          <div class="brand-text">
            <h4>KosCare</h4>
            <span>Dashboard Admin</span>
          </div>
        </div>

        <!-- User Section (Right) -->
        <div class="user-section">
          <div class="user-info">
            <i class="fas fa-user-circle"></i>
            <div>
              <span>Halo, <strong><?php echo $this->session->userdata('admin_name'); ?></strong></span>
            </div>
          </div>
          <a href="<?php echo site_url('admin/login/logout'); ?>" class="logout-btn">
            <i class="fas fa-sign-out-alt"></i> Logout
          </a>
        </div>
      </div>
    </div>
  </div>

  <!-- SIDEBAR -->
  <div class="sidebar" id="sidebar">
    <h5><i class="fas fa-bars"></i> Menu</h5>
    <ul>
      <li><a href="<?= site_url('admin/dashboard'); ?>" class="<?= strpos($current_url, 'dashboard') !== false ? 'active' : '' ?>"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
      <li><a href="<?= site_url('admin/laporan'); ?>" class="<?= strpos($current_url, 'laporan') !== false ? 'active' : '' ?>"><i class="fas fa-clipboard-list"></i> Laporan</a></li>
      <li><a href="<?= site_url('admin/penghuni'); ?>" class="<?= strpos($current_url, 'penghuni') !== false ? 'active' : '' ?>"><i class="fas fa-users"></i> Penghuni</a></li>
      <li><a href="<?= site_url('admin/iklan'); ?>" class="<?= strpos($current_url, 'iklan') !== false ? 'active' : '' ?>"><i class="fas fa-bullhorn"></i> Iklan</a></li>
      <li><a href="<?= site_url('admin/kos'); ?>" class="<?= (strpos($current_url, 'kos') !== false && strpos($current_url, 'penghuni') === false) ? 'active' : '' ?>"><i class="fas fa-building"></i> Kos</a></li>
      <li><a href="<?= site_url('admin/pengaturan'); ?>" class="<?= strpos($current_url, 'pengaturan') !== false ? 'active' : '' ?>"><i class="fas fa-cog"></i> Pengaturan</a></li>
    </ul>
  </div>

  <div class="main-content">
    <div class="info-box">
      <i class="fas fa-info-circle"></i>
      <strong>Informasi:</strong> Lengkapi formulir di bawah ini untuk menambahkan kos baru ke dalam sistem.
    </div>

    <div class="form-card">
      <form method="post" action="<?= site_url('admin/kos/simpan') ?>">
        <div class="mb-4">
          <label class="form-label">
            <i class="fas fa-building"></i> Nama Kos <span class="required">*</span>
          </label>
          <input type="text" name="nama_kos" class="form-control" placeholder="Contoh: Kos Mawar Putih" required>
        </div>

        <div class="mb-4">
          <label class="form-label">
            <i class="fas fa-map-marker-alt"></i> Alamat <span class="required">*</span>
          </label>
          <textarea name="alamat" class="form-control" placeholder="Masukkan alamat lengkap kos..." required></textarea>
        </div>

        <div class="mb-4">
          <label class="form-label">
            <i class="fas fa-door-open"></i> Jumlah Kamar <span class="required">*</span>
          </label>
          <input type="number" name="jumlah_kamar" class="form-control" placeholder="Contoh: 10" min="1" required>
        </div>

        <div class="mb-4">
          <label class="form-label">
            <i class="fas fa-align-left"></i> Deskripsi
          </label>
          <textarea name="deskripsi" class="form-control" placeholder="Masukkan deskripsi atau keterangan tambahan tentang kos (opsional)"></textarea>
        </div>

        <div class="mb-4">
          <label class="form-label">
            <i class="fas fa-toggle-on"></i> Status <span class="required">*</span>
          </label>
          <select name="status" class="form-control">
            <option value="Aktif" selected>Aktif</option>
            <option value="Nonaktif">Nonaktif</option>
          </select>
        </div>

        <div class="form-actions">
          <button type="submit" class="btn-success-custom">
            <i class="fas fa-save"></i> Simpan Data
          </button>
          <a href="<?= site_url('admin/kos') ?>" class="btn-secondary-custom">
            <i class="fas fa-times"></i> Batal
          </a>
        </div>
      </form>
    </div>
  </div>

  <script src="<?php echo base_url('asset/js/jquery-3.6.0.min.js'); ?>"></script>
  <script src="<?php echo base_url('asset/js/bootstrap.bundle.min.js'); ?>"></script>

  <script>
    // Add hover effects to logout button
    document.addEventListener('DOMContentLoaded', function() {
      const logoutBtn = document.querySelector('.logout-btn');
      if (logoutBtn) {
        logoutBtn.addEventListener('mouseenter', function() {
          this.style.transform = 'translateY(-1px) scale(1.02)';
        });
        logoutBtn.addEventListener('mouseleave', function() {
          this.style.transform = 'translateY(0) scale(1)';
        });
      }
    });
  </script>
</body>

</html>