<!doctype html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title><?php echo isset($title) ? $title : 'Laporan dari Penghuni'; ?></title>
    <link rel="stylesheet" href="<?php echo base_url('asset/css/bootstrap.min.css'); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        :root {
            --primary: #4a90e2;
            --primary-dark: #357abd;
            --secondary: #6c757d;
            --success: #28a745;
            --warning: #ffc107;
            --danger: #dc3545;
            --light: #f8f9fa;
            --dark: #343a40;
            --gray-100: #f8f9fa;
            --gray-200: #e9ecef;
            --gray-300: #dee2e6;
            --gray-400: #ced4da;
            --gray-500: #adb5bd;
            --gray-600: #6c757d;
            --gray-700: #495057;
            --gray-800: #343a40;
            --gray-900: #212529;
            --border-radius: 12px;
            --box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            --transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #f5f7fa 0%, #e4edf5 100%);
            color: var(--gray-800);
            line-height: 1.6;
            min-height: 100vh;
        }

        .topbar {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            padding: 16px 0;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1030;
            backdrop-filter: blur(10px);
        }

        .topbar h4 {
            color: white;
            font-weight: 600;
            font-size: 1.4rem;
            letter-spacing: -0.3px;
        }

        .topbar a {
            color: white;
            text-decoration: none;
            transition: var(--transition);
            font-weight: 500;
        }

        .topbar a:hover {
            opacity: 0.9;
            transform: translateY(-1px);
        }

        .topbar .user-info {
            color: white;
            font-size: 0.95rem;
            background: rgba(255, 255, 255, 0.15);
            padding: 8px 16px;
            border-radius: 50px;
            backdrop-filter: blur(5px);
        }

        .sidebar {
            background: white;
            min-height: calc(100vh - 68px);
            padding: 28px 20px;
            box-shadow: 4px 0 20px rgba(0, 0, 0, 0.06);
            position: fixed;
            top: 68px;
            left: 0;
            width: 260px;
            height: calc(100vh - 68px);
            overflow-y: auto;
            z-index: 1020;
            border-right: 1px solid var(--gray-200);
        }

        .sidebar h5 {
            color: var(--gray-700);
            margin-bottom: 24px;
            font-weight: 600;
            padding-bottom: 12px;
            border-bottom: 2px solid var(--gray-200);
            font-size: 1.1rem;
            letter-spacing: -0.2px;
        }

        .sidebar ul {
            list-style: none;
            padding: 0;
        }

        .sidebar ul li {
            margin-bottom: 6px;
            position: relative;
        }

        .sidebar ul li a {
            display: flex;
            align-items: center;
            padding: 12px 16px;
            color: var(--gray-700);
            text-decoration: none;
            border-radius: var(--border-radius);
            transition: var(--transition);
            font-weight: 500;
            font-size: 0.95rem;
            position: relative;
        }

        .sidebar ul li a:hover {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
            transform: translateX(8px);
            box-shadow: 0 4px 12px rgba(74, 144, 226, 0.3);
        }

        .sidebar ul li a.active {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
            transform: translateX(8px);
            box-shadow: 0 4px 12px rgba(74, 144, 226, 0.3);
        }

        .sidebar ul li a i {
            width: 20px;
            margin-right: 12px;
            font-size: 1.1rem;
            transition: var(--transition);
        }

        .main-content {
            margin-left: 260px;
            margin-top: 68px;
            padding: 30px;
            min-height: calc(100vh - 68px);
            transition: var(--transition);
        }

        /* Professional Cards */
        .card {
            background: white;
            border-radius: var(--border-radius);
            padding: 0;
            box-shadow: var(--box-shadow);
            margin-bottom: 24px;
            border: none;
            overflow: hidden;
            transition: var(--transition);
        }

        .card:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
        }

        .card-header {
            background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
            border-bottom: 1px solid var(--gray-200);
            padding: 20px 30px;
            margin: 0;
        }

        .card-header h5 {
            color: var(--gray-800);
            font-weight: 600;
            margin: 0;
            font-size: 1.25rem;
            letter-spacing: -0.3px;
        }

        .card-body {
            padding: 30px;
        }

        /* Improved Badges */
        .badge-status {
            display: inline-flex;
            align-items: center;
            padding: 6px 14px;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 500;
            letter-spacing: 0.3px;
            transition: var(--transition);
        }

        .badge-pending {
            background: linear-gradient(135deg, #fff8e1 0%, #ffecb3 100%);
            color: #e65100;
            border: 1px solid #ffd54f;
        }

        .badge-process {
            background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%);
            color: #0d47a1;
            border: 1px solid #64b5f6;
        }

        .badge-done {
            background: linear-gradient(135deg, #e8f5e8 0%, #c8e6c9 100%);
            color: #1b5e20;
            border: 1px solid #81c784;
        }

        .badge-warning {
            background: linear-gradient(135deg, #fff3e0 0%, #ffe0b2 100%);
            color: #e65100;
            border: 1px solid #ffb74d;
        }

        .badge-danger {
            background: linear-gradient(135deg, #ffebee 0%, #ffcdd2 100%);
            color: #c62828;
            border: 1px solid #ef9a9a;
        }

        .badge-secondary {
            background: linear-gradient(135deg, #f5f5f5 0%, #eeeeee 100%);
            color: #616161;
            border: 1px solid #e0e0e0;
        }

        /* Improved Table */
        .table-container {
            background: white;
            border-radius: var(--border-radius);
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        .table {
            margin-bottom: 0;
            border-collapse: separate;
            border-spacing: 0;
        }

        .table thead th {
            background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
            border: none;
            padding: 16px 20px;
            font-weight: 600;
            color: var(--gray-700);
            font-size: 0.85rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            border-bottom: 2px solid var(--gray-200);
            white-space: nowrap;
        }

        .table tbody td {
            padding: 20px;
            vertical-align: middle;
            font-size: 0.95rem;
            border-bottom: 1px solid var(--gray-200);
            transition: var(--transition);
        }

        .table tbody tr {
            transition: var(--transition);
        }

        .table tbody tr:hover {
            background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        }

        .table tbody tr:hover td {
            border-color: var(--primary);
        }

        /* User Avatar */
        .user-avatar {
            width: 44px;
            height: 44px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            font-size: 1.1rem;
            box-shadow: 0 4px 8px rgba(74, 144, 226, 0.3);
            transition: var(--transition);
        }

        .user-avatar:hover {
            transform: scale(1.1) rotate(5deg);
            box-shadow: 0 6px 15px rgba(74, 144, 226, 0.4);
        }

        /* Filter Buttons */
        .filter-buttons {
            display: flex;
            gap: 12px;
            margin-bottom: 24px;
            flex-wrap: wrap;
        }

        .filter-btn {
            padding: 10px 24px;
            border-radius: 25px;
            border: 2px solid var(--gray-300);
            background: white;
            color: var(--gray-700);
            text-decoration: none;
            transition: var(--transition);
            font-size: 0.9rem;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
        }

        .filter-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.1);
            border-color: var(--primary);
            color: var(--primary);
        }

        .filter-btn.active {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
            border-color: var(--primary);
            box-shadow: 0 4px 12px rgba(74, 144, 226, 0.3);
        }

        /* Stat Cards */
        .stat-card {
            background: white;
            border-radius: var(--border-radius);
            padding: 24px;
            box-shadow: var(--box-shadow);
            margin-bottom: 0;
            border: none;
            transition: var(--transition);
            height: 100%;
            position: relative;
            overflow: hidden;
        }

        .stat-card:hover {
            transform: translateY(-6px);
            box-shadow: 0 12px 30px rgba(0, 0, 0, 0.15);
        }

        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
        }

        .stat-card i {
            font-size: 2.2rem;
            margin-bottom: 16px;
            opacity: 0.9;
        }

        .stat-card h3 {
            font-size: 2.8rem;
            font-weight: 700;
            margin: 8px 0 4px;
            background: linear-gradient(135deg, var(--gray-800) 0%, var(--gray-600) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            letter-spacing: -1px;
        }

        .stat-card p {
            color: var(--gray-600);
            font-size: 0.95rem;
            font-weight: 500;
            margin: 0;
        }

        /* Improved Modal */
        .modal-content {
            border-radius: var(--border-radius);
            border: none;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.2);
            overflow: hidden;
        }

        .modal-header {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
            padding: 20px 30px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .modal-title {
            font-weight: 600;
            font-size: 1.3rem;
            letter-spacing: -0.3px;
        }

        .modal-body {
            padding: 30px;
            background: linear-gradient(135deg, #fafbfc 0%, #f5f7fa 100%);
        }

        .modal-footer {
            padding: 20px 30px;
            background: white;
            border-top: 1px solid var(--gray-200);
        }

        /* Buttons */
        .btn-action {
            padding: 8px 20px;
            border-radius: 8px;
            font-size: 0.9rem;
            font-weight: 500;
            border: none;
            transition: var(--transition);
            display: inline-flex;
            align-items: center;
            gap: 8px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }

        .btn-action:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 18px rgba(0, 0, 0, 0.15);
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            border: none;
        }

        .btn-primary:hover {
            background: linear-gradient(135deg, var(--primary-dark) 0%, #2a6ba8 100%);
            transform: translateY(-3px);
            box-shadow: 0 6px 18px rgba(74, 144, 226, 0.3);
        }

        /* Alerts */
        .alert {
            border-radius: var(--border-radius);
            border: none;
            padding: 16px 20px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            margin-bottom: 24px;
            border-left: 4px solid transparent;
            animation: slideIn 0.5s cubic-bezier(0.25, 0.46, 0.45, 0.94);
        }

        .alert-success {
            background: linear-gradient(135deg, #e8f5e8 0%, #d0e9d0 100%);
            border-left-color: var(--success);
            color: #1b5e20;
        }

        .alert-danger {
            background: linear-gradient(135deg, #ffebee 0%, #ffd6dc 100%);
            border-left-color: var(--danger);
            color: #c62828;
        }

        .alert-warning {
            background: linear-gradient(135deg, #fff8e1 0%, #ffecb3 100%);
            border-left-color: var(--warning);
            color: #e65100;
        }

        /* Empty State */
        .empty-state {
            text-align: center;
            padding: 60px 40px;
            color: var(--gray-600);
        }

        .empty-state i {
            font-size: 5rem;
            color: var(--gray-300);
            margin-bottom: 20px;
            opacity: 0.7;
        }

        .empty-state p {
            font-size: 1.1rem;
            margin-bottom: 24px;
            color: var(--gray-600);
        }

        /* Read Only Badge */
        .read-only-badge {
            position: absolute;
            top: 20px;
            right: 30px;
            background: linear-gradient(135deg, var(--gray-600) 0%, var(--gray-700) 100%);
            color: white;
            padding: 6px 14px;
            border-radius: 20px;
            font-size: 0.85rem;
            font-weight: 500;
            letter-spacing: 0.3px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            z-index: 1;
        }

        /* Warning/Danger Box */
        .info-box {
            background: white;
            border-radius: var(--border-radius);
            padding: 20px;
            margin-bottom: 24px;
            border-left: 4px solid;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        }

        .warning-box {
            border-left-color: var(--warning);
            background: linear-gradient(135deg, #fff8e1 0%, #fff3cd 100%);
        }

        .danger-box {
            border-left-color: var(--danger);
            background: linear-gradient(135deg, #ffebee 0%, #ffe6e9 100%);
        }

        /* Animations */
        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }
            to {
                opacity: 1;
                        transform: translateY(0);
            }
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }
            to {
                opacity: 1;
            }
        }

        /* Pagination */
        .pagination {
            margin-top: 30px;
        }

        .page-item .page-link {
            border: none;
            border-radius: 8px;
            margin: 0 4px;
            color: var(--gray-700);
            font-weight: 500;
            transition: var(--transition);
            padding: 10px 18px;
        }

        .page-item.active .page-link {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
            box-shadow: 0 4px 12px rgba(74, 144, 226, 0.3);
        }

        .page-item .page-link:hover {
            background: var(--gray-200);
            color: var(--primary);
            transform: translateY(-2px);
        }

        /* Responsive */
        @media (max-width: 1200px) {
            .sidebar {
                width: 240px;
            }
            .main-content {
                margin-left: 240px;
            }
        }

        @media (max-width: 992px) {
            .sidebar {
                position: fixed;
                left: -280px;
                top: 68px;
                width: 280px;
                transition: var(--transition);
                z-index: 1040;
            }
            
            .sidebar.show {
                left: 0;
            }
            
            .main-content {
                margin-left: 0;
                padding: 20px;
            }
            
            .filter-buttons {
                flex-direction: column;
            }
            
            .filter-btn {
                width: 100%;
                justify-content: center;
            }
        }

        @media (max-width: 768px) {
            .topbar h4 {
                font-size: 1.2rem;
            }
            
            .main-content {
                padding: 15px;
            }
            
            .card-body {
                padding: 20px;
            }
            
            .stat-card h3 {
                font-size: 2.2rem;
            }
        }

        @media (max-width: 576px) {
            .table-responsive {
                border-radius: var(--border-radius);
                overflow: hidden;
            }
            
            .table thead {
                display: none;
            }
            
            .table tbody tr {
                display: block;
                margin-bottom: 20px;
                border-radius: var(--border-radius);
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
                overflow: hidden;
            }
            
            .table tbody td {
                display: block;
                text-align: right;
                padding: 12px 20px;
                position: relative;
            }
            
            .table tbody td::before {
                content: attr(data-label);
                position: absolute;
                left: 20px;
                width: 45%;
                padding-right: 20px;
                font-weight: 600;
                text-align: left;
                color: var(--gray-700);
            }
        }

        /* Smooth scrolling */
        html {
            scroll-behavior: smooth;
        }

        /* Custom scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }

        ::-webkit-scrollbar-track {
            background: var(--gray-100);
            border-radius: 4px;
        }

        ::-webkit-scrollbar-thumb {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            border-radius: 4px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: linear-gradient(135deg, var(--primary-dark) 0%, #2a6ba8 100%);
        }

        /* Loading animation */
        .loading {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid rgba(255,255,255,.3);
            border-radius: 50%;
            border-top-color: white;
            animation: spin 1s ease-in-out infinite;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }
    </style>
</head>

<body>
    <!-- Navbar (tidak diubah) -->
    <div class="topbar">
        <div class="container-fluid">
            <div class="d-flex justify-content-between align-items-center">
                <h4 class="m-0">
                    <i class="fas fa-home"></i> KosCare- Laporan dari Penghuni
                </h4>
                <div class="user-info">
                    <i class="fas fa-user-circle"></i>
                    Halo, <strong><?= $this->session->userdata('admin_name'); ?></strong> |
                    <a href="<?= site_url('admin/logout'); ?>">
                        <i class="fas fa-sign-out-alt"></i> Logout
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Sidebar (tidak diubah) -->
    <div class="sidebar" id="sidebar">
        <h5><i class="fas fa-bars"></i> Menu</h5>
        <ul>
            <li><a href="<?= site_url('admin/dashboard'); ?>"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
            <li><a href="<?= site_url('admin/laporan'); ?>"><i class="fas fa-clipboard-list"></i> Laporan</a></li>
            <li><a href="<?= site_url('admin/penghuni'); ?>"><i class="fas fa-users"></i> Penghuni</a></li>
            <li><a href="<?= site_url('admin/subscription'); ?>"><i class="fas fa-crown"></i> Berlangganan</a></li>
            <li><a href="<?= site_url('admin/chat_v2'); ?>"><i class="fas fa-comments"></i> Chat</a></li>
            <li><a href="<?= site_url('admin/iklan'); ?>"><i class="fas fa-bullhorn"></i> Iklan</a></li>
            <li><a href="<?= site_url('admin/kos'); ?>"><i class="fas fa-building"></i> Kos</a></li>
            <li class="menu-item-wrapper">
                <a href="<?= site_url('admin/laporan_admin_reports'); ?>" class="active">
                    <i class="fas fa-flag"></i> Laporan Admin
                    <?php if ($total_count > 0): ?>
                        <span class="badge bg-danger" style="position: absolute; top: 5px; right: 5px;"><?= $total_count; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li><a href="<?= site_url('admin/pengaturan'); ?>"><i class="fas fa-cog"></i> Pengaturan</a></li>
        </ul>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle me-2"></i> <?= $this->session->flashdata('success'); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle me-2"></i> <?= $this->session->flashdata('error'); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <!-- Information Box -->
        <div class="info-box warning-box mb-4">
            <div class="d-flex align-items-start">
                <i class="fas fa-exclamation-triangle text-warning me-3" style="font-size: 1.5rem; flex-shrink: 0;"></i>
                <div>
                    <h6 class="mb-2 fw-600"><i class="fas fa-info-circle"></i> Informasi Penting</h6>
                    <p class="mb-0" style="font-size: 0.95rem;">
                        Laporan ini adalah peringatan/resiko dari <strong>Super Admin</strong>.
                        Anda hanya dapat <strong>melihat detail</strong> laporan tanpa dapat mengubahnya.
                        Jika ada kesalahan atau ingin klarifikasi, hubungi Super Admin.
                    </p>
                </div>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="row mb-4 g-4">
            <div class="col-md-3">
                <div class="stat-card">
                    <i class="fas fa-flag" style="color: var(--primary);"></i>
                    <h3><?= $total_count; ?></h3>
                    <p>Total Laporan</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card">
                    <i class="fas fa-clock" style="color: var(--warning);"></i>
                    <h3><?= $pending_count; ?></h3>
                    <p>Belum Dibaca</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card">
                    <i class="fas fa-spinner" style="color: var(--primary);"></i>
                    <h3><?= $process_count; ?></h3>
                    <p>Sedang Diproses</p>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-card">
                    <i class="fas fa-check-circle" style="color: var(--success);"></i>
                    <h3><?= $done_count; ?></h3>
                    <p>Sudah Ditindak</p>
                </div>
            </div>
        </div>

        <!-- Filter Buttons -->
        <div class="filter-buttons">
            <a href="?status=all" class="filter-btn <?= (!isset($_GET['status']) || $_GET['status'] == 'all') ? 'active' : ''; ?>">
                <i class="fas fa-list"></i> Semua
            </a>
            <a href="?status=pending" class="filter-btn <?= (isset($_GET['status']) && $_GET['status'] == 'pending') ? 'active' : ''; ?>">
                <i class="fas fa-clock"></i> Belum Dibaca
            </a>
            <a href="?status=diproses" class="filter-btn <?= (isset($_GET['status']) && $_GET['status'] == 'diproses') ? 'active' : ''; ?>">
                <i class="fas fa-spinner"></i> Diproses
            </a>
            <a href="?status=selesai" class="filter-btn <?= (isset($_GET['status']) && $_GET['status'] == 'selesai') ? 'active' : ''; ?>">
                <i class="fas fa-check-circle"></i> Selesai
            </a>
        </div>

        <!-- Reports Table -->
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-list me-2"></i> Daftar Laporan dari Penghuni</h5>
                <span class="read-only-badge">READ ONLY</span>
            </div>
            <div class="card-body">
                <?php if (!empty($reports)): ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th width="20%">Penghuni</th>
                                    <th width="25%">Judul</th>
                                    <th width="15%">Status</th>
                                    <th width="20%">Tindakan Super Admin</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $no = 1;
                                foreach ($reports as $report): ?>
                                    <?php
                                    // Filter berdasarkan status jika ada parameter
                                    if (isset($_GET['status']) && $_GET['status'] != 'all' && $_GET['status'] != $report->status) {
                                        continue;
                                    }
                                    ?>
                                    <tr data-report-id="<?= $report->id_report; ?>">
                                        <td data-label="No"><?= $no++; ?></td>
                                        <td data-label="Penghuni">
                                            <div style="display: flex; align-items: center; gap: 12px;">
                                                <div class="user-avatar">
                                                    <?= strtoupper(substr($report->nama_penghuni, 0, 1)); ?>
                                                </div>
                                                <div>
                                                    <div style="font-weight: 600; color: var(--gray-800);"><?= $report->nama_penghuni; ?></div>
                                                    <small style="color: var(--gray-600); font-size: 0.85rem;"><?= $report->penghuni_email; ?></small>
                                                </div>
                                            </div>
                                        </td>
                                        <td data-label="Judul">
                                            <div style="font-weight: 500; color: var(--gray-800);">
                                                <i class="fas fa-exclamation-triangle text-warning me-1"></i>
                                                <?= htmlspecialchars($report->judul); ?>
                                            </div>
                                            <small style="color: var(--gray-500); font-size: 0.85rem;">
                                                <?= date('d M Y', strtotime($report->created_at)); ?>
                                            </small>
                                        </td>
                                        <td data-label="Status">
                                            <?php if ($report->status == 'pending'): ?>
                                                <span class="badge-status badge-pending">
                                                    <i class="fas fa-clock me-1"></i> Belum Dibaca
                                                </span>
                                            <?php elseif ($report->status == 'diproses'): ?>
                                                <span class="badge-status badge-process">
                                                    <i class="fas fa-spinner me-1"></i> Diproses
                                                </span>
                                            <?php else: ?>
                                                <span class="badge-status badge-done">
                                                    <i class="fas fa-check me-1"></i> Selesai
                                                </span>
                                            <?php endif; ?>
                                        </td>
                                        <td data-label="Tindakan">
                                            <?php if ($report->tindakan == 'none'): ?>
                                                <span class="badge-status badge-secondary">
                                                    <i class="fas fa-minus me-1"></i> Belum Ada
                                                </span>
                                            <?php elseif ($report->tindakan == 'peringatan'): ?>
                                                <span class="badge-status badge-warning">
                                                    <i class="fas fa-exclamation-triangle me-1"></i> Peringatan
                                                </span>
                                            <?php elseif ($report->tindakan == 'nonaktif_sementara'): ?>
                                                <span class="badge-status badge-danger">
                                                    <i class="fas fa-user-clock me-1"></i> Nonaktif Sementara
                                                </span>
                                            <?php elseif ($report->tindakan == 'nonaktif_permanen'): ?>
                                                <span class="badge-status badge-danger">
                                                    <i class="fas fa-user-slash me-1"></i> Nonaktif Permanen
                                                </span>
                                            <?php else: ?>
                                                <span class="badge-status badge-secondary">
                                                    <?= $report->tindakan; ?>
                                                </span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>

                                    <!-- Detail Modal - READ ONLY -->
                                    <div class="modal fade" id="detailModal<?= $report->id_report; ?>" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-lg modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title"><i class="fas fa-file-alt me-2"></i> Detail Laporan</h5>
                                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <!-- Warning Alert -->
                                                    <div class="alert alert-warning mb-4">
                                                        <div class="d-flex align-items-start">
                                                            <i class="fas fa-exclamation-triangle me-3" style="font-size: 1.5rem; flex-shrink: 0;"></i>
                                                            <div>
                                                                <strong>PERINGATAN DARI SUPER ADMIN</strong>
                                                                <p class="mb-0" style="font-size: 0.95rem;">Laporan ini hanya untuk dilihat. Anda tidak dapat mengubah status atau tindakan.</p>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row mb-4">
                                                        <div class="col-md-6 mb-3">
                                                            <div class="card h-100">
                                                                <div class="card-body">
                                                                    <h6 class="card-title mb-3"><i class="fas fa-user me-2"></i> Informasi Penghuni</h6>
                                                                    <div class="mb-3">
                                                                        <small class="text-muted d-block">Nama Penghuni</small>
                                                                        <div class="fw-bold text-dark"><?= $report->nama_penghuni; ?></div>
                                                                    </div>
                                                                    <div class="mb-3">
                                                                        <small class="text-muted d-block">Email</small>
                                                                        <div class="fw-bold text-dark"><?= $report->penghuni_email; ?></div>
                                                                    </div>
                                                                    <div>
                                                                        <small class="text-muted d-block">Tanggal Laporan</small>
                                                                        <div class="fw-bold text-dark">
                                                                            <i class="far fa-calendar me-1"></i>
                                                                            <?= date('d M Y H:i', strtotime($report->created_at)); ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-md-6 mb-3">
                                                            <div class="card h-100">
                                                                <div class="card-body">
                                                                    <h6 class="card-title mb-3"><i class="fas fa-info-circle me-2"></i> Status & Tindakan</h6>
                                                                    <div class="mb-3">
                                                                        <small class="text-muted d-block">Status Laporan</small>
                                                                        <div>
                                                                            <?php if ($report->status == 'pending'): ?>
                                                                                <span class="badge-status badge-pending">
                                                                                    <i class="fas fa-clock me-1"></i> Belum Dibaca
                                                                                </span>
                                                                            <?php elseif ($report->status == 'diproses'): ?>
                                                                                <span class="badge-status badge-process">
                                                                                    <i class="fas fa-spinner me-1"></i> Diproses
                                                                                </span>
                                                                            <?php else: ?>
                                                                                <span class="badge-status badge-done">
                                                                                    <i class="fas fa-check me-1"></i> Selesai
                                                                                </span>
                                                                            <?php endif; ?>
                                                                        </div>
                                                                    </div>

                                                                    <div class="mb-3">
                                                                        <small class="text-muted d-block">Tindakan dari Super Admin</small>
                                                                        <div>
                                                                            <?php if ($report->tindakan == 'none'): ?>
                                                                                <span class="badge-status badge-secondary">
                                                                                    <i class="fas fa-minus me-1"></i> Belum Ada
                                                                                </span>
                                                                            <?php elseif ($report->tindakan == 'peringatan'): ?>
                                                                                <span class="badge-status badge-warning">
                                                                                    <i class="fas fa-exclamation-triangle me-1"></i> Peringatan
                                                                                </span>
                                                                            <?php elseif ($report->tindakan == 'nonaktif_sementara'): ?>
                                                                                <span class="badge-status badge-danger">
                                                                                    <i class="fas fa-user-clock me-1"></i> Nonaktif Sementara
                                                                                </span>
                                                                            <?php elseif ($report->tindakan == 'nonaktif_permanen'): ?>
                                                                                <span class="badge-status badge-danger">
                                                                                    <i class="fas fa-user-slash me-1"></i> Nonaktif Permanen
                                                                                </span>
                                                                            <?php else: ?>
                                                                                <span class="badge-status badge-secondary">
                                                                                    <?= $report->tindakan; ?>
                                                                                </span>
                                                                            <?php endif; ?>
                                                                        </div>
                                                                    </div>

                                                                    <?php if ($report->tindakan != 'none'): ?>
                                                                        <div>
                                                                            <small class="text-muted d-block">Keterangan Tindakan</small>
                                                                            <div class="fw-bold text-danger">
                                                                                <i class="fas fa-exclamation-circle me-1"></i>
                                                                                <?= $report->tindakan == 'peringatan' ? 'Anda mendapatkan peringatan dari Super Admin' : ($report->tindakan == 'nonaktif_sementara' ? 'Akun Anda dinonaktifkan sementara oleh Super Admin' :
                                                                                        'Akun Anda dinonaktifkan permanen oleh Super Admin'); ?>
                                                                            </div>
                                                                        </div>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <!-- Judul Laporan -->
                                                    <div class="card mb-4">
                                                        <div class="card-body">
                                                            <h6 class="card-title mb-3"><i class="fas fa-heading me-2"></i> Judul Laporan</h6>
                                                            <div class="p-3" style="background: linear-gradient(135deg, #ffebee 0%, #ffe6e9 100%); border-radius: 8px; border-left: 4px solid var(--danger);">
                                                                <h5 class="mb-0 text-danger">
                                                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                                                    <?= htmlspecialchars($report->judul); ?>
                                                                </h5>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <!-- Deskripsi Laporan -->
                                                    <?php if (!empty($report->deskripsi)): ?>
                                                        <div class="card mb-4">
                                                            <div class="card-body">
                                                                <h6 class="card-title mb-3"><i class="fas fa-align-left me-2"></i> Deskripsi Laporan</h6>
                                                                <div class="p-3" style="background: var(--gray-100); border-radius: 8px; white-space: pre-line; font-size: 0.95rem;">
                                                                    <?= nl2br(htmlspecialchars($report->deskripsi)); ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>

                                                    <!-- Catatan dari Super Admin -->
                                                    <?php if (!empty($report->catatan)): ?>
                                                        <div class="card mb-4">
                                                            <div class="card-body">
                                                                <h6 class="card-title mb-3"><i class="fas fa-sticky-note me-2"></i> Catatan dari Super Admin</h6>
                                                                <div class="p-3 warning-box">
                                                                    <div class="d-flex align-items-start">
                                                                        <i class="fas fa-comment-dots text-warning me-3" style="font-size: 1.2rem; flex-shrink: 0;"></i>
                                                                        <div style="white-space: pre-line; font-size: 0.95rem;">
                                                                            <?= nl2br(htmlspecialchars($report->catatan)); ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>

                                                    <!-- Last Updated -->
                                                    <?php if (!empty($report->updated_at) && $report->updated_at != $report->created_at): ?>
                                                        <div class="card mb-4">
                                                            <div class="card-body">
                                                                <h6 class="card-title mb-3"><i class="fas fa-history me-2"></i> Terakhir Diupdate</h6>
                                                                <div class="text-muted">
                                                                    <i class="far fa-clock me-1"></i>
                                                                    <?= date('d M Y H:i', strtotime($report->updated_at)); ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>

                                                    <!-- Information Card -->
                                                    <div class="card mt-4" style="background: linear-gradient(135deg, #e7f3ff 0%, #d9ebff 100%); border: none;">
                                                        <div class="card-body">
                                                            <h6 class="card-title mb-3"><i class="fas fa-lightbulb me-2"></i> Apa yang harus dilakukan?</h6>
                                                            <ul class="mb-0 ps-3" style="font-size: 0.95rem;">
                                                                <li class="mb-2">Laporan ini adalah <strong>peringatan/resiko</strong> dari Super Admin</li>
                                                                <li class="mb-2">Perbaiki perilaku atau sistem pengelolaan kos Anda sesuai catatan di atas</li>
                                                                <li class="mb-2">Jika ada kesalahan atau ingin klarifikasi, <strong>hubungi Super Admin</strong></li>
                                                                <li class="mb-2">Jangan abaikan laporan ini untuk menghindari sanksi lebih lanjut</li>
                                                                <li>Gunakan sebagai bahan evaluasi untuk meningkatkan layanan</li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                                                        <i class="fas fa-times me-1"></i> Tutup
                                                    </button>
                                                    <?php if ($report->status == 'pending'): ?>
                                                        <button type="button" class="btn btn-success" onclick="markAsRead(<?= $report->id_report; ?>)">
                                                            <i class="fas fa-check me-1"></i> Tandai Sudah Dibaca
                                                        </button>
                                                    <?php else: ?>
                                                        <span class="text-success me-3">
                                                            <i class="fas fa-check-circle me-1"></i> Sudah dibaca
                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="empty-state">
                        <i class="fas fa-inbox"></i>
                        <p class="mt-3">Belum ada laporan dari penghuni</p>
                        <a href="<?= site_url('admin/dashboard'); ?>" class="btn btn-primary mt-3">
                            <i class="fas fa-arrow-left me-2"></i> Kembali ke Dashboard
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Pagination -->
        <?php if (!empty($reports) && $total_count > 10): ?>
            <nav aria-label="Page navigation">
                <ul class="pagination justify-content-center">
                    <li class="page-item disabled">
                        <a class="page-link" href="#" tabindex="-1">
                            <i class="fas fa-chevron-left me-1"></i> Sebelumnya
                        </a>
                    </li>
                    <li class="page-item active"><a class="page-link" href="#">1</a></li>
                    <li class="page-item"><a class="page-link" href="#">2</a></li>
                    <li class="page-item"><a class="page-link" href="#">3</a></li>
                    <li class="page-item">
                        <a class="page-link" href="#">
                            Selanjutnya <i class="fas fa-chevron-right ms-1"></i>
                        </a>
                    </li>
                </ul>
            </nav>
        <?php endif; ?>
    </div>

    <script src="<?php echo base_url('asset/js/jquery-3.6.0.min.js'); ?>"></script>
    <script src="<?php echo base_url('asset/js/bootstrap.bundle.min.js'); ?>"></script>

    <script>
        // Initialize tooltips
        $(function () {
            $('[data-bs-toggle="tooltip"]').tooltip();
        });

        // Filter reports
        document.addEventListener('DOMContentLoaded', function() {
            // Add animation to table rows
            const tableRows = document.querySelectorAll('tbody tr');
            tableRows.forEach((row, index) => {
                row.style.animationDelay = `${index * 0.05}s`;
                row.style.animation = 'fadeIn 0.5s ease-out forwards';
            });

            // Active menu highlight
            const currentPath = window.location.pathname;
            document.querySelectorAll('.sidebar a').forEach(link => {
                if (link.getAttribute('href') && currentPath.includes(link.getAttribute('href'))) {
                    document.querySelectorAll('.sidebar a').forEach(l => l.classList.remove('active'));
                    link.classList.add('active');
                }
            });

            // Auto-hide alerts after 8 seconds
            setTimeout(() => {
                document.querySelectorAll('.alert').forEach(alert => {
                    const fadeOut = () => {
                        alert.style.opacity = '0';
                        alert.style.transform = 'translateY(-10px)';
                        setTimeout(() => alert.remove(), 300);
                    };
                    fadeOut();
                });
            }, 8000);

            // Update unread count badge
            updateUnreadCount();
        });

        // Function to mark report as read
        function markAsRead(reportId) {
            if (confirm('Apakah Anda yakin ingin menandai laporan ini sebagai sudah dibaca?\n\nStatus akan berubah dari "Belum Dibaca" menjadi "Selesai".')) {
                const btn = event.target;
                const originalText = btn.innerHTML;
                btn.innerHTML = '<span class="loading"></span> Memproses...';
                btn.disabled = true;
                
                $.ajax({
                    url: '<?= site_url("admin/mark_report_read"); ?>',
                    method: 'POST',
                    data: {
                        id_report: reportId,
                        <?= $this->security->get_csrf_token_name(); ?>: '<?= $this->security->get_csrf_hash(); ?>'
                    },
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            // Close modal
                            $('#detailModal' + reportId).modal('hide');
                            
                            // Show success message with animation
                            showNotification('success', 'Laporan berhasil ditandai sebagai sudah dibaca.');
                            
                            // Update badge count and reload after 1 second
                            setTimeout(() => {
                                updateUnreadCount();
                                location.reload();
                            }, 1000);
                        } else {
                            showNotification('error', 'Gagal menandai laporan: ' + response.message);
                            btn.innerHTML = originalText;
                            btn.disabled = false;
                        }
                    },
                    error: function(xhr, status, error) {
                        showNotification('error', 'Terjadi kesalahan saat mengirim permintaan. Silakan coba lagi.');
                        console.error('AJAX Error:', error);
                        btn.innerHTML = originalText;
                        btn.disabled = false;
                    }
                });
            }
        }

        // Update unread count badge
        function updateUnreadCount() {
            $.ajax({
                url: '<?= site_url("admin/get_unread_report_count"); ?>',
                method: 'GET',
                dataType: 'json',
                success: function(response) {
                    const badge = document.querySelector('.sidebar .badge');
                    if (badge) {
                        if (response.count > 0) {
                            badge.textContent = response.count;
                            badge.style.display = 'flex';
                            // Add animation to badge
                            badge.style.animation = 'pulse 2s infinite';
                        } else {
                            badge.style.display = 'none';
                        }
                    }
                },
                error: function() {
                    console.error('Failed to fetch unread count');
                }
            });
        }

        // Show notification
        function showNotification(type, message) {
            const alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
            const icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';
            
            const alertDiv = document.createElement('div');
            alertDiv.className = `alert ${alertClass} alert-dismissible fade show`;
            alertDiv.innerHTML = `
                <i class="fas ${icon} me-2"></i> ${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `;
            
            const mainContent = document.querySelector('.main-content');
            mainContent.insertBefore(alertDiv, mainContent.firstChild);
            
            // Auto remove after 5 seconds
            setTimeout(() => {
                if (alertDiv.parentNode) {
                    alertDiv.style.opacity = '0';
                    alertDiv.style.transform = 'translateY(-10px)';
                    setTimeout(() => alertDiv.remove(), 300);
                }
            }, 5000);
        }

        // Auto-refresh page every 5 minutes for updates
        setTimeout(() => {
            showNotification('info', 'Memperbarui data...');
            setTimeout(() => location.reload(), 1000);
        }, 300000); // 5 minutes

        // Add CSS animation for pulse effect
        const style = document.createElement('style');
        style.textContent = `
            @keyframes pulse {
                0% { transform: scale(1); }
                50% { transform: scale(1.1); }
                100% { transform: scale(1); }
            }
        `;
        document.head.appendChild(style);
    </script>
</body>

</html>