<!doctype html>
<html>

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Admin Login - SistemKOS</title>
  <link rel="stylesheet" href="<?= base_url('asset/css/bootstrap.min.css') ?>">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      position: relative;
      overflow: hidden;
    }

    /* Animated background circles */
    body::before,
    body::after {
      content: '';
      position: absolute;
      border-radius: 50%;
      background: rgba(255, 255, 255, 0.1);
      animation: float 20s infinite ease-in-out;
    }

    body::before {
      width: 300px;
      height: 300px;
      top: -100px;
      left: -100px;
      animation-delay: 0s;
    }

    body::after {
      width: 400px;
      height: 400px;
      bottom: -150px;
      right: -150px;
      animation-delay: 3s;
    }

    @keyframes float {

      0%,
      100% {
        transform: translateY(0) rotate(0deg);
      }

      50% {
        transform: translateY(-50px) rotate(180deg);
      }
    }

    .login-container {
      position: relative;
      z-index: 10;
      width: 100%;
      max-width: 450px;
      padding: 20px;
      animation: slideIn 0.5s ease-out;
    }

    @keyframes slideIn {
      from {
        opacity: 0;
        transform: translateY(-30px);
      }

      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .login-card {
      background: white;
      border-radius: 20px;
      box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
      overflow: hidden;
      transition: transform 0.3s ease;
    }

    .login-card:hover {
      transform: translateY(-5px);
    }

    .login-header {
      background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
      padding: 40px 30px;
      text-align: center;
      color: white;
      position: relative;
    }

    .login-header::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: url('data:image/svg+xml,<svg width="100" height="100" xmlns="http://www.w3.org/2000/svg"><circle cx="50" cy="50" r="40" fill="rgba(255,255,255,0.05)"/></svg>');
      opacity: 0.3;
    }

    .login-icon {
      width: 80px;
      height: 80px;
      background: rgba(255, 255, 255, 0.2);
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      margin: 0 auto 20px;
      font-size: 2.5rem;
      backdrop-filter: blur(10px);
      border: 3px solid rgba(255, 255, 255, 0.3);
      animation: pulse 2s infinite;
    }

    @keyframes pulse {

      0%,
      100% {
        transform: scale(1);
        box-shadow: 0 0 0 0 rgba(255, 255, 255, 0.4);
      }

      50% {
        transform: scale(1.05);
        box-shadow: 0 0 0 10px rgba(255, 255, 255, 0);
      }
    }

    .login-header h4 {
      margin: 0;
      font-size: 1.8rem;
      font-weight: 600;
      position: relative;
      z-index: 1;
    }

    .login-header p {
      margin: 10px 0 0;
      opacity: 0.95;
      font-size: 0.95rem;
      position: relative;
      z-index: 1;
    }

    .login-body {
      padding: 40px 30px;
    }

    .alert {
      border-radius: 10px;
      border: none;
      padding: 15px;
      margin-bottom: 25px;
      animation: shake 0.5s ease-in-out;
    }

    @keyframes shake {

      0%,
      100% {
        transform: translateX(0);
      }

      25% {
        transform: translateX(-10px);
      }

      75% {
        transform: translateX(10px);
      }
    }

    .alert-danger {
      background: #fee;
      color: #c33;
      border-left: 4px solid #c33;
    }

    .form-group {
      margin-bottom: 25px;
      position: relative;
    }

    .form-group label {
      font-weight: 600;
      color: #555;
      margin-bottom: 8px;
      font-size: 0.9rem;
      display: block;
    }

    .input-wrapper {
      position: relative;
    }

    .input-icon {
      position: absolute;
      left: 15px;
      top: 50%;
      transform: translateY(-50%);
      color: #4a90e2;
      font-size: 1.1rem;
      z-index: 1;
    }

    .form-control {
      border: 2px solid #e3f2fd;
      border-radius: 10px;
      padding: 12px 15px 12px 45px;
      font-size: 0.95rem;
      transition: all 0.3s ease;
      background: #f8fbff;
    }

    .form-control:focus {
      border-color: #4a90e2;
      box-shadow: 0 0 0 4px rgba(74, 144, 226, 0.1);
      background: white;
      outline: none;
    }

    .password-toggle {
      position: absolute;
      right: 15px;
      top: 50%;
      transform: translateY(-50%);
      cursor: pointer;
      color: #888;
      font-size: 1.1rem;
      transition: color 0.3s;
      z-index: 2;
    }

    .password-toggle:hover {
      color: #4a90e2;
    }

    .btn-login {
      background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
      color: white;
      border: none;
      border-radius: 10px;
      padding: 14px;
      font-size: 1rem;
      font-weight: 600;
      width: 100%;
      cursor: pointer;
      transition: all 0.3s ease;
      position: relative;
      overflow: hidden;
    }

    .btn-login::before {
      content: '';
      position: absolute;
      top: 0;
      left: -100%;
      width: 100%;
      height: 100%;
      background: rgba(255, 255, 255, 0.2);
      transition: left 0.5s ease;
    }

    .btn-login:hover::before {
      left: 100%;
    }

    .btn-login:hover {
      transform: translateY(-2px);
      box-shadow: 0 8px 20px rgba(74, 144, 226, 0.4);
    }

    .btn-login:active {
      transform: translateY(0);
    }

    .btn-login i {
      margin-left: 8px;
      transition: transform 0.3s;
    }

    .btn-login:hover i {
      transform: translateX(5px);
    }

    .login-footer {
      text-align: center;
      padding: 20px 30px;
      background: #f8fbff;
      color: #888;
      font-size: 0.85rem;
    }

    .login-footer a {
      color: #4a90e2;
      text-decoration: none;
      font-weight: 600;
      transition: color 0.3s;
    }

    .login-footer a:hover {
      color: #357abd;
    }

    /* Loading state */
    .btn-login.loading {
      pointer-events: none;
      opacity: 0.7;
    }

    .btn-login.loading::after {
      content: '';
      position: absolute;
      width: 20px;
      height: 20px;
      top: 50%;
      left: 50%;
      margin-left: -10px;
      margin-top: -10px;
      border: 3px solid rgba(255, 255, 255, 0.3);
      border-top-color: white;
      border-radius: 50%;
      animation: spin 0.8s linear infinite;
    }

    @keyframes spin {
      to {
        transform: rotate(360deg);
      }
    }

    .floating-shapes {
      position: absolute;
      width: 100%;
      height: 100%;
      top: 0;
      left: 0;
      pointer-events: none;
      overflow: hidden;
    }

    .shape {
      position: absolute;
      background: rgba(255, 255, 255, 0.05);
      border-radius: 50%;
    }

    .shape:nth-child(1) {
      width: 80px;
      height: 80px;
      top: 20%;
      left: 10%;
      animation: float 15s infinite ease-in-out;
    }

    .shape:nth-child(2) {
      width: 120px;
      height: 120px;
      top: 60%;
      left: 80%;
      animation: float 20s infinite ease-in-out 2s;
    }

    .shape:nth-child(3) {
      width: 60px;
      height: 60px;
      top: 80%;
      left: 20%;
      animation: float 18s infinite ease-in-out 4s;
    }

    @media (max-width: 576px) {
      .login-container {
        padding: 15px;
      }

      .login-header {
        padding: 30px 20px;
      }

      .login-body {
        padding: 30px 20px;
      }

      .login-header h4 {
        font-size: 1.5rem;
      }
    }
  </style>
</head>

<body>
  <div class="floating-shapes">
    <div class="shape"></div>
    <div class="shape"></div>
    <div class="shape"></div>
  </div>

  <div class="login-container">
    <div class="login-card">
      <div class="login-header">
        <div class="login-icon">
          <img src="<?= base_url('asset/logo 2.png'); ?>" alt="Logo KosCare" style="width: 80px; height: auto;">
        </div>
        <h4>KosCare</h4>
        <p>Admin Dashboard Login</p>
      </div>
      <div class="login-body">
        <?php if (!empty($error)): ?>
          <div class="alert alert-danger">
            <i class="fas fa-exclamation-circle"></i>
            <?= htmlspecialchars($error) ?>
          </div>
        <?php endif; ?>
        <!-- Form login -->
        <form method="post" action="<?= site_url('admin/login/proses') ?>" id="loginForm">
          <div class="form-group">
            <label for="email"><i class="fas fa-envelope"></i> Email</label>
            <div class="input-wrapper">
              <i class="fas fa-user input-icon"></i>
              <input
                type="email"
                name="email"
                id="email"
                class="form-control"
                placeholder="Masukkan email Anda"
                required
                autocomplete="email">
            </div>
          </div>

          <div class="form-group">
            <label for="password"><i class="fas fa-lock"></i> Password</label>
            <div class="input-wrapper">
              <i class="fas fa-key input-icon"></i>
              <input
                type="password"
                name="password"
                id="password"
                class="form-control"
                placeholder="Masukkan password Anda"
                required
                autocomplete="current-password">
              <i class="fas fa-eye password-toggle" id="togglePassword"></i>
            </div>
          </div>

          <button class="btn-login" type="submit" id="loginBtn">
            <span>Login</span>
            <i class="fas fa-arrow-right"></i>
          </button>
        </form>

        <!-- Tambahkan di dalam login-footer -->
        <!-- Tambahkan di dalam login-footer (ganti bagian yang sudah ada) -->
        <div class="login-footer">
          <p>Belum punya akun? <a href="<?= site_url('admin/register') ?>">Daftar di sini</a></p>

          <!-- TAMBAHKAN LINK LUPA PASSWORD DI SINI -->
          <p style="margin-top: 15px; text-align: center;">
            <a href="<?= site_url('admin/forgot_password') ?>" style="
            color: #4a90e2;
            text-decoration: none;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 8px 15px;
            border: 1px solid #4a90e2;
            border-radius: 8px;
            transition: all 0.3s;
        ">
              <i class="fas fa-key"></i>
              <span>Lupa Password?</span>
            </a>
          </p>

          <p style="margin-top: 20px; color: #888; font-size: 0.85rem;">
            © 2025 KosCare. All rights reserved.
          </p>
        </div>
      </div>
    </div>

    <script>
      // Toggle password visibility
      const togglePassword = document.getElementById('togglePassword');
      const passwordInput = document.getElementById('password');

      togglePassword.addEventListener('click', function() {
        const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
        passwordInput.setAttribute('type', type);

        // Toggle icon
        this.classList.toggle('fa-eye');
        this.classList.toggle('fa-eye-slash');
      });

      // Form submission with loading state
      const loginForm = document.getElementById('loginForm');
      const loginBtn = document.getElementById('loginBtn');

      loginForm.addEventListener('submit', function(e) {
        // Add loading state
        loginBtn.classList.add('loading');
        loginBtn.querySelector('span').textContent = 'Loading...';
      });

      // Input focus effects
      const inputs = document.querySelectorAll('.form-control');

      inputs.forEach(input => {
        input.addEventListener('focus', function() {
          this.parentElement.querySelector('.input-icon').style.color = '#4a90e2';
        });

        input.addEventListener('blur', function() {
          if (!this.value) {
            this.parentElement.querySelector('.input-icon').style.color = '#aaa';
          }
        });
      });

      // Auto-focus on email input
      document.addEventListener('DOMContentLoaded', function() {
        document.getElementById('email').focus();
      });

      // Enter key on email moves to password
      document.getElementById('email').addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
          e.preventDefault();
          document.getElementById('password').focus();
        }
      });
    </script>
</body>

</html>