<?php
// Determine active menu based on current URL
$current_url = uri_string(); // Get current URI segment
?>
<!doctype html>
<html>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Pengaturan Admin - SistemKOS</title>
    <link rel="stylesheet" href="<?php echo base_url('asset/css/bootstrap.min.css'); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f0f8ff;
            color: #333;
        }

        /* TOPBAR IMPROVED - SAME AS ADMIN */
        .topbar {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            padding: 12px 0;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1030;
            height: 60px;
        }

        .topbar-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            height: 100%;
            padding: 0 15px;
        }

        .brand-section {
            display: flex;
            align-items: center;
            gap: 15px;
            flex-shrink: 0;
        }

        .brand-logo {
            width: 50px;
            height: auto;
            transition: transform 0.3s;
        }

        .brand-logo:hover {
            transform: scale(1.05);
        }

        .brand-text {
            color: white;
        }

        .brand-text h4 {
            font-weight: 600;
            font-size: 1.3rem;
            margin: 0;
            line-height: 1.2;
        }

        .brand-text span {
            font-size: 0.9rem;
            opacity: 0.9;
            display: block;
            margin-top: 2px;
        }

        .user-section {
            display: flex;
            align-items: center;
            gap: 15px;
            flex-shrink: 0;
        }

        .user-info {
            display: flex;
            align-items: center;
            gap: 8px;
            color: white;
            font-size: 0.95rem;
            padding: 6px 12px;
            border-radius: 6px;
            transition: background 0.3s;
        }

        .user-info:hover {
            background: rgba(255, 255, 255, 0.1);
        }

        .user-info i {
            font-size: 1.2rem;
        }

        .logout-btn {
            display: flex;
            align-items: center;
            gap: 8px;
            color: white;
            text-decoration: none;
            padding: 8px 16px;
            border-radius: 6px;
            background: rgba(255, 255, 255, 0.15);
            transition: all 0.3s;
            font-size: 0.9rem;
            font-weight: 500;
        }

        .logout-btn:hover {
            background: rgba(255, 255, 255, 0.25);
            transform: translateY(-1px);
            color: white;
        }

        /* SIDEBAR STYLES */
        .sidebar {
            background: white;
            min-height: calc(100vh - 60px);
            padding: 25px 15px;
            box-shadow: 2px 0 10px rgba(0, 0, 0, 0.05);
            position: fixed;
            top: 60px;
            left: 0;
            width: 16.666667%;
            height: calc(100vh - 60px);
            overflow-y: auto;
            z-index: 1020;
        }

        .sidebar h5 {
            color: #4a90e2;
            margin-bottom: 20px;
            font-weight: 600;
            padding-bottom: 10px;
            border-bottom: 2px solid #e3f2fd;
        }

        .sidebar ul {
            list-style: none;
        }

        .sidebar ul li {
            margin-bottom: 8px;
        }

        .sidebar ul li a {
            display: block;
            padding: 12px 15px;
            color: #555;
            text-decoration: none;
            border-radius: 8px;
            transition: all 0.3s;
            font-size: 0.95rem;
            position: relative;
            overflow: hidden;
        }

        .sidebar ul li a:hover {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
            transform: translateX(5px);
        }

        .sidebar ul li a.active {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
            transform: translateX(5px);
            box-shadow: 0 4px 15px rgba(74, 144, 226, 0.3);
        }

        .sidebar ul li a.active:before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            height: 100%;
            width: 4px;
            background: white;
            border-radius: 0 4px 4px 0;
        }

        .sidebar ul li a i {
            width: 20px;
            margin-right: 10px;
        }

        /* MAIN CONTENT */
        .main-content {
            margin-left: 16.666667%;
            margin-top: 60px;
            padding: 25px;
            background: #f0f8ff;
            min-height: calc(100vh - 60px);
        }

        .settings-card {
            background: white;
            border-radius: 12px;
            padding: 30px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
            margin-bottom: 20px;
        }

        .settings-card h5 {
            color: #4a90e2;
            margin-bottom: 20px;
            font-weight: 600;
            font-size: 1.2rem;
            padding-bottom: 15px;
            border-bottom: 2px solid #e3f2fd;
        }

        .form-label {
            font-weight: 500;
            color: #555;
            margin-bottom: 8px;
            font-size: 0.95rem;
        }

        .form-control {
            border: 2px solid #e9ecef;
            border-radius: 8px;
            padding: 12px 15px;
            font-size: 0.95rem;
            transition: all 0.3s;
        }

        .form-control:focus {
            border-color: #4a90e2;
            box-shadow: 0 0 0 0.2rem rgba(74, 144, 226, 0.25);
        }

        .btn-primary-custom {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            border: none;
            color: white;
            padding: 12px 30px;
            border-radius: 8px;
            text-decoration: none;
            transition: all 0.3s;
            font-size: 0.95rem;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .btn-primary-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(74, 144, 226, 0.4);
            color: white;
        }

        .btn-secondary-custom {
            background: #6c757d;
            border: none;
            color: white;
            padding: 12px 30px;
            border-radius: 8px;
            text-decoration: none;
            transition: all 0.3s;
            font-size: 0.95rem;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .btn-secondary-custom:hover {
            background: #5a6268;
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(108, 117, 125, 0.4);
            color: white;
        }

        /* ALERT STYLES */
        .alert {
            border-radius: 8px;
            border: none;
            padding: 15px 20px;
            margin-bottom: 25px;
            animation: slideDown 0.3s ease-out;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .alert-success {
            background: #d4edda;
            color: #155724;
            border-left: 4px solid #28a745;
        }

        .alert-danger {
            background: #f8d7da;
            color: #721c24;
            border-left: 4px solid #dc3545;
        }

        .password-section {
            background: #f8fbff;
            padding: 20px;
            border-radius: 8px;
            border: 2px dashed #e3f2fd;
            margin-top: 20px;
        }

        .password-section h6 {
            color: #4a90e2;
            font-weight: 600;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .info-text {
            color: #888;
            font-size: 0.85rem;
            margin-top: 5px;
        }

        .profile-icon {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            font-size: 2.5rem;
            color: white;
        }

        .section-divider {
            height: 2px;
            background: linear-gradient(90deg, transparent, #e3f2fd, transparent);
            margin: 30px 0;
        }

        /* RESPONSIVE DESIGN */
        @media (max-width: 992px) {
            .sidebar {
                width: 25%;
            }

            .main-content {
                margin-left: 25%;
            }
        }

        @media (max-width: 768px) {
            .sidebar {
                position: relative;
                width: 100%;
                height: auto;
                min-height: auto;
                top: 0;
            }

            .main-content {
                margin-left: 0;
                margin-top: 0;
                padding: 15px;
            }

            .topbar {
                height: auto;
                padding: 10px 0;
            }

            .topbar-container {
                flex-direction: column;
                gap: 10px;
                height: auto;
            }

            .brand-section,
            .user-section {
                width: 100%;
                justify-content: center;
            }

            .settings-card {
                padding: 20px;
            }

            .brand-text h4 {
                font-size: 1.1rem;
            }

            .brand-text span {
                font-size: 0.8rem;
            }

            .user-info,
            .logout-btn {
                font-size: 0.85rem;
            }
        }

        @media (max-width: 576px) {
            .btn-primary-custom,
            .btn-secondary-custom {
                padding: 10px 20px;
                font-size: 0.9rem;
                width: 100%;
                justify-content: center;
            }

            .profile-icon {
                width: 60px;
                height: 60px;
                font-size: 1.8rem;
            }
        }

        .sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar::-webkit-scrollbar-track {
            background: #f1f1f1;
        }

        .sidebar::-webkit-scrollbar-thumb {
            background: #4a90e2;
            border-radius: 3px;
        }

        .sidebar::-webkit-scrollbar-thumb:hover {
            background: #357abd;
        }
    </style>
</head>

<body>
    <!-- TOPBAR IMPROVED -->
    <div class="topbar">
        <div class="container-fluid">
            <div class="topbar-container">
                <!-- Brand Section (Left) -->
                <div class="brand-section">
                    <img src="<?= base_url('asset/logo 2.png'); ?>" alt="Logo KosCare" class="brand-logo">
                    <div class="brand-text">
                        <h4>KosCare</h4>
                        <span>Dashboard Admin</span>
                    </div>
                </div>

                <!-- User Section (Right) -->
                <div class="user-section">
                    <div class="user-info">
                        <i class="fas fa-user-circle"></i>
                        <div>
                            <span>Halo, <strong><?php echo $this->session->userdata('admin_name'); ?></strong></span>
                        </div>
                    </div>
                    <a href="<?php echo site_url('admin/login/logout'); ?>" class="logout-btn">
                        <i class="fas fa-sign-out-alt"></i> Logout
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- SIDEBAR -->
    <div class="sidebar" id="sidebar">
        <h5><i class="fas fa-bars"></i> Menu</h5>
        <ul>
            <li><a href="<?= site_url('admin/dashboard'); ?>" class="<?= strpos($current_url, 'dashboard') !== false ? 'active' : '' ?>"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
            <li><a href="<?= site_url('admin/laporan'); ?>" class="<?= strpos($current_url, 'laporan') !== false ? 'active' : '' ?>"><i class="fas fa-clipboard-list"></i> Laporan</a></li>
            <li><a href="<?= site_url('admin/penghuni'); ?>" class="<?= strpos($current_url, 'penghuni') !== false ? 'active' : '' ?>"><i class="fas fa-users"></i> Penghuni</a></li>
            <li><a href="<?= site_url('admin/iklan'); ?>" class="<?= strpos($current_url, 'iklan') !== false ? 'active' : '' ?>"><i class="fas fa-bullhorn"></i> Iklan</a></li>
            <li><a href="<?= site_url('admin/kos'); ?>" class="<?= (strpos($current_url, 'kos') !== false && strpos($current_url, 'penghuni') === false) ? 'active' : '' ?>"><i class="fas fa-building"></i> Kos</a></li>
            <li><a href="<?= site_url('admin/pengaturan'); ?>" class="<?= strpos($current_url, 'pengaturan') !== false ? 'active' : '' ?>"><i class="fas fa-cog"></i> Pengaturan</a></li>
        </ul>
    </div>

    <div class="main-content">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <?php if ($this->session->flashdata('success')): ?>
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle"></i>
                        <?php echo $this->session->flashdata('success'); ?>
                    </div>
                <?php elseif ($this->session->flashdata('error')): ?>
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-circle"></i>
                        <?php echo $this->session->flashdata('error'); ?>
                    </div>
                <?php endif; ?>

                <div class="settings-card">
                    <div class="profile-icon">
                        <i class="fas fa-user-cog"></i>
                    </div>

                    <h5><i class="fas fa-user-edit"></i> Pengaturan Profil Admin</h5>

                    <form method="post" action="<?php echo site_url('admin/pengaturan/update'); ?>">
                        <div class="mb-4">
                            <label class="form-label">
                                <i class="fas fa-user"></i> Nama Lengkap
                            </label>
                            <input type="text" name="nama" class="form-control"
                                value="<?php echo isset($admin->nama) ? $admin->nama : $this->session->userdata('admin_name'); ?>"
                                placeholder="Masukkan nama lengkap Anda">
                            <div class="info-text">Nama akan ditampilkan di dashboard</div>
                        </div>

                        <div class="mb-4">
                            <label class="form-label">
                                <i class="fas fa-envelope"></i> Email <span style="color: #dc3545;">*</span>
                            </label>
                            <input type="email" name="email" class="form-control"
                                value="<?php echo isset($admin->email) ? $admin->email : $this->session->userdata('admin_email'); ?>" required
                                placeholder="admin@sistemkos.com">
                            <div class="info-text">Email digunakan untuk login dan notifikasi penting</div>
                        </div>

                        <div class="section-divider"></div>

                        <div class="password-section">
                            <h6><i class="fas fa-lock"></i> Ubah Password</h6>
                            <div class="info-text mb-3">Kosongkan kedua field di bawah jika tidak ingin mengganti password</div>

                            <div class="mb-3">
                                <label class="form-label">
                                    <i class="fas fa-key"></i> Password Lama
                                </label>
                                <input type="password" name="password_lama" class="form-control"
                                    placeholder="Password lama Anda">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">
                                    <i class="fas fa-lock"></i> Password Baru
                                </label>
                                <input type="password" name="password_baru" class="form-control"
                                    placeholder="Password baru">
                                <div class="info-text">Password minimal 6 karakter untuk keamanan</div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">
                                    <i class="fas fa-lock"></i> Konfirmasi Password Baru
                                </label>
                                <input type="password" name="konfirmasi_password" class="form-control"
                                    placeholder="Ulangi password baru">
                            </div>
                        </div>

                        <div class="d-flex gap-2 mt-4">
                            <button type="submit" class="btn-primary-custom">
                                <i class="fas fa-save"></i> Simpan Perubahan
                            </button>
                            <a href="<?php echo site_url('admin/dashboard'); ?>" class="btn-secondary-custom">
                                <i class="fas fa-arrow-left"></i> Kembali
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="<?php echo base_url('asset/js/jquery-3.6.0.min.js'); ?>"></script>
    <script src="<?php echo base_url('asset/js/bootstrap.bundle.min.js'); ?>"></script>

    <script>
        // Add hover effects to logout button
        document.addEventListener('DOMContentLoaded', function() {
            const logoutBtn = document.querySelector('.logout-btn');
            if (logoutBtn) {
                logoutBtn.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-1px) scale(1.02)';
                });
                logoutBtn.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0) scale(1)';
                });
            }
        });

        // Form validation
        document.querySelector('form').addEventListener('submit', function(e) {
            const passwordLama = document.querySelector('input[name="password_lama"]').value;
            const passwordBaru = document.querySelector('input[name="password_baru"]').value;
            const konfirmasiPassword = document.querySelector('input[name="konfirmasi_password"]').value;

            // Jika salah satu password field diisi, pastikan semua diisi
            if (passwordLama || passwordBaru || konfirmasiPassword) {
                if (!passwordLama || !passwordBaru || !konfirmasiPassword) {
                    e.preventDefault();
                    alert('Jika ingin mengganti password, harap isi semua field password (lama, baru, dan konfirmasi)');
                    return false;
                }
                
                // Validasi panjang password baru
                if (passwordBaru.length < 6) {
                    e.preventDefault();
                    alert('Password baru minimal 6 karakter');
                    return false;
                }
                
                // Validasi konfirmasi password
                if (passwordBaru !== konfirmasiPassword) {
                    e.preventDefault();
                    alert('Password baru dan konfirmasi password tidak cocok');
                    return false;
                }
            }
        });
        
        // Auto hide alerts after 5 seconds
        document.addEventListener('DOMContentLoaded', function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(alert => {
                setTimeout(() => {
                    alert.style.animation = 'slideUp 0.3s ease-out';
                    setTimeout(() => {
                        alert.style.display = 'none';
                    }, 300);
                }, 5000);
            });
        });
    </script>
</body>

</html>