<!doctype html>
<html>

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Admin Register - SistemKOS</title>
  <link rel="stylesheet" href="<?= base_url('asset/css/bootstrap.min.css') ?>">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      position: relative;
      overflow: hidden;
      padding: 20px 0;
    }

    /* Animated background circles */
    body::before,
    body::after {
      content: '';
      position: absolute;
      border-radius: 50%;
      background: rgba(255, 255, 255, 0.1);
      animation: float 20s infinite ease-in-out;
    }

    body::before {
      width: 300px;
      height: 300px;
      top: -100px;
      left: -100px;
      animation-delay: 0s;
    }

    body::after {
      width: 400px;
      height: 400px;
      bottom: -150px;
      right: -150px;
      animation-delay: 3s;
    }

    @keyframes float {
      0%,
      100% {
        transform: translateY(0) rotate(0deg);
      }

      50% {
        transform: translateY(-50px) rotate(180deg);
      }
    }

    .login-container {
      position: relative;
      z-index: 10;
      width: 100%;
      max-width: 500px;
      padding: 20px;
      animation: slideIn 0.5s ease-out;
    }

    @keyframes slideIn {
      from {
        opacity: 0;
        transform: translateY(-30px);
      }

      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .login-card {
      background: white;
      border-radius: 20px;
      box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
      overflow: hidden;
      transition: transform 0.3s ease;
    }

    .login-card:hover {
      transform: translateY(-5px);
    }

    .login-header {
      background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
      padding: 40px 30px;
      text-align: center;
      color: white;
      position: relative;
    }

    .login-header::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: url('data:image/svg+xml,<svg width="100" height="100" xmlns="http://www.w3.org/2000/svg"><circle cx="50" cy="50" r="40" fill="rgba(255,255,255,0.05)"/></svg>');
      opacity: 0.3;
    }

    .login-icon {
      width: 80px;
      height: 80px;
      background: rgba(255, 255, 255, 0.2);
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      margin: 0 auto 20px;
      font-size: 2.5rem;
      backdrop-filter: blur(10px);
      border: 3px solid rgba(255, 255, 255, 0.3);
      animation: pulse 2s infinite;
    }

    @keyframes pulse {
      0%,
      100% {
        transform: scale(1);
        box-shadow: 0 0 0 0 rgba(255, 255, 255, 0.4);
      }

      50% {
        transform: scale(1.05);
        box-shadow: 0 0 0 10px rgba(255, 255, 255, 0);
      }
    }

    .login-header h4 {
      margin: 0;
      font-size: 1.8rem;
      font-weight: 600;
      position: relative;
      z-index: 1;
    }

    .login-header p {
      margin: 10px 0 0;
      opacity: 0.95;
      font-size: 0.95rem;
      position: relative;
      z-index: 1;
    }

    .login-body {
      padding: 40px 30px 30px;
    }

    .alert {
      border-radius: 10px;
      border: none;
      padding: 15px;
      margin-bottom: 25px;
      animation: shake 0.5s ease-in-out;
    }

    @keyframes shake {
      0%,
      100% {
        transform: translateX(0);
      }

      25% {
        transform: translateX(-10px);
      }

      75% {
        transform: translateX(10px);
      }
    }

    .alert-danger {
      background: #fee;
      color: #c33;
      border-left: 4px solid #c33;
    }

    .form-group {
      margin-bottom: 20px;
      position: relative;
    }

    .form-group label {
      font-weight: 600;
      color: #555;
      margin-bottom: 8px;
      font-size: 0.9rem;
      display: block;
    }

    .input-wrapper {
      position: relative;
    }

    .input-icon {
      position: absolute;
      left: 15px;
      top: 50%;
      transform: translateY(-50%);
      color: #4a90e2;
      font-size: 1.1rem;
      z-index: 1;
    }

    .form-control {
      border: 2px solid #e3f2fd;
      border-radius: 10px;
      padding: 12px 15px 12px 45px;
      font-size: 0.95rem;
      transition: all 0.3s ease;
      background: #f8fbff;
      width: 100%;
    }

    .form-control:focus {
      border-color: #4a90e2;
      box-shadow: 0 0 0 4px rgba(74, 144, 226, 0.1);
      background: white;
      outline: none;
    }

    .password-toggle {
      position: absolute;
      right: 15px;
      top: 50%;
      transform: translateY(-50%);
      cursor: pointer;
      color: #888;
      font-size: 1.1rem;
      transition: color 0.3s;
      z-index: 2;
    }

    .password-toggle:hover {
      color: #4a90e2;
    }

    .btn-login {
      background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
      color: white;
      border: none;
      border-radius: 10px;
      padding: 14px;
      font-size: 1rem;
      font-weight: 600;
      width: 100%;
      cursor: pointer;
      transition: all 0.3s ease;
      position: relative;
      overflow: hidden;
      margin-top: 10px;
    }

    .btn-login::before {
      content: '';
      position: absolute;
      top: 0;
      left: -100%;
      width: 100%;
      height: 100%;
      background: rgba(255, 255, 255, 0.2);
      transition: left 0.5s ease;
    }

    .btn-login:hover::before {
      left: 100%;
    }

    .btn-login:hover {
      transform: translateY(-2px);
      box-shadow: 0 8px 20px rgba(74, 144, 226, 0.4);
    }

    .btn-login:active {
      transform: translateY(0);
    }

    .btn-login i {
      margin-left: 8px;
      transition: transform 0.3s;
    }

    .btn-login:hover i {
      transform: translateX(5px);
    }

    .login-footer {
      text-align: center;
      padding: 20px 30px;
      background: #f8fbff;
      color: #888;
      font-size: 0.85rem;
    }

    .login-footer a {
      color: #4a90e2;
      text-decoration: none;
      font-weight: 600;
      transition: color 0.3s;
    }

    .login-footer a:hover {
      color: #357abd;
    }

    .btn-login.loading {
      pointer-events: none;
      opacity: 0.7;
    }

    .btn-login.loading::after {
      content: '';
      position: absolute;
      width: 20px;
      height: 20px;
      top: 50%;
      left: 50%;
      margin-left: -10px;
      margin-top: -10px;
      border: 3px solid rgba(255, 255, 255, 0.3);
      border-top-color: white;
      border-radius: 50%;
      animation: spin 0.8s linear infinite;
    }

    @keyframes spin {
      to {
        transform: rotate(360deg);
      }
    }

    .floating-shapes {
      position: absolute;
      width: 100%;
      height: 100%;
      top: 0;
      left: 0;
      pointer-events: none;
      overflow: hidden;
    }

    .shape {
      position: absolute;
      background: rgba(255, 255, 255, 0.05);
      border-radius: 50%;
    }

    .shape:nth-child(1) {
      width: 80px;
      height: 80px;
      top: 20%;
      left: 10%;
      animation: float 15s infinite ease-in-out;
    }

    .shape:nth-child(2) {
      width: 120px;
      height: 120px;
      top: 60%;
      left: 80%;
      animation: float 20s infinite ease-in-out 2s;
    }

    .shape:nth-child(3) {
      width: 60px;
      height: 60px;
      top: 80%;
      left: 20%;
      animation: float 18s infinite ease-in-out 4s;
    }

    .password-strength {
      margin-top: 8px;
      font-size: 0.85rem;
    }

    .strength-bar {
      height: 4px;
      background: #e9ecef;
      border-radius: 2px;
      overflow: hidden;
      margin-top: 5px;
    }

    .strength-fill {
      height: 100%;
      width: 0%;
      transition: all 0.3s ease;
    }

    .strength-weak {
      background: #dc3545;
      width: 33%;
    }

    .strength-medium {
      background: #ffc107;
      width: 66%;
    }

    .strength-strong {
      background: #28a745;
      width: 100%;
    }

    .password-match {
      font-size: 0.85rem;
      margin-top: 5px;
    }

    .match-success {
      color: #28a745;
    }

    .match-error {
      color: #dc3545;
    }

    @media (max-width: 576px) {
      .login-container {
        padding: 15px;
      }

      .login-header {
        padding: 30px 20px;
      }

      .login-body {
        padding: 30px 20px 20px;
      }

      .login-header h4 {
        font-size: 1.5rem;
      }
    }
  </style>
</head>

<body>
  <div class="floating-shapes">
    <div class="shape"></div>
    <div class="shape"></div>
    <div class="shape"></div>
  </div>

  <div class="login-container">
    <div class="login-card">
      <div class="login-header">
        <div class="login-icon">
          <img src="<?= base_url('asset/logo 2.png'); ?>" alt="Logo KosCare" style="width: 80px; height: auto;">
        </div>
        <h4>KosCare</h4>
        <p>Daftar Admin Dashboard</p>
      </div>

      <div class="login-body">
        <?php if ($this->session->flashdata('error')): ?>
          <div class="alert alert-danger">
            <i class="fas fa-exclamation-circle"></i>
            <?= htmlspecialchars($this->session->flashdata('error')) ?>
          </div>
        <?php endif; ?>

        <?php if (validation_errors()): ?>
          <div class="alert alert-danger">
            <i class="fas fa-exclamation-circle"></i>
            <?= validation_errors() ?>
          </div>
        <?php endif; ?>

        <form method="post" action="<?= site_url('admin/register/process') ?>" id="registerForm">
          <div class="form-group">
            <label for="nama"><i class="fas fa-user"></i> Nama Lengkap</label>
            <div class="input-wrapper">
              <i class="fas fa-user input-icon"></i>
              <input
                type="text"
                name="nama"
                id="nama"
                class="form-control"
                placeholder="Masukkan nama lengkap Anda"
                value="<?= set_value('nama'); ?>"
                required
                autocomplete="name">
            </div>
          </div>

          <div class="form-group">
            <label for="email"><i class="fas fa-envelope"></i> Email</label>
            <div class="input-wrapper">
              <i class="fas fa-envelope input-icon"></i>
              <input
                type="email"
                name="email"
                id="email"
                class="form-control"
                placeholder="Masukkan email Anda"
                value="<?= set_value('email'); ?>"
                required
                autocomplete="email">
            </div>
          </div>

          <div class="form-group">
            <label for="password"><i class="fas fa-lock"></i> Password</label>
            <div class="input-wrapper">
              <i class="fas fa-key input-icon"></i>
              <input
                type="password"
                name="password"
                id="password"
                class="form-control"
                placeholder="Minimal 6 karakter"
                required
                autocomplete="new-password">
              <i class="fas fa-eye password-toggle" id="togglePassword"></i>
            </div>
            <div class="password-strength" id="passwordStrength">
              <div class="strength-bar">
                <div class="strength-fill" id="strengthFill"></div>
              </div>
              <small id="strengthText"></small>
            </div>
          </div>

          <div class="form-group">
            <label for="confirm_password"><i class="fas fa-lock"></i> Konfirmasi Password</label>
            <div class="input-wrapper">
              <i class="fas fa-key input-icon"></i>
              <input
                type="password"
                name="confirm_password"
                id="confirm_password"
                class="form-control"
                placeholder="Ulangi password Anda"
                required
                autocomplete="new-password">
              <i class="fas fa-eye password-toggle" id="toggleConfirmPassword"></i>
            </div>
            <div class="password-match" id="passwordMatch"></div>
          </div>

          <button class="btn-login" type="submit" id="registerBtn">
            <span>Daftar Sekarang</span>
            <i class="fas fa-user-plus"></i>
          </button>
        </form>
      </div>

      <div class="login-footer">
        <p>Sudah punya akun? <a href="<?= site_url('admin/login'); ?>">Login di sini</a></p>
        <p style="margin-top: 10px;">© 2025 KosCare. All rights reserved.</p>
      </div>
    </div>
  </div>

  <script>
    // Toggle password visibility
    const togglePassword = document.getElementById('togglePassword');
    const passwordInput = document.getElementById('password');

    togglePassword.addEventListener('click', function() {
      const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
      passwordInput.setAttribute('type', type);
      this.classList.toggle('fa-eye');
      this.classList.toggle('fa-eye-slash');
    });

    const toggleConfirmPassword = document.getElementById('toggleConfirmPassword');
    const confirmPasswordInput = document.getElementById('confirm_password');

    toggleConfirmPassword.addEventListener('click', function() {
      const type = confirmPasswordInput.getAttribute('type') === 'password' ? 'text' : 'password';
      confirmPasswordInput.setAttribute('type', type);
      this.classList.toggle('fa-eye');
      this.classList.toggle('fa-eye-slash');
    });

    // Password strength checker
    const strengthFill = document.getElementById('strengthFill');
    const strengthText = document.getElementById('strengthText');

    passwordInput.addEventListener('input', function() {
      const password = this.value;
      let strength = 0;

      if (password.length >= 6) strength++;
      if (password.length >= 10) strength++;
      if (/[a-z]/.test(password) && /[A-Z]/.test(password)) strength++;
      if (/[0-9]/.test(password)) strength++;
      if (/[^a-zA-Z0-9]/.test(password)) strength++;

      strengthFill.className = 'strength-fill';
      
      if (strength <= 2) {
        strengthFill.classList.add('strength-weak');
        strengthText.textContent = 'Lemah';
        strengthText.style.color = '#dc3545';
      } else if (strength <= 3) {
        strengthFill.classList.add('strength-medium');
        strengthText.textContent = 'Sedang';
        strengthText.style.color = '#ffc107';
      } else {
        strengthFill.classList.add('strength-strong');
        strengthText.textContent = 'Kuat';
        strengthText.style.color = '#28a745';
      }

      if (password.length === 0) {
        strengthFill.style.width = '0%';
        strengthText.textContent = '';
      }

      checkPasswordMatch();
    });

    // Password match checker
    const passwordMatch = document.getElementById('passwordMatch');

    function checkPasswordMatch() {
      const password = passwordInput.value;
      const confirmPassword = confirmPasswordInput.value;

      if (confirmPassword.length === 0) {
        passwordMatch.textContent = '';
        return;
      }

      if (password === confirmPassword) {
        passwordMatch.innerHTML = '<i class="fas fa-check-circle"></i> Password cocok';
        passwordMatch.className = 'password-match match-success';
      } else {
        passwordMatch.innerHTML = '<i class="fas fa-times-circle"></i> Password tidak cocok';
        passwordMatch.className = 'password-match match-error';
      }
    }

    confirmPasswordInput.addEventListener('input', checkPasswordMatch);

    // Form submission with loading state
    const registerForm = document.getElementById('registerForm');
    const registerBtn = document.getElementById('registerBtn');

    registerForm.addEventListener('submit', function(e) {
      const password = passwordInput.value;
      const confirmPassword = confirmPasswordInput.value;

      if (password !== confirmPassword) {
        e.preventDefault();
        alert('Password dan konfirmasi password tidak cocok!');
        return;
      }

      if (password.length < 6) {
        e.preventDefault();
        alert('Password minimal 6 karakter!');
        return;
      }

      registerBtn.classList.add('loading');
      registerBtn.querySelector('span').textContent = 'Mendaftar...';
    });

    // Input focus effects
    const inputs = document.querySelectorAll('.form-control');

    inputs.forEach(input => {
      input.addEventListener('focus', function() {
        this.parentElement.querySelector('.input-icon').style.color = '#4a90e2';
      });

      input.addEventListener('blur', function() {
        if (!this.value) {
          this.parentElement.querySelector('.input-icon').style.color = '#aaa';
        }
      });
    });

    // Auto-focus on nama input
    document.addEventListener('DOMContentLoaded', function() {
      document.getElementById('nama').focus();
    });
  </script>
</body>

</html>