<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Password Baru - KosCare Admin</title>
    <link rel="stylesheet" href="<?= base_url('asset/css/bootstrap.min.css') ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            width: 100%;
            max-width: 450px;
            padding: 40px 30px;
        }
        .password-strength {
            height: 5px;
            margin-top: 5px;
            border-radius: 3px;
            transition: all 0.3s;
        }
        .email-info {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
            border-left: 4px solid #28a745;
        }
        .btn-reset {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: white;
            border: none;
            padding: 14px;
            font-size: 16px;
            font-weight: 600;
            border-radius: 10px;
            transition: all 0.3s;
        }
        .btn-reset:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(40, 167, 69, 0.4);
        }
        .btn-reset:disabled {
            opacity: 0.7;
            cursor: not-allowed;
        }
        .strength-indicator {
            font-size: 12px;
            margin-top: 5px;
        }
        .strength-weak { color: #dc3545; }
        .strength-medium { color: #ffc107; }
        .strength-strong { color: #28a745; }
    </style>
</head>
<body>
    <div class="card">
        <h3 class="text-center mb-4">
            <i class="fas fa-lock text-success mr-2"></i>
            Buat Password Baru
        </h3>
        
        <div class="email-info">
            <p class="mb-0">
                <i class="fas fa-user-check mr-2"></i>
                <strong>Akun:</strong> <?= htmlspecialchars($email) ?>
            </p>
        </div>
        
        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle mr-2"></i>
                <?= $this->session->flashdata('error') ?>
            </div>
        <?php endif; ?>
        
        <form method="post" action="<?= site_url('admin/forgot_password/process_reset') ?>" id="resetForm">
            <div class="form-group mb-4">
                <label for="password" class="font-weight-bold">
                    <i class="fas fa-lock mr-2"></i>Password Baru
                </label>
                <div class="input-group">
                    <input type="password" 
                           class="form-control" 
                           id="password" 
                           name="password" 
                           placeholder="Minimal 6 karakter" 
                           required
                           minlength="6">
                    <div class="input-group-append">
                        <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                            <i class="fas fa-eye"></i>
                        </button>
                    </div>
                </div>
                <div class="password-strength" id="passwordStrength"></div>
                <div class="strength-indicator" id="strengthText"></div>
                <small class="form-text text-muted">
                    Password harus minimal 6 karakter dengan kombinasi huruf dan angka
                </small>
            </div>
            
            <div class="form-group mb-4">
                <label for="confirm_password" class="font-weight-bold">
                    <i class="fas fa-lock mr-2"></i>Konfirmasi Password
                </label>
                <input type="password" 
                       class="form-control" 
                       id="confirm_password" 
                       name="confirm_password" 
                       placeholder="Ulangi password baru" 
                       required>
                <div class="invalid-feedback" id="passwordError" style="display: none;">
                    Password tidak cocok.
                </div>
            </div>
            
            <button type="submit" class="btn-reset btn-block" id="submitBtn">
                <i class="fas fa-save mr-2"></i> Simpan Password Baru
            </button>
        </form>
        
        <div class="text-center mt-3">
            <a href="<?= site_url('admin/login') ?>">
                <i class="fas fa-arrow-left mr-1"></i> Kembali ke Login
            </a>
        </div>
    </div>
    
    <script>
        // Toggle password visibility
        document.getElementById('togglePassword').addEventListener('click', function() {
            const passwordInput = document.getElementById('password');
            const icon = this.querySelector('i');
            
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                passwordInput.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        });
        
        // Check password strength
        document.getElementById('password').addEventListener('input', function() {
            const password = this.value;
            const strengthBar = document.getElementById('passwordStrength');
            const strengthText = document.getElementById('strengthText');
            let strength = 0;
            let text = '';
            let color = '';
            
            // Length check
            if (password.length >= 6) strength += 25;
            if (password.length >= 8) strength += 10;
            
            // Complexity checks
            if (/[A-Z]/.test(password)) strength += 25;
            if (/[0-9]/.test(password)) strength += 25;
            if (/[^A-Za-z0-9]/.test(password)) strength += 25;
            
            // Cap at 100
            strength = Math.min(strength, 100);
            
            // Set width and color
            strengthBar.style.width = strength + '%';
            
            if (strength < 50) {
                strengthBar.style.backgroundColor = '#dc3545';
                text = 'Lemah';
                color = 'strength-weak';
            } else if (strength < 75) {
                strengthBar.style.backgroundColor = '#ffc107';
                text = 'Cukup';
                color = 'strength-medium';
            } else {
                strengthBar.style.backgroundColor = '#28a745';
                text = 'Kuat';
                color = 'strength-strong';
            }
            
            // Update text
            strengthText.innerHTML = `<span class="${color}">Kekuatan: ${text}</span>`;
        });
        
        // Check password confirmation
        document.getElementById('confirm_password').addEventListener('input', function() {
            const password = document.getElementById('password').value;
            const confirmPassword = this.value;
            const errorDiv = document.getElementById('passwordError');
            
            if (confirmPassword && password !== confirmPassword) {
                this.classList.add('is-invalid');
                errorDiv.style.display = 'block';
            } else {
                this.classList.remove('is-invalid');
                errorDiv.style.display = 'none';
            }
        });
        
        // Form validation and loading
        document.getElementById('resetForm').addEventListener('submit', function(e) {
            const password = document.getElementById('password').value;
            const confirmPassword = document.getElementById('confirm_password').value;
            
            if (password !== confirmPassword) {
                e.preventDefault();
                alert('Password tidak cocok!');
                return false;
            }
            
            if (password.length < 6) {
                e.preventDefault();
                alert('Password minimal 6 karakter!');
                return false;
            }
            
            // Show loading
            const btn = document.getElementById('submitBtn');
            const originalHTML = btn.innerHTML;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Menyimpan...';
            btn.disabled = true;
            
            // Re-enable after 5 seconds
            setTimeout(() => {
                btn.innerHTML = originalHTML;
                btn.disabled = false;
            }, 5000);
            
            return true;
        });
    </script>
</body>
</html>