<!doctype html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title><?php echo isset($title) ? $title : 'Subscription Management'; ?> - KosCare</title>

    <!-- CSS -->
    <link rel="stylesheet" href="<?php echo base_url('asset/css/bootstrap.min.css'); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f0f8ff;
            color: #333;
        }

        /* TOPBAR STYLES */
        .topbar {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            padding: 12px 0;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1030;
            height: 60px;
        }

        .topbar-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            height: 100%;
        }

        .brand-section {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .brand-logo {
            width: 50px;
            height: auto;
            transition: transform 0.3s;
        }

        .brand-logo:hover {
            transform: scale(1.05);
        }

        .brand-title {
            color: white;
            font-weight: 600;
            font-size: 1.3rem;
            margin: 0;
        }

        .brand-subtitle {
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.9rem;
            margin-left: 5px;
            font-weight: 400;
        }

        .user-section {
            display: flex;
            align-items: center;
            gap: 20px;
        }

        .user-info {
            display: flex;
            align-items: center;
            gap: 10px;
            color: white;
            font-size: 0.95rem;
            padding: 5px 12px;
            border-radius: 6px;
            transition: background 0.3s;
        }

        .user-info:hover {
            background: rgba(255, 255, 255, 0.1);
        }

        .user-avatar {
            font-size: 1.3rem;
            color: white;
        }

        .logout-btn {
            display: flex;
            align-items: center;
            gap: 8px;
            color: white;
            text-decoration: none;
            padding: 8px 15px;
            border-radius: 6px;
            background: rgba(255, 255, 255, 0.15);
            transition: all 0.3s;
            font-size: 0.9rem;
        }

        .logout-btn:hover {
            background: rgba(255, 255, 255, 0.25);
            color: white;
            transform: translateY(-1px);
        }

        /* SIDEBAR STYLES */
        .sidebar {
            background: white;
            min-height: calc(100vh - 60px);
            padding: 25px 15px;
            box-shadow: 2px 0 10px rgba(0, 0, 0, 0.05);
            position: fixed;
            top: 60px;
            left: 0;
            width: 16.666667%;
            height: calc(100vh - 60px);
            overflow-y: auto;
            z-index: 1020;
        }

        .sidebar h5 {
            color: #4a90e2;
            margin-bottom: 20px;
            font-weight: 600;
            padding-bottom: 10px;
            border-bottom: 2px solid #e3f2fd;
        }

        .sidebar ul {
            list-style: none;
        }

        .sidebar ul li {
            margin-bottom: 8px;
        }

        .sidebar ul li a {
            display: block;
            padding: 12px 15px;
            color: #555;
            text-decoration: none;
            border-radius: 8px;
            transition: all 0.3s;
            font-size: 0.95rem;
            position: relative;
        }

        .sidebar ul li a:hover,
        .sidebar ul li a.active {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
            transform: translateX(5px);
        }

        .sidebar ul li a i {
            width: 20px;
            margin-right: 10px;
        }

        .sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar::-webkit-scrollbar-track {
            background: #f1f1f1;
        }

        .sidebar::-webkit-scrollbar-thumb {
            background: #4a90e2;
            border-radius: 3px;
        }

        /* MAIN CONTENT */
        .main-content {
            margin-left: 16.666667%;
            margin-top: 60px;
            padding: 25px;
            background: #f0f8ff;
            min-height: calc(100vh - 60px);
        }

        /* PAGE HEADER */
        .page-header {
            text-align: center;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            margin: -25px -25px 30px -25px;
            padding: 40px 20px;
            border-radius: 0 0 15px 15px;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }

        .page-header h1 {
            font-size: 42px;
            font-weight: 700;
            margin-bottom: 10px;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .page-header p {
            font-size: 18px;
            opacity: 0.95;
        }

        /* ALERT MESSAGES */
        .alert {
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
            animation: slideDown 0.3s ease-out;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }

        .alert-warning {
            background: #fff3cd;
            color: #856404;
            border: 1px solid #ffeaa7;
        }

        .alert-info {
            background: #d1ecf1;
            color: #0c5460;
            border: 1px solid #bee5eb;
        }

        /* CARDS */
        .card {
            background: white;
            border-radius: 15px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
            transition: all 0.3s;
        }

        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.2);
        }

        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 25px;
            padding-bottom: 15px;
            border-bottom: 2px solid #f0f8ff;
        }

        .card-title {
            font-size: 24px;
            font-weight: 700;
            color: #333;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        /* SUBSCRIPTION STATUS CARD */
        .subscription-status {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
            border-radius: 15px;
            padding: 40px;
            margin-bottom: 30px;
            box-shadow: 0 10px 30px rgba(74, 144, 226, 0.3);
        }

        .subscription-status.inactive {
            background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
        }

        .subscription-status h3 {
            font-size: 28px;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .subscription-status .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-top: 20px;
        }

        .subscription-status .info-item {
            background: rgba(255, 255, 255, 0.1);
            padding: 15px;
            border-radius: 10px;
            backdrop-filter: blur(10px);
        }

        .subscription-status .info-label {
            font-size: 13px;
            opacity: 0.9;
            margin-bottom: 5px;
        }

        .subscription-status .info-value {
            font-size: 20px;
            font-weight: 700;
        }

        /* STATS GRID */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
            text-align: center;
            transition: all 0.3s;
        }

        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15);
        }

        .stat-card .icon {
            font-size: 48px;
            margin-bottom: 15px;
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .stat-card .value {
            font-size: 36px;
            font-weight: 700;
            color: #333;
            margin-bottom: 5px;
        }

        .stat-card .label {
            font-size: 14px;
            color: #666;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        /* BUTTONS */
        .btn {
            padding: 12px 30px;
            border-radius: 25px;
            border: none;
            font-weight: 600;
            font-size: 16px;
            cursor: pointer;
            transition: all 0.3s;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .btn-primary {
            background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
            color: white;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(74, 144, 226, 0.4);
            color: white;
        }

        .btn-secondary {
            background: #f0f8ff;
            color: #333;
            border: 2px solid #4a90e2;
        }

        .btn-secondary:hover {
            background: #e3f2fd;
            color: #333;
        }

        .btn-success {
            background: #28a745;
            color: white;
        }

        .btn-lg {
            padding: 15px 40px;
            font-size: 18px;
        }

        /* ACTION BUTTONS */
        .action-buttons {
            display: flex;
            justify-content: center;
            gap: 15px;
            margin: 30px 0;
            flex-wrap: wrap;
        }

        /* TABLE STYLES */
        .table-responsive {
            overflow-x: auto;
            margin-top: 20px;
            border-radius: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        table thead {
            background: #f8f9fa;
        }

        table th {
            padding: 15px;
            text-align: left;
            font-weight: 600;
            color: #333;
            font-size: 14px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        table td {
            padding: 15px;
            border-bottom: 1px solid #dee2e6;
            color: #495057;
        }

        table tr:hover {
            background: #f8fbff;
        }

        table .badge {
            padding: 5px 12px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 600;
        }

        table .badge.bg-success {
            background: #28a745;
            color: white;
        }

        table .badge.bg-warning {
            background: #ffc107;
            color: #212529;
        }

        table .badge.bg-danger {
            background: #dc3545;
            color: white;
        }

        /* EMPTY STATE */
        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #6c757d;
        }

        .empty-state i {
            font-size: 64px;
            margin-bottom: 20px;
            opacity: 0.5;
        }

        .empty-state h4 {
            margin-bottom: 10px;
            color: #333;
        }

        /* FEATURES LIST */
        .features-list {
            list-style: none;
            padding: 0;
        }

        .features-list li {
            padding: 10px 0;
            display: flex;
            align-items: center;
            gap: 10px;
            color: rgba(255, 255, 255, 0.95);
        }

        .features-list li i {
            color: #ffc107;
            font-size: 18px;
        }

        /* NOTIFICATION BADGE */
        .notification-badge {
            position: absolute;
            top: -5px;
            right: -5px;
            background: #dc3545;
            color: white;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            font-size: 0.7rem;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
        }

        .menu-item-wrapper {
            position: relative;
            display: inline-block;
            width: 100%;
        }

        /* CHAT DISABLED */
        .chat-disabled-overlay {
            position: relative;
            opacity: 0.5;
            pointer-events: none;
        }

        /* RESPONSIVE */
        @media (max-width: 992px) {
            .sidebar {
                width: 25%;
            }

            .main-content {
                margin-left: 25%;
            }
        }

        @media (max-width: 768px) {
            .sidebar {
                position: relative;
                width: 100%;
                height: auto;
                min-height: auto;
                top: 0;
            }

            .main-content {
                margin-left: 0;
                margin-top: 0;
                padding: 15px;
            }

            .page-header h1 {
                font-size: 32px;
            }

            .stats-grid {
                grid-template-columns: 1fr;
            }

            .action-buttons {
                flex-direction: column;
            }

            .btn {
                width: 100%;
                justify-content: center;
            }

            .subscription-status .info-grid {
                grid-template-columns: 1fr;
            }

            .brand-section {
                gap: 10px;
            }

            .brand-title {
                font-size: 1.1rem;
            }
        }

        @media (max-width: 576px) {
            .topbar-container {
                flex-direction: column;
                gap: 10px;
                padding: 10px 0;
                height: auto;
            }

            .topbar {
                height: auto;
                padding: 10px 0;
            }

            .brand-section,
            .user-section {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>

<body>
    <?php
    // SET DEFAULT VALUES FOR ALL VARIABLES
    if (!isset($user_reports_count)) {
        $user_reports_count = 0;
    }

    if (!isset($subscription_stats)) {
        $subscription_stats = [
            'has_active' => false,
            'total_spent' => 0,
            'pending_payments' => 0
        ];
    }

    if (!isset($active_subscription)) {
        $active_subscription = null;
    }

    if (!isset($payment_history)) {
        $payment_history = [];
    }
    
    // LOGIC UNTUK MENENTUKAN APAKAH ADA SUBSCRIPTION AKTIF
    // SUMBER KEBENARAN TUNGGAL UNTUK SEMUA BAGIAN
    
    // 1. Cek dari subscription_stats terlebih dahulu
    $is_subscription_active_from_stats = isset($subscription_stats['has_active']) && $subscription_stats['has_active'];
    
    // 2. Cek dari active_subscription
    $is_subscription_active_from_details = isset($active_subscription) && $active_subscription && 
                                          isset($active_subscription->end_date) && 
                                          strtotime($active_subscription->end_date) > time();
    
    // 3. Cek dari variabel $has_subscription (jika ada)
    $is_subscription_active_from_var = isset($has_subscription) && $has_subscription;
    
    // GABUNGKAN SEMUA LOGIKA - JIKA SALAH SATUNYA TRUE, MAKA SUBSCRIPTION AKTIF
    $is_subscription_active = $is_subscription_active_from_stats || 
                              $is_subscription_active_from_details || 
                              $is_subscription_active_from_var;
    
    // DEBUG LOG (bisa dihapus setelah testing)
    // echo "<!-- DEBUG: stats: " . ($is_subscription_active_from_stats ? 'true' : 'false') . 
    //      ", details: " . ($is_subscription_active_from_details ? 'true' : 'false') . 
    //      ", var: " . ($is_subscription_active_from_var ? 'true' : 'false') . 
    //      ", final: " . ($is_subscription_active ? 'true' : 'false') . " -->";
    ?>

    <!-- TOPBAR -->
    <div class="topbar">
        <div class="container-fluid">
            <div class="topbar-container">
                <!-- Brand Section -->
                <div class="brand-section">
                    <img src="<?= base_url('asset/logo 2.png'); ?>" alt="Logo KosCare" class="brand-logo">
                    <div>
                        <h4 class="brand-title m-0">
                            KosCare<span class="brand-subtitle">- Dashboard Admin</span>
                        </h4>
                    </div>
                </div>

                <!-- User Section -->
                <div class="user-section">
                    <div class="user-info">
                        <i class="fas fa-user-circle user-avatar"></i>
                        <div>
                            <span>Halo, <strong><?= $this->session->userdata('admin_name'); ?></strong></span>
                        </div>
                    </div>
                    <a href="<?= site_url('admin/login/logout'); ?>" class="logout-btn">
                        <i class="fas fa-sign-out-alt"></i> Logout
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- SIDEBAR -->
    <div class="sidebar" id="sidebar">
        <h5><i class="fas fa-bars"></i> Menu</h5>
        <ul>
            <li><a href="<?= site_url('admin/dashboard'); ?>"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
            <li><a href="<?= site_url('admin/laporan'); ?>"><i class="fas fa-clipboard-list"></i> Laporan</a></li>
            <li><a href="<?= site_url('admin/penghuni'); ?>"><i class="fas fa-users"></i> Penghuni</a></li>
            <li>
                <a class="active" href="<?php echo site_url('admin/subscription'); ?>">
                    <i class="fas fa-crown"></i> Berlangganan
                    <?php if ($is_subscription_active): ?>
                        <span class="badge bg-success">Active</span>
                    <?php else: ?>
                        <span class="badge bg-danger">Inactive</span>
                    <?php endif; ?>
                </a>
            </li>
            
            <!-- MENU CHAT - HANYA AKTIF JIKA ADA SUBSCRIPTION -->
            <?php if ($is_subscription_active): ?>
                <li>
                    <a href="<?= site_url('admin/chat_v2'); ?>">
                        <i class="fas fa-comments"></i> Chat
                    </a>
                </li>
            <?php else: ?>
                <li class="chat-disabled-overlay">
                    <a href="#" onclick="showSubscriptionAlert(); return false;">
                        <i class="fas fa-comments"></i> Chat
                        <i class="fas fa-lock" style="float: right; color: #ffc107;"></i>
                    </a>
                </li>
            <?php endif; ?>
            
            <li><a href="<?= site_url('admin/iklan'); ?>"><i class="fas fa-bullhorn"></i> Iklan</a></li>
            <li><a href="<?= site_url('admin/kos'); ?>"><i class="fas fa-building"></i> Kos</a></li>
            <li class="menu-item-wrapper">
                <a href="<?= site_url('admin/laporan_admin_reports'); ?>">
                    <i class="fas fa-flag"></i> Laporan Admin
                    <?php if (isset($user_reports_count) && $user_reports_count > 0): ?>
                        <span class="notification-badge"><?= $user_reports_count; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <li><a href="<?= site_url('admin/pengaturan'); ?>"><i class="fas fa-cog"></i> Pengaturan</a></li>
        </ul>
    </div>

    <!-- MAIN CONTENT -->
    <div class="main-content">
        <!-- Page Header -->
        <div class="page-header">
            <h1>
                <i class="fas fa-crown"></i>
                Subscription Management
            </h1>
            <p>Manage your subscription and unlock premium features</p>
        </div>

        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <span><?= $this->session->flashdata('success') ?></span>
            </div>
        <?php endif; ?>

        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-error">
                <i class="fas fa-exclamation-circle"></i>
                <span><?= $this->session->flashdata('error') ?></span>
            </div>
        <?php endif; ?>

        <?php if ($this->session->flashdata('warning')): ?>
            <div class="alert alert-warning">
                <i class="fas fa-exclamation-triangle"></i>
                <span><?= $this->session->flashdata('warning') ?></span>
            </div>
        <?php endif; ?>

        <!-- Active Subscription Card -->
        <?php if ($is_subscription_active && isset($active_subscription) && $active_subscription): ?>
            <div class="subscription-status">
                <h3>
                    <i class="fas fa-check-circle"></i>
                    Active Subscription
                </h3>

                <div class="info-grid">
                    <div class="info-item">
                        <div class="info-label">Plan</div>
                        <div class="info-value">
                            <?= htmlspecialchars($active_subscription->plan_name ?? 'Active Plan') ?>
                        </div>
                    </div>

                    <div class="info-item">
                        <div class="info-label">Start Date</div>
                        <div class="info-value">
                            <?= date('d M Y', strtotime($active_subscription->start_date)) ?>
                        </div>
                    </div>

                    <div class="info-item">
                        <div class="info-label">Expires On</div>
                        <div class="info-value">
                            <?= date('d M Y', strtotime($active_subscription->end_date)) ?>
                        </div>
                    </div>

                    <div class="info-item">
                        <div class="info-label">Days Remaining</div>
                        <div class="info-value">
                            <?php
                            $days_remaining = 0;
                            if (isset($active_subscription->end_date)) {
                                $end_timestamp = strtotime($active_subscription->end_date);
                                $current_timestamp = time();
                                $days_remaining = ceil(($end_timestamp - $current_timestamp) / 86400);
                                $days_remaining = max(0, $days_remaining);
                            }
                            echo $days_remaining . ' days';
                            ?>
                        </div>
                    </div>
                </div>

                <?php if ($days_remaining <= 7 && $days_remaining > 0): ?>
                    <div class="alert alert-warning" style="margin-top: 20px;">
                        <i class="fas fa-clock"></i>
                        <span>
                            <strong>Reminder:</strong> Your subscription will expire in <?= $days_remaining ?> days.
                            <a href="<?= site_url('admin/subscription/pricing') ?>" style="color: inherit; text-decoration: underline;">
                                Renew now
                            </a> to continue using chat features.
                        </span>
                    </div>
                <?php endif; ?>

                <!-- Active Features -->
                <div style="margin-top: 25px;">
                    <strong style="display: block; margin-bottom: 15px; font-size: 18px;">
                        <i class="fas fa-star"></i> Active Features:
                    </strong>
                    <ul class="features-list">
                        <li><i class="fas fa-check"></i> Real-time Chat System (UNLOCKED)</li>
                        <li><i class="fas fa-check"></i> Unlimited Messages</li>
                        <li><i class="fas fa-check"></i> Priority Support</li>
                        <li><i class="fas fa-check"></i> Advanced Analytics</li>
                    </ul>
                </div>
                
                <!-- Status Message -->
                <div style="margin-top: 20px; padding: 15px; background: rgba(255, 255, 255, 0.2); border-radius: 10px;">
                    <i class="fas fa-info-circle"></i>
                    <strong>Status:</strong> Chat feature is currently <span style="color: #90ee90; font-weight: bold;">UNLOCKED</span> 
                    and accessible from the sidebar menu.
                </div>
            </div>

        <?php elseif ($is_subscription_active): ?>
            <!-- Subscription active but no detailed info -->
            <div class="subscription-status">
                <h3>
                    <i class="fas fa-check-circle"></i>
                    Active Subscription
                </h3>
                <p style="margin: 15px 0; font-size: 16px; opacity: 0.95;">
                    You have an active subscription. Premium features are unlocked.
                </p>
                
                <!-- Active Features -->
                <div style="margin-top: 25px;">
                    <strong style="display: block; margin-bottom: 15px; font-size: 18px;">
                        <i class="fas fa-star"></i> Active Features:
                    </strong>
                    <ul class="features-list">
                        <li><i class="fas fa-check"></i> Real-time Chat System (UNLOCKED)</li>
                        <li><i class="fas fa-check"></i> Unlimited Messages</li>
                        <li><i class="fas fa-check"></i> Priority Support</li>
                        <li><i class="fas fa-check"></i> Advanced Analytics</li>
                    </ul>
                </div>
            </div>

        <?php else: ?>
            <!-- No Active Subscription -->
            <div class="subscription-status inactive">
                <h3>
                    <i class="fas fa-exclamation-triangle"></i>
                    No Active Subscription
                </h3>
                <p style="margin: 15px 0; font-size: 16px; opacity: 0.95;">
                    You need an active subscription to unlock premium features like the chat system.
                </p>
                <ul class="features-list">
                    <li><i class="fas fa-times-circle"></i> Chat feature is currently LOCKED</li>
                    <li><i class="fas fa-times-circle"></i> Limited access to premium features</li>
                </ul>
                
                <!-- Upgrade Prompt -->
                <div style="margin-top: 25px; text-align: center;">
                    <a href="<?= site_url('admin/subscription/pricing') ?>" class="btn btn-primary btn-lg" style="margin-top: 10px;">
                        <i class="fas fa-rocket"></i>
                        Unlock Premium Features Now
                    </a>
                </div>
            </div>
        <?php endif; ?>

        <!-- Statistics Grid -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="icon">
                    <i class="fas fa-calendar-check"></i>
                </div>
                <div class="value">
                    <?= $is_subscription_active ? '1' : '0' ?>
                </div>
                <div class="label">Active Subscriptions</div>
            </div>

            <div class="stat-card">
                <div class="icon">
                    <i class="fas fa-money-bill-wave"></i>
                </div>
                <div class="value">
                    Rp <?= number_format(isset($subscription_stats['total_spent']) ? $subscription_stats['total_spent'] : 0, 0, ',', '.') ?>
                </div>
                <div class="label">Total Spent</div>
            </div>

            <div class="stat-card">
                <div class="icon">
                    <i class="fas fa-clock"></i>
                </div>
                <div class="value">
                    <?= isset($subscription_stats['pending_payments']) ? $subscription_stats['pending_payments'] : 0 ?>
                </div>
                <div class="label">Pending Payments</div>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="action-buttons">
            <?php if (!$is_subscription_active): ?>
                <a href="<?= site_url('admin/subscription/pricing') ?>" class="btn btn-primary btn-lg">
                    <i class="fas fa-rocket"></i>
                    Choose a Plan
                </a>
            <?php else: ?>
                <a href="<?= site_url('admin/subscription/pricing') ?>" class="btn btn-primary btn-lg">
                    <i class="fas fa-arrow-up"></i>
                    Upgrade / Renew Plan
                </a>
                <a href="<?= site_url('admin/chat_v2') ?>" class="btn btn-success btn-lg">
                    <i class="fas fa-comments"></i>
                    Go to Chat
                </a>
            <?php endif; ?>

            <a href="<?= site_url('admin/dashboard') ?>" class="btn btn-secondary btn-lg">
                <i class="fas fa-home"></i>
                Back to Dashboard
            </a>
        </div>

        <!-- Payment History -->
        <?php if (isset($payment_history) && !empty($payment_history)): ?>
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title">
                        <i class="fas fa-history"></i>
                        Payment History
                    </h2>
                </div>

                <div class="table-responsive">
                    <table>
                        <thead>
                            <tr>
                                <th>Order ID</th>
                                <th>Plan</th>
                                <th>Amount</th>
                                <th>Payment Method</th>
                                <th>Status</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($payment_history as $payment): ?>
                                <tr>
                                    <td>
                                        <strong><?= htmlspecialchars($payment->order_id) ?></strong>
                                    </td>
                                    <td><?= htmlspecialchars($payment->plan_name ?? 'N/A') ?></td>
                                    <td>
                                        <strong>Rp <?= number_format($payment->gross_amount, 0, ',', '.') ?></strong>
                                    </td>
                                    <td>
                                        <?php
                                        $payment_method = $payment->payment_type ?? '-';
                                        $payment_method = ucwords(str_replace('_', ' ', $payment_method));
                                        echo htmlspecialchars($payment_method);
                                        ?>
                                    </td>
                                    <td>
                                        <?php
                                        $status = $payment->transaction_status;
                                        $badge_class = 'bg-warning';
                                        $status_text = ucfirst($status);

                                        switch ($status) {
                                            case 'settlement':
                                            case 'success':
                                                $badge_class = 'bg-success';
                                                $status_text = 'Success';
                                                break;
                                            case 'pending':
                                                $badge_class = 'bg-warning';
                                                $status_text = 'Pending';
                                                break;
                                            case 'deny':
                                            case 'cancel':
                                            case 'expire':
                                                $badge_class = 'bg-danger';
                                                $status_text = ucfirst($status);
                                                break;
                                        }
                                        ?>
                                        <span class="badge <?= $badge_class ?>">
                                            <?= $status_text ?>
                                        </span>
                                    </td>
                                    <td>
                                        <?= date('d M Y, H:i', strtotime($payment->created_at)) ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>

        <?php else: ?>
            <!-- Empty State -->
            <div class="card">
                <div class="empty-state">
                    <i class="fas fa-receipt"></i>
                    <h4>No Payment History</h4>
                    <p>You haven't made any payments yet.</p>
                </div>
            </div>
        <?php endif; ?>

        <!-- Help Section -->
        <div class="card">
            <div class="card-header">
                <h2 class="card-title">
                    <i class="fas fa-question-circle"></i>
                    Need Help?
                </h2>
            </div>
            <p style="color: #666; line-height: 1.6;">
                If you have any questions about subscriptions, billing, or need assistance,
                please contact our support team. We're here to help you get the most out of your subscription.
            </p>
            <div style="margin-top: 20px;">
                <a href="mailto:support@koscare.com" class="btn btn-secondary">
                    <i class="fas fa-envelope"></i>
                    Contact Support
                </a>
            </div>
        </div>

    </div>

    <!-- Scripts -->
    <script src="<?php echo base_url('asset/js/jquery-3.6.0.min.js'); ?>"></script>
    <script src="<?php echo base_url('asset/js/bootstrap.bundle.min.js'); ?>"></script>

    <script>
        // Active menu highlight
        const currentPath = window.location.pathname;
        document.querySelectorAll('.sidebar a').forEach(link => {
            const href = link.getAttribute('href');
            if (currentPath.includes(href) && href !== '<?php echo site_url('admin/dashboard'); ?>') {
                document.querySelectorAll('.sidebar a').forEach(l => l.classList.remove('active'));
                link.classList.add('active');
            }
        });

        // Function to show subscription alert
        function showSubscriptionAlert() {
            if (confirm('Chat feature requires an active subscription. Would you like to upgrade now?')) {
                window.location.href = '<?= site_url('admin/subscription/pricing') ?>';
            }
        }

        // Auto-hide alerts after 5 seconds
        setTimeout(function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(function(alert) {
                alert.style.transition = 'opacity 0.3s, transform 0.3s';
                alert.style.opacity = '0';
                alert.style.transform = 'translateY(-20px)';
                setTimeout(function() {
                    alert.remove();
                }, 300);
            });
        }, 5000);

        // Confirm before choosing a plan
        document.querySelectorAll('a[href*="pricing"]').forEach(function(link) {
            const text = link.textContent.trim();
            if (text.includes('Choose') || text.includes('Upgrade') || text.includes('Unlock')) {
                link.addEventListener('click', function(e) {
                    if (!confirm('You will be redirected to choose a subscription plan. Continue?')) {
                        e.preventDefault();
                    }
                });
            }
        });

        // Add hover effect to logout button
        document.addEventListener('DOMContentLoaded', function() {
            const logoutBtn = document.querySelector('.logout-btn');
            if (logoutBtn) {
                logoutBtn.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-1px) scale(1.02)';
                });
                logoutBtn.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0) scale(1)';
                });
            }
        });
        
        // Add animation to subscription status card
        document.addEventListener('DOMContentLoaded', function() {
            const statusCard = document.querySelector('.subscription-status');
            if (statusCard) {
                statusCard.style.animation = 'slideDown 0.5s ease-out';
            }
        });
    </script>
</body>

</html>