<!doctype html>
<html>

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?php echo isset($title) ? $title : 'Form Admin'; ?></title>
  <link rel="stylesheet" href="<?php echo site_url('asset/css/bootstrap.min.css'); ?>">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: #f0f8ff;
      color: #333;
    }

    .topbar {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      padding: 15px 0;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      z-index: 1030;
    }

    .topbar h4 {
      color: white;
      font-weight: 600;
      font-size: 1.3rem;
    }

    .topbar a {
      color: white;
      text-decoration: none;
      transition: opacity 0.3s;
    }

    .topbar a:hover {
      opacity: 0.8;
    }

    .topbar .user-info {
      color: white;
      font-size: 0.95rem;
    }

    .sidebar {
      background: white;
      min-height: calc(100vh - 60px);
      padding: 25px 15px;
      box-shadow: 2px 0 10px rgba(0, 0, 0, 0.05);
      position: fixed;
      top: 60px;
      left: 0;
      width: 16.666667%;
      height: calc(100vh - 60px);
      overflow-y: auto;
      z-index: 1020;
    }

    .sidebar h5 {
      color: #667eea;
      margin-bottom: 20px;
      font-weight: 600;
      padding-bottom: 10px;
      border-bottom: 2px solid #e8eaf6;
    }

    .sidebar ul {
      list-style: none;
    }

    .sidebar ul li {
      margin-bottom: 8px;
    }

    .sidebar ul li a {
      display: block;
      padding: 12px 15px;
      color: #555;
      text-decoration: none;
      border-radius: 8px;
      transition: all 0.3s;
      font-size: 0.95rem;
    }

    .sidebar ul li a:hover,
    .sidebar ul li a.active {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      transform: translateX(5px);
    }

    .sidebar ul li a i {
      width: 20px;
      margin-right: 10px;
    }

    .main-content {
      margin-left: 16.666667%;
      margin-top: 60px;
      padding: 25px;
      background: #f0f8ff;
      min-height: calc(100vh - 60px);
    }

    .page-header {
      background: white;
      border-radius: 12px;
      padding: 25px;
      margin-bottom: 25px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
      display: flex;
      justify-content: space-between;
      align-items: center;
      flex-wrap: wrap;
      gap: 15px;
    }

    .page-header h3 {
      color: #667eea;
      font-weight: 600;
      margin: 0;
    }

    .btn-back {
      background: white;
      border: 2px solid #6c757d;
      color: #6c757d;
      padding: 10px 20px;
      border-radius: 8px;
      text-decoration: none;
      transition: all 0.3s;
      font-size: 0.9rem;
      font-weight: 500;
      display: inline-flex;
      align-items: center;
      gap: 8px;
    }

    .btn-back:hover {
      background: #6c757d;
      color: white;
      transform: translateY(-2px);
    }

    .form-card {
      background: white;
      border-radius: 12px;
      padding: 30px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
      max-width: 600px;
      margin: 0 auto;
    }

    .form-group {
      margin-bottom: 25px;
    }

    .form-group label {
      display: block;
      font-weight: 600;
      color: #555;
      margin-bottom: 8px;
      font-size: 0.95rem;
    }

    .form-group label i {
      margin-right: 8px;
      color: #667eea;
    }

    .form-control {
      width: 100%;
      padding: 12px 15px;
      border: 2px solid #e9ecef;
      border-radius: 8px;
      font-size: 0.95rem;
      transition: all 0.3s;
      background: #f8f9fa;
    }

    .form-control:focus {
      outline: none;
      border-color: #667eea;
      background: white;
      box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .form-control:hover {
      border-color: #667eea;
    }

    .input-group {
      position: relative;
    }

    .input-group .form-control {
      padding-right: 45px;
    }

    .toggle-password {
      position: absolute;
      right: 12px;
      top: 50%;
      transform: translateY(-50%);
      background: none;
      border: none;
      color: #667eea;
      cursor: pointer;
      font-size: 1.1rem;
      padding: 5px;
      transition: all 0.3s;
    }

    .toggle-password:hover {
      color: #764ba2;
    }

    .form-actions {
      display: flex;
      gap: 15px;
      margin-top: 30px;
      padding-top: 20px;
      border-top: 2px solid #f0f0f0;
    }

    .btn-submit {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border: none;
      padding: 12px 30px;
      border-radius: 8px;
      font-size: 1rem;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.3s;
      display: inline-flex;
      align-items: center;
      gap: 10px;
    }

    .btn-submit:hover {
      transform: translateY(-2px);
      box-shadow: 0 6px 20px rgba(102, 126, 234, 0.3);
    }

    .btn-reset {
      background: white;
      color: #dc3545;
      border: 2px solid #dc3545;
      padding: 12px 30px;
      border-radius: 8px;
      font-size: 1rem;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.3s;
      display: inline-flex;
      align-items: center;
      gap: 10px;
    }

    .btn-reset:hover {
      background: #dc3545;
      color: white;
      transform: translateY(-2px);
    }

    .required {
      color: #dc3545;
      margin-left: 3px;
    }

    .help-text {
      font-size: 0.85rem;
      color: #888;
      margin-top: 5px;
      display: block;
    }

    .alert-info {
      background: #e3f2fd;
      border: 1px solid #90caf9;
      border-radius: 8px;
      padding: 12px 15px;
      color: #1976d2;
      font-size: 0.9rem;
      margin-bottom: 20px;
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .alert-info i {
      font-size: 1.2rem;
    }

    .password-strength {
      margin-top: 8px;
      height: 4px;
      background: #e9ecef;
      border-radius: 4px;
      overflow: hidden;
      display: none;
    }

    .password-strength-bar {
      height: 100%;
      transition: all 0.3s;
      border-radius: 4px;
    }

    .password-hint {
      font-size: 0.8rem;
      color: #888;
      margin-top: 5px;
      display: none;
    }

    @media (max-width: 768px) {
      .sidebar {
        position: relative;
        width: 100%;
        height: auto;
        min-height: auto;
        top: 0;
      }

      .main-content {
        margin-left: 0;
        padding: 15px;
      }

      .form-card {
        padding: 20px;
      }

      .page-header {
        flex-direction: column;
        align-items: flex-start;
      }

      .form-actions {
        flex-direction: column;
      }

      .btn-submit,
      .btn-reset {
        width: 100%;
        justify-content: center;
      }
    }

    .sidebar::-webkit-scrollbar {
      width: 6px;
    }

    .sidebar::-webkit-scrollbar-track {
      background: #f1f1f1;
    }

    .sidebar::-webkit-scrollbar-thumb {
      background: #667eea;
      border-radius: 3px;
    }

    .sidebar::-webkit-scrollbar-thumb:hover {
      background: #764ba2;
    }
  </style>
</head>

<body>
  <div class="topbar">
    <div class="container-fluid">
      <div class="d-flex justify-content-between align-items-center">
        <div class="login-icon">
          <img src="<?= base_url('asset/logo 2.png'); ?>" alt="Logo KosCare" style="width: 50px; height: auto;"><span>KosCare - Super Admin</span>
        </div>
        <div class="user-info">
          <i class="fas fa-user-shield"></i> Halo, <strong><?php echo $this->session->userdata('super_admin_name'); ?></strong> |
          <a href="<?php echo site_url('superadmin/logout'); ?>"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>
      </div>
    </div>
  </div>

  <div class="sidebar" id="sidebar">
    <h5><i class="fas fa-bars"></i> Menu</h5>
    <ul>
      <li><a href="<?php echo site_url('superadmin/superadmin/dashboard'); ?>"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
      <li><a href="<?php echo site_url('superadmin/superadmin/admin_list'); ?>" class="active"><i class="fas fa-user-tie"></i> Kelola Admin</a></li>
      <li><a href="<?php echo site_url('superadmin/superadmin/kos_list'); ?>"><i class="fas fa-building"></i> Kelola Kos</a></li>
    </ul>
  </div>

  <div class="main-content">
    <div class="page-header">
      <h3><i class="fas fa-user-edit"></i> <?php echo $title; ?></h3>
      <a href="<?php echo site_url('superadmin/superadmin/admin_list'); ?>" class="btn-back">
        <i class="fas fa-arrow-left"></i> Kembali
      </a>
    </div>

    <div class="form-card">
      <?php if (isset($admin)): ?>
        <div class="alert-info">
          <i class="fas fa-info-circle"></i>
          <span>Mode Edit: Kosongkan field password jika tidak ingin mengubahnya</span>
        </div>
      <?php endif; ?>

      <form method="post" action="<?php echo site_url('superadmin/superadmin/save_admin'); ?>" id="adminForm">
        <input type="hidden" name="id" value="<?php echo isset($admin) ? $admin->id : ''; ?>">

        <div class="form-group">
          <label>
            <i class="fas fa-user"></i> Nama Admin <span class="required">*</span>
          </label>
          <input type="text" name="nama" class="form-control"
            value="<?php echo isset($admin) ? $admin->nama : ''; ?>"
            placeholder="Contoh: John Doe" required>
          <small class="help-text">Masukkan nama lengkap admin</small>
        </div>

        <div class="form-group">
          <label>
            <i class="fas fa-envelope"></i> Email <span class="required">*</span>
          </label>
          <input type="email" name="email" class="form-control"
            value="<?php echo isset($admin) ? $admin->email : ''; ?>"
            placeholder="Contoh: admin@sistemkos.com" required>
          <small class="help-text">Email akan digunakan untuk login</small>
        </div>

        <div class="form-group">
          <label>
            <i class="fas fa-lock"></i> Password
            <?php if (isset($admin)): ?>
              <span class="help-text" style="display: inline; color: #888; font-weight: normal;">(Kosongkan jika tidak diubah)</span>
            <?php else: ?>
              <span class="required">*</span>
            <?php endif; ?>
          </label>
          <div class="input-group">
            <input type="password" name="password" class="form-control" id="passwordInput"
              placeholder="Masukkan password" <?php echo !isset($admin) ? 'required' : ''; ?>>
            <button type="button" class="toggle-password" onclick="togglePassword()">
              <i class="fas fa-eye" id="toggleIcon"></i>
            </button>
          </div>
          <div class="password-strength" id="passwordStrength">
            <div class="password-strength-bar" id="strengthBar"></div>
          </div>
          <small class="help-text password-hint" id="passwordHint">
            Password harus minimal 6 karakter
          </small>
        </div>

        <div class="form-actions">
          <button type="submit" class="btn-submit">
            <i class="fas fa-save"></i> Simpan Data
          </button>
          <button type="reset" class="btn-reset">
            <i class="fas fa-redo"></i> Reset Form
          </button>
        </div>
      </form>
    </div>
  </div>

  <script src="<?php echo site_url('asset/js/jquery-3.6.0.min.js'); ?>"></script>
  <script src="<?php echo site_url('asset/js/bootstrap.bundle.min.js'); ?>"></script>

  <script>
    // Active menu highlight
    const currentPath = window.location.pathname;
    document.querySelectorAll('.sidebar a').forEach(link => {
      const href = link.getAttribute('href');
      if (currentPath.includes(href) && href !== '<?php echo site_url('superadmin/dashboard'); ?>') {
        document.querySelectorAll('.sidebar a').forEach(l => l.classList.remove('active'));
        link.classList.add('active');
      }
    });

    // Toggle password visibility
    function togglePassword() {
      const passwordInput = document.getElementById('passwordInput');
      const toggleIcon = document.getElementById('toggleIcon');

      if (passwordInput.type === 'password') {
        passwordInput.type = 'text';
        toggleIcon.classList.remove('fa-eye');
        toggleIcon.classList.add('fa-eye-slash');
      } else {
        passwordInput.type = 'password';
        toggleIcon.classList.remove('fa-eye-slash');
        toggleIcon.classList.add('fa-eye');
      }
    }

    // Password strength indicator
    const passwordInput = document.getElementById('passwordInput');
    const strengthBar = document.getElementById('strengthBar');
    const passwordStrength = document.getElementById('passwordStrength');
    const passwordHint = document.getElementById('passwordHint');

    passwordInput.addEventListener('input', function() {
      const password = this.value;

      if (password.length > 0) {
        passwordStrength.style.display = 'block';
        passwordHint.style.display = 'block';

        let strength = 0;
        if (password.length >= 6) strength += 25;
        if (password.length >= 8) strength += 25;
        if (/[a-z]/.test(password) && /[A-Z]/.test(password)) strength += 25;
        if (/[0-9]/.test(password)) strength += 15;
        if (/[^a-zA-Z0-9]/.test(password)) strength += 10;

        strengthBar.style.width = strength + '%';

        if (strength < 40) {
          strengthBar.style.background = '#dc3545';
          passwordHint.textContent = 'Password lemah';
          passwordHint.style.color = '#dc3545';
        } else if (strength < 70) {
          strengthBar.style.background = '#ffc107';
          passwordHint.textContent = 'Password sedang';
          passwordHint.style.color = '#ffc107';
        } else {
          strengthBar.style.background = '#28a745';
          passwordHint.textContent = 'Password kuat';
          passwordHint.style.color = '#28a745';
        }
      } else {
        passwordStrength.style.display = 'none';
        passwordHint.style.display = 'none';
      }
    });

    // Form validation
    document.getElementById('adminForm').addEventListener('submit', function(e) {
      const nama = document.querySelector('input[name="nama"]').value.trim();
      const email = document.querySelector('input[name="email"]').value.trim();
      const password = document.querySelector('input[name="password"]').value;
      const isEdit = <?php echo isset($admin) ? 'true' : 'false'; ?>;

      if (!nama || !email) {
        e.preventDefault();
        alert('Nama dan Email harus diisi!');
        return false;
      }

      if (!isEdit && password.length < 6) {
        e.preventDefault();
        alert('Password harus minimal 6 karakter!');
        return false;
      }

      if (password.length > 0 && password.length < 6) {
        e.preventDefault();
        alert('Password harus minimal 6 karakter!');
        return false;
      }
    });
  </script>
</body>

</html>