<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lupa Password Super Admin</title>
    <link rel="stylesheet" href="<?php echo site_url('asset/css/bootstrap.min.css'); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .forgot-container {
            width: 100%;
            max-width: 450px;
            padding: 15px;
        }

        .forgot-card {
            background: white;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
        }

        .forgot-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 25px;
            text-align: center;
        }

        .forgot-header i {
            font-size: 3rem;
            margin-bottom: 15px;
            display: block;
        }

        .forgot-header h2 {
            font-weight: 600;
            font-size: 1.6rem;
            margin-bottom: 5px;
        }

        .forgot-header p {
            opacity: 0.9;
            font-size: 0.9rem;
        }

        .forgot-body {
            padding: 25px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            font-weight: 500;
            margin-bottom: 8px;
            color: #555;
            display: block;
        }

        .form-control {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 1rem;
            transition: all 0.3s;
        }

        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
            outline: none;
        }

        .input-group {
            position: relative;
        }

        .input-group i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #999;
        }

        .input-group input {
            padding-left: 45px;
        }

        .btn-submit {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 14px;
            border-radius: 8px;
            font-size: 1rem;
            font-weight: 600;
            width: 100%;
            cursor: pointer;
            transition: all 0.3s;
            margin-top: 10px;
        }

        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }

        .btn-back {
            background: #6c757d;
            color: white;
            border: none;
            padding: 12px;
            border-radius: 8px;
            font-size: 0.9rem;
            width: 100%;
            cursor: pointer;
            transition: all 0.3s;
            margin-top: 10px;
            text-decoration: none;
            display: inline-block;
            text-align: center;
        }

        .btn-back:hover {
            background: #5a6268;
        }

        .alert {
            padding: 12px 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 0.9rem;
        }

        .alert-danger {
            background: #fee;
            border: 1px solid #f99;
            color: #c00;
        }

        .alert-success {
            background: #efe;
            border: 1px solid #9f9;
            color: #090;
        }

        .alert-info {
            background: #e3f2fd;
            border: 1px solid #64b5f6;
            color: #1565c0;
        }

        .instructions {
            background: #f8f9fa;
            border-left: 4px solid #667eea;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 0 8px 8px 0;
        }

        .instructions p {
            margin-bottom: 5px;
            font-size: 0.9rem;
            color: #666;
        }

        .footer-text {
            text-align: center;
            margin-top: 20px;
            color: #888;
            font-size: 0.85rem;
        }
    </style>
</head>
<body>
    <div class="forgot-container">
        <div class="forgot-card">
            <div class="forgot-header">
                <i class="fas fa-key"></i>
                <h2>Lupa Password</h2>
                <p>Super Admin Panel</p>
            </div>

            <div class="forgot-body">
                <?php if ($this->session->flashdata('error')): ?>
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-circle"></i> <?php echo $this->session->flashdata('error'); ?>
                    </div>
                <?php endif; ?>

                <?php if ($this->session->flashdata('success')): ?>
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle"></i> <?php echo $this->session->flashdata('success'); ?>
                    </div>
                <?php endif; ?>

                <div class="instructions">
                    <p><i class="fas fa-info-circle"></i> Masukkan email Super Admin Anda.</p>
                    <p><i class="fas fa-info-circle"></i> Kami akan mengirimkan kode OTP ke email tersebut.</p>
                    <p><i class="fas fa-info-circle"></i> Kode OTP berlaku selama 10 menit.</p>
                </div>

                <form action="<?php echo site_url('superadmin/forgot_password/process_request'); ?>" method="POST">
                    <div class="form-group">
                        <label class="form-label" for="email">Email Super Admin</label>
                        <div class="input-group">
                            <i class="fas fa-envelope"></i>
                            <input type="email" name="email" id="email" class="form-control" 
                                   placeholder="superadmin@example.com" required 
                                   value="<?php echo set_value('email'); ?>">
                        </div>
                    </div>

                    <button type="submit" class="btn-submit">
                        <i class="fas fa-paper-plane"></i> Kirim Kode OTP
                    </button>
                    
                    <a href="<?php echo site_url('superadmin'); ?>" class="btn-back">
                        <i class="fas fa-arrow-left"></i> Kembali ke Login
                    </a>
                </form>
                
                <div class="footer-text">
                    &copy; <?php echo date('Y'); ?> KosCare- Super Admin Panel
                </div>
            </div>
        </div>
    </div>
</body>
</html>