<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Password - Super Admin</title>
    <link rel="stylesheet" href="<?php echo site_url('asset/css/bootstrap.min.css'); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .reset-container {
            width: 100%;
            max-width: 450px;
            padding: 15px;
        }

        .reset-card {
            background: white;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
        }

        .reset-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 25px;
            text-align: center;
        }

        .reset-header i {
            font-size: 3rem;
            margin-bottom: 15px;
            display: block;
        }

        .reset-header h2 {
            font-weight: 600;
            font-size: 1.6rem;
            margin-bottom: 5px;
        }

        .reset-header p {
            opacity: 0.9;
            font-size: 0.9rem;
        }

        .reset-body {
            padding: 25px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            font-weight: 500;
            margin-bottom: 8px;
            color: #555;
            display: block;
        }

        .input-group {
            position: relative;
        }

        .input-group i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #999;
            z-index: 2;
        }

        .input-group input {
            width: 100%;
            padding: 12px 15px 12px 45px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 1rem;
            transition: all 0.3s;
        }

        .input-group input:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
            outline: none;
        }

        .toggle-password {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #999;
            cursor: pointer;
            z-index: 2;
        }

        .password-strength {
            height: 5px;
            background: #eee;
            border-radius: 5px;
            margin-top: 5px;
            overflow: hidden;
        }

        .strength-bar {
            height: 100%;
            width: 0%;
            transition: width 0.3s, background 0.3s;
        }

        .requirements {
            background: #f8f9fa;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
            font-size: 0.85rem;
        }

        .requirements ul {
            list-style: none;
            padding-left: 0;
            margin-bottom: 0;
        }

        .requirements li {
            margin-bottom: 5px;
            display: flex;
            align-items: center;
        }

        .requirements li i {
            margin-right: 8px;
            width: 16px;
        }

        .requirement-met {
            color: #28a745;
        }

        .requirement-not-met {
            color: #dc3545;
        }

        .btn-reset {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 14px;
            border-radius: 8px;
            font-size: 1rem;
            font-weight: 600;
            width: 100%;
            cursor: pointer;
            transition: all 0.3s;
            margin-top: 10px;
        }

        .btn-reset:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }

        .btn-reset:disabled {
            background: #ccc;
            cursor: not-allowed;
            transform: none;
            box-shadow: none;
        }

        .btn-cancel {
            background: #6c757d;
            color: white;
            border: none;
            padding: 12px;
            border-radius: 8px;
            font-size: 0.9rem;
            width: 100%;
            cursor: pointer;
            transition: all 0.3s;
            margin-top: 10px;
            text-decoration: none;
            display: inline-block;
            text-align: center;
        }

        .btn-cancel:hover {
            background: #5a6268;
        }

        .alert {
            padding: 12px 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 0.9rem;
        }

        .alert-danger {
            background: #fee;
            border: 1px solid #f99;
            color: #c00;
        }

        .alert-success {
            background: #efe;
            border: 1px solid #9f9;
            color: #090;
        }

        .match-status {
            margin-top: 5px;
            font-size: 0.85rem;
            display: flex;
            align-items: center;
        }

        .match-status i {
            margin-right: 5px;
        }

        .match-yes {
            color: #28a745;
        }

        .match-no {
            color: #dc3545;
        }

        .footer-text {
            text-align: center;
            margin-top: 20px;
            color: #888;
            font-size: 0.85rem;
        }
    </style>
</head>
<body>
    <div class="reset-container">
        <div class="reset-card">
            <div class="reset-header">
                <i class="fas fa-lock"></i>
                <h2>Reset Password</h2>
                <p>Buat password baru</p>
            </div>

            <div class="reset-body">
                <?php if ($this->session->flashdata('error')): ?>
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-circle"></i> <?php echo $this->session->flashdata('error'); ?>
                    </div>
                <?php endif; ?>

                <div class="requirements">
                    <p><strong>Password harus memenuhi:</strong></p>
                    <ul>
                        <li id="req-length">
                            <i class="fas fa-circle"></i> Minimal 6 karakter
                        </li>
                        <li id="req-match">
                            <i class="fas fa-circle"></i> Password cocok
                        </li>
                    </ul>
                </div>

                <form action="<?php echo site_url('superadmin/forgot_password/process_reset'); ?>" method="POST" id="resetForm">
                    <input type="hidden" name="email" value="<?php echo $email; ?>">
                    
                    <div class="form-group">
                        <label class="form-label" for="password">Password Baru</label>
                        <div class="input-group">
                            <i class="fas fa-lock"></i>
                            <input type="password" name="password" id="password" class="form-control" 
                                   placeholder="Password baru" required
                                   minlength="6">
                            <button type="button" class="toggle-password" data-target="password">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                        <div class="password-strength">
                            <div class="strength-bar" id="strengthBar"></div>
                        </div>
                        <div id="passwordFeedback"></div>
                    </div>

                    <div class="form-group">
                        <label class="form-label" for="confirm_password">Konfirmasi Password</label>
                        <div class="input-group">
                            <i class="fas fa-lock"></i>
                            <input type="password" name="confirm_password" id="confirm_password" class="form-control" 
                                   placeholder="Ulangi password baru" required
                                   minlength="6">
                            <button type="button" class="toggle-password" data-target="confirm_password">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                        <div class="match-status" id="matchStatus">
                            <i class="fas fa-times"></i> Password tidak cocok
                        </div>
                    </div>

                    <button type="submit" class="btn-reset" id="resetBtn" disabled>
                        <i class="fas fa-sync-alt"></i> Reset Password
                    </button>
                    
                    <a href="<?php echo site_url('superadmin/forgot_password/cancel'); ?>" class="btn-cancel">
                        <i class="fas fa-times"></i> Batalkan
                    </a>
                </form>
                
                <div class="footer-text">
                    &copy; <?php echo date('Y'); ?> KosCare- Super Admin Panel
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const passwordInput = document.getElementById('password');
            const confirmInput = document.getElementById('confirm_password');
            const strengthBar = document.getElementById('strengthBar');
            const passwordFeedback = document.getElementById('passwordFeedback');
            const matchStatus = document.getElementById('matchStatus');
            const resetBtn = document.getElementById('resetBtn');
            const form = document.getElementById('resetForm');
            
            const reqLength = document.getElementById('req-length');
            const reqMatch = document.getElementById('req-match');
            
            // Toggle password visibility
            document.querySelectorAll('.toggle-password').forEach(button => {
                button.addEventListener('click', function() {
                    const targetId = this.getAttribute('data-target');
                    const input = document.getElementById(targetId);
                    const icon = this.querySelector('i');
                    
                    if (input.type === 'password') {
                        input.type = 'text';
                        icon.classList.remove('fa-eye');
                        icon.classList.add('fa-eye-slash');
                    } else {
                        input.type = 'password';
                        icon.classList.remove('fa-eye-slash');
                        icon.classList.add('fa-eye');
                    }
                });
            });
            
            // Check password strength
            function checkPasswordStrength(password) {
                let strength = 0;
                
                if (password.length >= 6) strength++;
                if (password.length >= 8) strength++;
                if (/[A-Z]/.test(password)) strength++;
                if (/[0-9]/.test(password)) strength++;
                if (/[^A-Za-z0-9]/.test(password)) strength++;
                
                return strength;
            }
            
            function updatePasswordRequirements(password, confirm) {
                // Check length
                const isLengthValid = password.length >= 6;
                reqLength.className = isLengthValid ? 'requirement-met' : 'requirement-not-met';
                reqLength.querySelector('i').className = isLengthValid ? 'fas fa-check-circle' : 'fas fa-times-circle';
                
                // Check match
                const isMatchValid = password === confirm && password.length > 0;
                reqMatch.className = isMatchValid ? 'requirement-met' : 'requirement-not-met';
                reqMatch.querySelector('i').className = isMatchValid ? 'fas fa-check-circle' : 'fas fa-times-circle';
                
                // Update strength bar
                const strength = checkPasswordStrength(password);
                const percentage = (strength / 5) * 100;
                
                strengthBar.style.width = percentage + '%';
                
                if (strength <= 1) {
                    strengthBar.style.background = '#dc3545';
                    passwordFeedback.textContent = 'Password lemah';
                    passwordFeedback.style.color = '#dc3545';
                } else if (strength <= 3) {
                    strengthBar.style.background = '#ffc107';
                    passwordFeedback.textContent = 'Password cukup';
                    passwordFeedback.style.color = '#ffc107';
                } else {
                    strengthBar.style.background = '#28a745';
                    passwordFeedback.textContent = 'Password kuat';
                    passwordFeedback.style.color = '#28a745';
                }
                
                // Update match status
                if (confirm.length === 0) {
                    matchStatus.style.display = 'none';
                } else {
                    matchStatus.style.display = 'flex';
                    if (password === confirm) {
                        matchStatus.innerHTML = '<i class="fas fa-check"></i> Password cocok';
                        matchStatus.className = 'match-status match-yes';
                    } else {
                        matchStatus.innerHTML = '<i class="fas fa-times"></i> Password tidak cocok';
                        matchStatus.className = 'match-status match-no';
                    }
                }
                
                // Enable/disable submit button
                resetBtn.disabled = !(isLengthValid && isMatchValid);
            }
            
            // Event listeners
            passwordInput.addEventListener('input', function() {
                updatePasswordRequirements(this.value, confirmInput.value);
            });
            
            confirmInput.addEventListener('input', function() {
                updatePasswordRequirements(passwordInput.value, this.value);
            });
            
            // Initial check
            updatePasswordRequirements('', '');
            
            // Form validation
            form.addEventListener('submit', function(e) {
                if (resetBtn.disabled) {
                    e.preventDefault();
                    alert('Pastikan semua requirement password terpenuhi');
                }
            });
        });
    </script>
</body>
</html>