<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kode OTP - Super Admin</title>
    <link rel="stylesheet" href="<?php echo site_url('asset/css/bootstrap.min.css'); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .otp-container {
            width: 100%;
            max-width: 500px;
            padding: 15px;
        }

        .otp-card {
            background: white;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
        }

        .otp-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 25px;
            text-align: center;
        }

        .otp-header i {
            font-size: 3rem;
            margin-bottom: 15px;
            display: block;
        }

        .otp-header h2 {
            font-weight: 600;
            font-size: 1.6rem;
            margin-bottom: 5px;
        }

        .otp-header p {
            opacity: 0.9;
            font-size: 0.9rem;
        }

        .otp-body {
            padding: 25px;
        }

        .email-info {
            background: #f0f8ff;
            border: 1px solid #b3d9ff;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
            text-align: center;
        }

        .email-info i {
            color: #667eea;
            margin-right: 10px;
        }

        .otp-display {
            text-align: center;
            margin: 25px 0;
        }

        .otp-code {
            font-size: 48px;
            font-weight: bold;
            color: #667eea;
            letter-spacing: 10px;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 10px;
            border: 2px dashed #667eea;
            margin: 15px 0;
            font-family: 'Courier New', monospace;
        }

        .otp-label {
            font-size: 14px;
            color: #666;
            margin-bottom: 10px;
        }

        .timer {
            text-align: center;
            margin: 15px 0;
            font-size: 16px;
            color: #666;
        }

        .timer span {
            font-weight: bold;
            color: #e74c3c;
            font-size: 18px;
        }

        .instructions {
            background: #f8f9fa;
            border-left: 4px solid #667eea;
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 0 8px 8px 0;
            font-size: 14px;
        }

        .instructions ul {
            padding-left: 20px;
            margin-bottom: 0;
        }

        .instructions li {
            margin-bottom: 5px;
        }

        .btn-container {
            display: flex;
            gap: 10px;
            margin-top: 20px;
        }

        .btn {
            flex: 1;
            padding: 14px;
            border-radius: 8px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            text-align: center;
            text-decoration: none;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            border: none;
        }

        .btn-verify {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }

        .btn-verify:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }

        .btn-resend {
            background: #17a2b8;
            color: white;
        }

        .btn-resend:hover {
            background: #138496;
            transform: translateY(-2px);
        }

        .btn-cancel {
            background: #6c757d;
            color: white;
        }

        .btn-cancel:hover {
            background: #5a6268;
            transform: translateY(-2px);
        }

        .warning-box {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            color: #856404;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .warning-box i {
            font-size: 18px;
        }

        .footer-text {
            text-align: center;
            margin-top: 20px;
            color: #888;
            font-size: 0.85rem;
        }

        @media (max-width: 576px) {
            .otp-code {
                font-size: 36px;
                letter-spacing: 8px;
                padding: 15px;
            }
            
            .btn-container {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <div class="otp-container">
        <div class="otp-card">
            <div class="otp-header">
                <i class="fas fa-key"></i>
                <h2>Kode OTP Anda</h2>
                <p>Gunakan kode ini untuk reset password</p>
            </div>

            <div class="otp-body">
                <div class="email-info">
                    <i class="fas fa-user-shield"></i>
                    <strong>Super Admin:</strong> <?php echo $email; ?>
                </div>

                <div class="warning-box">
                    <i class="fas fa-exclamation-triangle"></i>
                    <div>
                        <strong>Simpan kode ini!</strong> Kode hanya akan muncul sekali di halaman ini.
                        Copy dan paste kode di halaman verifikasi.
                    </div>
                </div>

                <div class="otp-display">
                    <div class="otp-label">Kode OTP 6 Digit:</div>
                    <div class="otp-code" id="otpCode"><?php echo $otp; ?></div>
                    
                    <div class="timer">
                        <i class="fas fa-clock"></i> Berlaku hingga: 
                        <span id="countdown">10:00</span>
                    </div>
                </div>

                <div class="instructions">
                    <p><strong>Langkah selanjutnya:</strong></p>
                    <ul>
                        <li>Salin kode OTP di atas: <strong><?php echo $otp; ?></strong></li>
                        <li>Klik tombol "Lanjut ke Verifikasi"</li>
                        <li>Tempelkan kode OTP di halaman verifikasi</li>
                        <li>Kode OTP berlaku 10 menit</li>
                    </ul>
                </div>

                <div class="btn-container">
                    <button class="btn btn-verify" id="copyBtn" onclick="copyOTP()">
                        <i class="far fa-copy"></i> Salin OTP
                    </button>
                    
                    <a href="<?php echo site_url('superadmin/forgot_password/verify'); ?>" class="btn btn-verify">
                        <i class="fas fa-arrow-right"></i> Lanjut ke Verifikasi
                    </a>
                </div>

                <div class="btn-container">
                    <a href="<?php echo site_url('superadmin/forgot_password/resend_code'); ?>" class="btn btn-resend">
                        <i class="fas fa-redo"></i> OTP Baru
                    </a>
                    
                    <a href="<?php echo site_url('superadmin/forgot_password/cancel'); ?>" class="btn btn-cancel">
                        <i class="fas fa-times"></i> Batalkan
                    </a>
                </div>
                
                <div class="footer-text">
                    &copy; <?php echo date('Y'); ?> KosCare- Super Admin Panel
                </div>
            </div>
        </div>
    </div>

    <script>
        // Timer countdown
        let timeLeft = 600; // 10 minutes in seconds
        const timerElement = document.getElementById('countdown');
        
        function updateTimer() {
            const minutes = Math.floor(timeLeft / 60);
            const seconds = timeLeft % 60;
            
            timerElement.textContent = `${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
            
            if (timeLeft <= 0) {
                clearInterval(timerInterval);
                timerElement.textContent = '00:00';
                timerElement.style.color = '#e74c3c';
                alert('Kode OTP telah kadaluarsa! Silakan minta kode baru.');
            } else {
                timeLeft--;
            }
        }
        
        const timerInterval = setInterval(updateTimer, 1000);
        
        // Copy OTP to clipboard
        function copyOTP() {
            const otpText = document.getElementById('otpCode').textContent;
            
            navigator.clipboard.writeText(otpText).then(() => {
                const copyBtn = document.getElementById('copyBtn');
                const originalHTML = copyBtn.innerHTML;
                
                copyBtn.innerHTML = '<i class="fas fa-check"></i> OTP Disalin!';
                copyBtn.style.background = '#28a745';
                
                setTimeout(() => {
                    copyBtn.innerHTML = originalHTML;
                    copyBtn.style.background = '';
                }, 2000);
            }).catch(err => {
                alert('Gagal menyalin OTP: ' + err);
            });
        }
        
        // Auto-copy on page load (optional)
        // setTimeout(copyOTP, 1000);
    </script>
</body>
</html>