<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verifikasi OTP - Super Admin</title>
    <link rel="stylesheet" href="<?php echo site_url('asset/css/bootstrap.min.css'); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .otp-container {
            width: 100%;
            max-width: 450px;
            padding: 15px;
        }

        .otp-card {
            background: white;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
        }

        .otp-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 25px;
            text-align: center;
        }

        .otp-header i {
            font-size: 3rem;
            margin-bottom: 15px;
            display: block;
        }

        .otp-header h2 {
            font-weight: 600;
            font-size: 1.6rem;
            margin-bottom: 5px;
        }

        .otp-header p {
            opacity: 0.9;
            font-size: 0.9rem;
        }

        .otp-body {
            padding: 25px;
        }

        .email-info {
            background: #f0f8ff;
            border: 1px solid #b3d9ff;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 15px;
            text-align: center;
        }

        .email-info i {
            color: #667eea;
            margin-right: 10px;
        }

        .instructions {
            background: #f8f9fa;
            border-left: 4px solid #667eea;
            padding: 12px;
            margin-bottom: 20px;
            border-radius: 0 8px 8px 0;
            font-size: 0.9em;
        }

        .instructions ul {
            padding-left: 20px;
            margin-bottom: 0;
        }

        .instructions li {
            margin-bottom: 3px;
            font-size: 0.9em;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            font-weight: 500;
            margin-bottom: 8px;
            color: #555;
            display: block;
            text-align: center;
        }

        .otp-input-group {
            display: flex;
            justify-content: center;
            gap: 10px;
            margin-bottom: 20px;
        }

        .otp-input {
            width: 50px;
            height: 60px;
            text-align: center;
            font-size: 24px;
            font-weight: bold;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            transition: all 0.3s;
        }

        .otp-input:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
            outline: none;
        }

        .btn-verify {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 14px;
            border-radius: 8px;
            font-size: 1rem;
            font-weight: 600;
            width: 100%;
            cursor: pointer;
            transition: all 0.3s;
            margin-top: 10px;
        }

        .btn-verify:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }

        .btn-resend {
            background: #17a2b8;
            color: white;
            border: none;
            padding: 12px;
            border-radius: 8px;
            font-size: 0.9rem;
            width: 100%;
            cursor: pointer;
            transition: all 0.3s;
            margin-top: 10px;
            text-decoration: none;
            display: inline-block;
            text-align: center;
        }

        .btn-resend:hover {
            background: #138496;
            transform: translateY(-2px);
        }

        .btn-cancel {
            background: #6c757d;
            color: white;
            border: none;
            padding: 12px;
            border-radius: 8px;
            font-size: 0.9rem;
            width: 100%;
            cursor: pointer;
            transition: all 0.3s;
            margin-top: 10px;
            text-decoration: none;
            display: inline-block;
            text-align: center;
        }

        .btn-cancel:hover {
            background: #5a6268;
            transform: translateY(-2px);
        }

        .alert {
            padding: 12px 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 0.9rem;
        }

        .alert-danger {
            background: #fee;
            border: 1px solid #f99;
            color: #c00;
        }

        .alert-success {
            background: #efe;
            border: 1px solid #9f9;
            color: #090;
        }

        .timer {
            text-align: center;
            margin: 15px 0;
            font-size: 0.9rem;
            color: #666;
        }

        .timer span {
            font-weight: bold;
            color: #e74c3c;
        }

        .hidden-input {
            position: absolute;
            opacity: 0;
            pointer-events: none;
        }

        .footer-text {
            text-align: center;
            margin-top: 20px;
            color: #888;
            font-size: 0.85rem;
        }

        @media (max-width: 576px) {
            .otp-input {
                width: 40px;
                height: 50px;
                font-size: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="otp-container">
        <div class="otp-card">
            <div class="otp-header">
                <i class="fas fa-shield-alt"></i>
                <h2>Verifikasi OTP</h2>
                <p>Masukkan kode 6 digit</p>
            </div>

            <div class="otp-body">
                <?php if ($this->session->flashdata('error')): ?>
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-circle"></i> <?php echo $this->session->flashdata('error'); ?>
                    </div>
                <?php endif; ?>

                <?php if ($this->session->flashdata('success')): ?>
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle"></i> <?php echo $this->session->flashdata('success'); ?>
                    </div>
                <?php endif; ?>

                <div class="email-info">
                    <i class="fas fa-user-shield"></i>
                    <strong>Super Admin:</strong> <?php echo $email; ?><br>
                    <small style="font-size: 0.9em; color: #666;">
                        <i class="fas fa-info-circle"></i> Masukkan kode OTP yang telah Anda lihat di halaman sebelumnya
                    </small>
                </div>

                <div class="instructions">
                    <p style="margin-bottom: 5px;"><i class="fas fa-lightbulb"></i> <strong>Petunjuk:</strong></p>
                    <ul>
                        <li>Masukkan 6 digit kode OTP yang muncul di layar sebelumnya</li>
                        <li>Kode OTP berlaku 10 menit</li>
                        <li>Jika kode hilang, klik "OTP Baru" untuk mendapatkan kode baru</li>
                    </ul>
                </div>

                <form action="<?php echo site_url('superadmin/forgot_password/verify_code'); ?>" method="POST" id="otpForm">
                    <div class="form-group">
                        <label class="form-label" for="otp">Kode OTP (6 digit)</label>
                        
                        <div class="otp-input-group">
                            <input type="text" class="otp-input" maxlength="1" data-index="1">
                            <input type="text" class="otp-input" maxlength="1" data-index="2">
                            <input type="text" class="otp-input" maxlength="1" data-index="3">
                            <input type="text" class="otp-input" maxlength="1" data-index="4">
                            <input type="text" class="otp-input" maxlength="1" data-index="5">
                            <input type="text" class="otp-input" maxlength="1" data-index="6">
                        </div>
                        
                        <!-- Hidden input untuk OTP lengkap -->
                        <input type="hidden" name="otp" id="fullOtp">
                        
                        <div class="timer" id="timer">
                            <i class="fas fa-clock"></i> Kode berlaku: <span id="countdown">10:00</span>
                        </div>
                    </div>

                    <button type="submit" class="btn-verify" id="verifyBtn">
                        <i class="fas fa-check"></i> Verifikasi OTP
                    </button>
                    
                    <a href="<?php echo site_url('superadmin/forgot_password/resend_code'); ?>" class="btn-resend" id="resendBtn">
                        <i class="fas fa-redo"></i> OTP Baru
                    </a>
                    
                    <a href="<?php echo site_url('superadmin/forgot_password/cancel'); ?>" class="btn-cancel">
                        <i class="fas fa-times"></i> Batalkan
                    </a>
                </form>
                
                <div class="footer-text">
                    &copy; <?php echo date('Y'); ?> KosCare- Super Admin Panel
                </div>
            </div>
        </div>
    </div>

    <script>
        // OTP Input Logic
        document.addEventListener('DOMContentLoaded', function() {
            const otpInputs = document.querySelectorAll('.otp-input');
            const fullOtpInput = document.getElementById('fullOtp');
            const form = document.getElementById('otpForm');
            
            // Focus first input
            if (otpInputs[0]) {
                otpInputs[0].focus();
            }
            
            // Handle input
            otpInputs.forEach((input, index) => {
                input.addEventListener('input', (e) => {
                    // Allow only numbers
                    e.target.value = e.target.value.replace(/[^0-9]/g, '');
                    
                    // Auto-focus next input
                    if (e.target.value.length === 1 && index < otpInputs.length - 1) {
                        otpInputs[index + 1].focus();
                    }
                    
                    updateFullOtp();
                });
                
                input.addEventListener('keydown', (e) => {
                    // Handle backspace
                    if (e.key === 'Backspace') {
                        if (e.target.value.length === 0 && index > 0) {
                            otpInputs[index - 1].focus();
                            otpInputs[index - 1].value = '';
                        }
                        setTimeout(() => updateFullOtp(), 0);
                    }
                    
                    // Handle arrow keys
                    if (e.key === 'ArrowLeft' && index > 0) {
                        otpInputs[index - 1].focus();
                    }
                    if (e.key === 'ArrowRight' && index < otpInputs.length - 1) {
                        otpInputs[index + 1].focus();
                    }
                });
            });
            
            function updateFullOtp() {
                let otp = '';
                otpInputs.forEach(input => {
                    otp += input.value;
                });
                fullOtpInput.value = otp;
                
                // Auto-submit jika 6 digit terisi
                if (otp.length === 6) {
                    setTimeout(() => {
                        form.submit();
                    }, 300);
                }
            }
            
            // Timer logic
            let timeLeft = 600; // 10 minutes in seconds
            const timerElement = document.getElementById('countdown');
            
            function updateTimer() {
                const minutes = Math.floor(timeLeft / 60);
                const seconds = timeLeft % 60;
                
                if (timerElement) {
                    timerElement.textContent = `${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
                    
                    if (timeLeft <= 0) {
                        clearInterval(timerInterval);
                        timerElement.textContent = '00:00';
                        timerElement.style.color = '#e74c3c';
                        
                        // Disable verify button
                        const verifyBtn = document.getElementById('verifyBtn');
                        if (verifyBtn) {
                            verifyBtn.disabled = true;
                            verifyBtn.style.opacity = '0.6';
                            verifyBtn.style.cursor = 'not-allowed';
                        }
                        
                        alert('Kode OTP telah kadaluarsa! Silakan klik "OTP Baru" untuk mendapatkan kode baru.');
                    } else {
                        timeLeft--;
                    }
                }
            }
            
            // Start timer if element exists
            if (timerElement) {
                const timerInterval = setInterval(updateTimer, 1000);
            }
            
            // Form validation
            form.addEventListener('submit', function(e) {
                if (fullOtpInput.value.length !== 6) {
                    e.preventDefault();
                    alert('Masukkan 6 digit kode OTP lengkap');
                    if (otpInputs[0]) {
                        otpInputs[0].focus();
                    }
                }
            });
            
            // Paste OTP from clipboard
            document.addEventListener('paste', function(e) {
                const pastedData = e.clipboardData.getData('text');
                if (pastedData.length === 6 && /^\d+$/.test(pastedData)) {
                    e.preventDefault();
                    
                    // Fill OTP inputs
                    for (let i = 0; i < 6; i++) {
                        if (otpInputs[i]) {
                            otpInputs[i].value = pastedData[i];
                        }
                    }
                    
                    updateFullOtp();
                    
                    // Focus last input
                    if (otpInputs[5]) {
                        otpInputs[5].focus();
                    }
                }
            });
        });
    </script>
</body>
</html>