<!doctype html>
<html>

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?php echo isset($title) ? $title : 'Form Kos'; ?></title>
  <link rel="stylesheet" href="<?php echo site_url('asset/css/bootstrap.min.css'); ?>">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: #f0f8ff;
      color: #333;
    }

    .topbar {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      padding: 15px 0;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      z-index: 1030;
    }

    .topbar h4 {
      color: white;
      font-weight: 600;
      font-size: 1.3rem;
    }

    .topbar a {
      color: white;
      text-decoration: none;
      transition: opacity 0.3s;
    }

    .topbar a:hover {
      opacity: 0.8;
    }

    .topbar .user-info {
      color: white;
      font-size: 0.95rem;
    }

    .sidebar {
      background: white;
      min-height: calc(100vh - 60px);
      padding: 25px 15px;
      box-shadow: 2px 0 10px rgba(0, 0, 0, 0.05);
      position: fixed;
      top: 60px;
      left: 0;
      width: 16.666667%;
      height: calc(100vh - 60px);
      overflow-y: auto;
      z-index: 1020;
    }

    .sidebar h5 {
      color: #667eea;
      margin-bottom: 20px;
      font-weight: 600;
      padding-bottom: 10px;
      border-bottom: 2px solid #e8eaf6;
    }

    .sidebar ul {
      list-style: none;
    }

    .sidebar ul li {
      margin-bottom: 8px;
    }

    .sidebar ul li a {
      display: block;
      padding: 12px 15px;
      color: #555;
      text-decoration: none;
      border-radius: 8px;
      transition: all 0.3s;
      font-size: 0.95rem;
    }

    .sidebar ul li a:hover,
    .sidebar ul li a.active {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      transform: translateX(5px);
    }

    .sidebar ul li a i {
      width: 20px;
      margin-right: 10px;
    }

    .main-content {
      margin-left: 16.666667%;
      margin-top: 60px;
      padding: 25px;
      background: #f0f8ff;
      min-height: calc(100vh - 60px);
    }

    .page-header {
      background: white;
      border-radius: 12px;
      padding: 25px;
      margin-bottom: 25px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
      display: flex;
      justify-content: space-between;
      align-items: center;
      flex-wrap: wrap;
      gap: 15px;
    }

    .page-header h3 {
      color: #667eea;
      font-weight: 600;
      margin: 0;
    }

    .btn-back {
      background: white;
      border: 2px solid #6c757d;
      color: #6c757d;
      padding: 10px 20px;
      border-radius: 8px;
      text-decoration: none;
      transition: all 0.3s;
      font-size: 0.9rem;
      font-weight: 500;
      display: inline-flex;
      align-items: center;
      gap: 8px;
    }

    .btn-back:hover {
      background: #6c757d;
      color: white;
      transform: translateY(-2px);
    }

    .form-card {
      background: white;
      border-radius: 12px;
      padding: 30px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
      max-width: 800px;
      margin: 0 auto;
    }

    .form-group {
      margin-bottom: 25px;
    }

    .form-group label {
      display: block;
      font-weight: 600;
      color: #555;
      margin-bottom: 8px;
      font-size: 0.95rem;
    }

    .form-group label i {
      margin-right: 8px;
      color: #667eea;
    }

    .form-control {
      width: 100%;
      padding: 12px 15px;
      border: 2px solid #e9ecef;
      border-radius: 8px;
      font-size: 0.95rem;
      transition: all 0.3s;
      background: #f8f9fa;
    }

    .form-control:focus {
      outline: none;
      border-color: #667eea;
      background: white;
      box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .form-control:hover {
      border-color: #667eea;
    }

    textarea.form-control {
      min-height: 100px;
      resize: vertical;
    }

    select.form-control {
      cursor: pointer;
      appearance: none;
      background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' viewBox='0 0 12 12'%3E%3Cpath fill='%23667eea' d='M6 9L1 4h10z'/%3E%3C/svg%3E");
      background-repeat: no-repeat;
      background-position: right 15px center;
      padding-right: 40px;
    }

    .form-actions {
      display: flex;
      gap: 15px;
      margin-top: 30px;
      padding-top: 20px;
      border-top: 2px solid #f0f0f0;
    }

    .btn-submit {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border: none;
      padding: 12px 30px;
      border-radius: 8px;
      font-size: 1rem;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.3s;
      display: inline-flex;
      align-items: center;
      gap: 10px;
    }

    .btn-submit:hover {
      transform: translateY(-2px);
      box-shadow: 0 6px 20px rgba(102, 126, 234, 0.3);
    }

    .btn-reset {
      background: white;
      color: #dc3545;
      border: 2px solid #dc3545;
      padding: 12px 30px;
      border-radius: 8px;
      font-size: 1rem;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.3s;
      display: inline-flex;
      align-items: center;
      gap: 10px;
    }

    .btn-reset:hover {
      background: #dc3545;
      color: white;
      transform: translateY(-2px);
    }

    .required {
      color: #dc3545;
      margin-left: 3px;
    }

    .help-text {
      font-size: 0.85rem;
      color: #888;
      margin-top: 5px;
      display: block;
    }

    @media (max-width: 768px) {
      .sidebar {
        position: relative;
        width: 100%;
        height: auto;
        min-height: auto;
        top: 0;
      }

      .main-content {
        margin-left: 0;
        padding: 15px;
      }

      .form-card {
        padding: 20px;
      }

      .page-header {
        flex-direction: column;
        align-items: flex-start;
      }

      .form-actions {
        flex-direction: column;
      }

      .btn-submit,
      .btn-reset {
        width: 100%;
        justify-content: center;
      }
    }

    .sidebar::-webkit-scrollbar {
      width: 6px;
    }

    .sidebar::-webkit-scrollbar-track {
      background: #f1f1f1;
    }

    .sidebar::-webkit-scrollbar-thumb {
      background: #667eea;
      border-radius: 3px;
    }

    .sidebar::-webkit-scrollbar-thumb:hover {
      background: #764ba2;
    }
  </style>
</head>

<body>
  <div class="topbar">
    <div class="container-fluid">
      <div class="d-flex justify-content-between align-items-center">
        <div class="login-icon">
          <img src="<?= base_url('asset/logo 2.png'); ?>" alt="Logo KosCare" style="width: 50px; height: auto;"><span>KosCare - Super Admin</span>
        </div>
        <div class="user-info">
          <i class="fas fa-user-shield"></i> Halo, <strong><?php echo $this->session->userdata('super_admin_name'); ?></strong> |
          <a href="<?php echo site_url('superadmin/logout'); ?>"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>
      </div>
    </div>
  </div>

  <div class="sidebar" id="sidebar">
    <h5><i class="fas fa-bars"></i> Menu</h5>
    <ul>
      <li><a href="<?php echo site_url('superadmin/superadmin/dashboard'); ?>"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
      <li><a href="<?php echo site_url('superadmin/superadmin/admin_list'); ?>"><i class="fas fa-user-tie"></i> Kelola Admin</a></li>
      <li><a href="<?php echo site_url('superadmin/superadmin/kos_list'); ?>" class="active"><i class="fas fa-building"></i> Kelola Kos</a></li>
    </ul>
  </div>

  <div class="main-content">
    <div class="page-header">
      <h3><i class="fas fa-edit"></i> <?php echo $title; ?></h3>
      <a href="<?php echo site_url('superadmin/superadmin/kos_list'); ?>" class="btn-back">
        <i class="fas fa-arrow-left"></i> Kembali
      </a>
    </div>

    <div class="form-card">
      <form method="post" action="<?php echo site_url('superadmin/superadmin/save_kos'); ?>">
        <input type="hidden" name="id_kos" value="<?php echo isset($kos) ? $kos->id_kos : ''; ?>">

        <div class="form-group">
          <label>
            <i class="fas fa-user-tie"></i> Admin Pengelola <span class="required">*</span>
          </label>
          <select name="id_admin" class="form-control" required>
            <option value="">-- Pilih Admin Pengelola --</option>
            <?php foreach ($admins as $a): ?>
              <option value="<?php echo $a->id; ?>" <?php echo isset($kos) && $kos->id_admin == $a->id ? 'selected' : ''; ?>>
                <?php echo $a->nama; ?>
              </option>
            <?php endforeach; ?>
          </select>
          <small class="help-text">Pilih admin yang akan mengelola kos ini</small>
        </div>

        <div class="form-group">
          <label>
            <i class="fas fa-building"></i> Nama Kos <span class="required">*</span>
          </label>
          <input type="text" name="nama_kos" class="form-control"
            value="<?php echo isset($kos) ? $kos->nama_kos : ''; ?>"
            placeholder="Contoh: Kos Melati" required>
          <small class="help-text">Masukkan nama kos yang mudah diingat</small>
        </div>

        <div class="form-group">
          <label>
            <i class="fas fa-map-marker-alt"></i> Alamat <span class="required">*</span>
          </label>
          <textarea name="alamat" class="form-control"
            placeholder="Contoh: Jl. Sudirman No. 123, Semarang" required><?php echo isset($kos) ? $kos->alamat : ''; ?></textarea>
          <small class="help-text">Alamat lengkap lokasi kos</small>
        </div>

        <div class="form-group">
          <label>
            <i class="fas fa-door-open"></i> Jumlah Kamar
          </label>
          <input type="number" name="jumlah_kamar" class="form-control"
            value="<?php echo isset($kos) ? $kos->jumlah_kamar : ''; ?>"
            placeholder="Contoh: 10" min="0">
          <small class="help-text">Total jumlah kamar yang tersedia</small>
        </div>

        <div class="form-group">
          <label>
            <i class="fas fa-align-left"></i> Deskripsi
          </label>
          <textarea name="deskripsi" class="form-control"
            placeholder="Contoh: Kos nyaman dengan fasilitas lengkap..."><?php echo isset($kos) ? $kos->deskripsi : ''; ?></textarea>
          <small class="help-text">Deskripsi singkat tentang kos (opsional)</small>
        </div>

        <div class="form-group">
          <label>
            <i class="fas fa-toggle-on"></i> Status <span class="required">*</span>
          </label>
          <select name="status" class="form-control">
            <option value="Aktif" <?php echo isset($kos) && $kos->status == 'Aktif' ? 'selected' : ''; ?>>
              Aktif
            </option>
            <option value="Nonaktif" <?php echo isset($kos) && $kos->status == 'Nonaktif' ? 'selected' : ''; ?>>
              Nonaktif
            </option>
          </select>
          <small class="help-text">Status operasional kos</small>
        </div>

        <div class="form-actions">
          <button type="submit" class="btn-submit">
            <i class="fas fa-save"></i> Simpan Data
          </button>
          <button type="reset" class="btn-reset">
            <i class="fas fa-redo"></i> Reset Form
          </button>
        </div>
      </form>
    </div>
  </div>

  <script src="<?php echo site_url('asset/js/jquery-3.6.0.min.js'); ?>"></script>
  <script src="<?php echo site_url('asset/js/bootstrap.bundle.min.js'); ?>"></script>

  <script>
    // Active menu highlight
    const currentPath = window.location.pathname;
    document.querySelectorAll('.sidebar a').forEach(link => {
      const href = link.getAttribute('href');
      if (currentPath.includes(href) && href !== '<?php echo site_url('superadmin/dashboard'); ?>') {
        document.querySelectorAll('.sidebar a').forEach(l => l.classList.remove('active'));
        link.classList.add('active');
      }
    });

    // Form validation feedback
    document.querySelector('form').addEventListener('submit', function(e) {
      const requiredFields = this.querySelectorAll('[required]');
      let isValid = true;

      requiredFields.forEach(field => {
        if (!field.value.trim()) {
          isValid = false;
          field.style.borderColor = '#dc3545';
        } else {
          field.style.borderColor = '#e9ecef';
        }
      });

      if (!isValid) {
        e.preventDefault();
        alert('Mohon lengkapi semua field yang wajib diisi (*)');
      }
    });
  </script>
</body>

</html>