<?php
// Determine active menu based on current URL
$current_url = uri_string(); // Get current URI segment
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?php echo isset($title) ? $title : 'Detail Laporan'; ?> - SistemKOS</title>
  <link rel="stylesheet" href="<?php echo site_url('asset/css/bootstrap.min.css'); ?>">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: #f0f8ff;
      color: #333;
    }

    /* TOPBAR IMPROVED - SAME AS SUPER ADMIN */
    .topbar {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      padding: 12px 0;
      box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      z-index: 1030;
      height: 60px;
    }

    .topbar-container {
      display: flex;
      justify-content: space-between;
      align-items: center;
      height: 100%;
      padding: 0 15px;
    }

    .brand-section {
      display: flex;
      align-items: center;
      gap: 15px;
      flex-shrink: 0;
    }

    .brand-logo {
      width: 50px;
      height: auto;
      transition: transform 0.3s;
    }

    .brand-logo:hover {
      transform: scale(1.05);
    }

    .brand-text {
      color: white;
    }

    .brand-text h4 {
      font-weight: 600;
      font-size: 1.3rem;
      margin: 0;
      line-height: 1.2;
    }

    .brand-text span {
      font-size: 0.9rem;
      opacity: 0.9;
      display: block;
      margin-top: 2px;
    }

    .user-section {
      display: flex;
      align-items: center;
      gap: 15px;
      flex-shrink: 0;
    }

    .user-info {
      display: flex;
      align-items: center;
      gap: 8px;
      color: white;
      font-size: 0.95rem;
      padding: 6px 12px;
      border-radius: 6px;
      transition: background 0.3s;
    }

    .user-info:hover {
      background: rgba(255, 255, 255, 0.1);
    }

    .user-info i {
      font-size: 1.2rem;
    }

    .logout-btn {
      display: flex;
      align-items: center;
      gap: 8px;
      color: white;
      text-decoration: none;
      padding: 8px 16px;
      border-radius: 6px;
      background: rgba(255, 255, 255, 0.15);
      transition: all 0.3s;
      font-size: 0.9rem;
      font-weight: 500;
    }

    .logout-btn:hover {
      background: rgba(255, 255, 255, 0.25);
      transform: translateY(-1px);
      color: white;
    }

    /* SIDEBAR STYLES */
    .sidebar {
      background: white;
      min-height: calc(100vh - 60px);
      padding: 25px 15px;
      box-shadow: 2px 0 10px rgba(0, 0, 0, 0.05);
      position: fixed;
      top: 60px;
      left: 0;
      width: 16.666667%;
      height: calc(100vh - 60px);
      overflow-y: auto;
      z-index: 1020;
    }

    .sidebar h5 {
      color: #667eea;
      margin-bottom: 20px;
      font-weight: 600;
      padding-bottom: 10px;
      border-bottom: 2px solid #e8eaf6;
    }

    .sidebar ul {
      list-style: none;
    }

    .sidebar ul li {
      margin-bottom: 8px;
    }

    .sidebar ul li a {
      display: block;
      padding: 12px 15px;
      color: #555;
      text-decoration: none;
      border-radius: 8px;
      transition: all 0.3s;
      font-size: 0.95rem;
      position: relative;
      overflow: hidden;
    }

    .sidebar ul li a:hover {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      transform: translateX(5px);
    }

    .sidebar ul li a.active {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      transform: translateX(5px);
      box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
    }

    .sidebar ul li a.active:before {
      content: '';
      position: absolute;
      left: 0;
      top: 0;
      height: 100%;
      width: 4px;
      background: white;
      border-radius: 0 4px 4px 0;
    }

    .sidebar ul li a i {
      width: 20px;
      margin-right: 10px;
    }

    /* MAIN CONTENT */
    .main-content {
      margin-left: 16.666667%;
      margin-top: 60px;
      padding: 25px;
      background: #f0f8ff;
      min-height: calc(100vh - 60px);
    }

    .page-header {
      background: white;
      border-radius: 12px;
      padding: 20px 25px;
      margin-bottom: 25px;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
      display: flex;
      justify-content: space-between;
      align-items: center;
      flex-wrap: wrap;
      gap: 15px;
    }

    .page-header h3 {
      color: #667eea;
      font-weight: 600;
      margin: 0;
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .btn-back {
      background: white;
      border: 2px solid #6c757d;
      color: #6c757d;
      padding: 10px 20px;
      border-radius: 8px;
      text-decoration: none;
      transition: all 0.3s;
      font-size: 0.9rem;
      font-weight: 500;
      display: inline-flex;
      align-items: center;
      gap: 8px;
    }

    .btn-back:hover {
      background: #6c757d;
      color: white;
      transform: translateY(-2px);
    }
    
    .detail-card {
      background: white;
      border-radius: 12px;
      padding: 30px;
      margin-bottom: 25px;
      box-shadow: 0 4px 15px rgba(0,0,0,0.08);
    }
    
    .detail-card h4 {
      color: #667eea;
      margin-bottom: 25px;
      font-weight: 600;
      padding-bottom: 15px;
      border-bottom: 2px solid #e8eaf6;
    }
    
    .info-row {
      display: flex;
      margin-bottom: 20px;
      padding-bottom: 20px;
      border-bottom: 1px solid #e8eaf6;
    }
    
    .info-label {
      width: 200px;
      font-weight: 600;
      color: #555;
      font-size: 0.95rem;
    }
    
    .info-value {
      flex: 1;
      color: #333;
    }
    
    .deskripsi-box {
      background: #f8f9ff;
      padding: 20px;
      border-radius: 8px;
      margin-top: 10px;
      border-left: 4px solid #667eea;
      line-height: 1.6;
    }
    
    .action-form {
      background: white;
      padding: 30px;
      border-radius: 12px;
      margin-top: 25px;
      box-shadow: 0 4px 15px rgba(0,0,0,0.08);
    }
    
    .action-form h4 {
      color: #667eea;
      margin-bottom: 25px;
      font-weight: 600;
      padding-bottom: 15px;
      border-bottom: 2px solid #e8eaf6;
    }
    
    .form-group {
      margin-bottom: 25px;
    }
    
    .form-label {
      font-weight: 500;
      margin-bottom: 8px;
      display: block;
      color: #555;
      font-size: 0.95rem;
    }
    
    .form-control, .form-select {
      padding: 12px 15px;
      border: 2px solid #e9ecef;
      border-radius: 8px;
      width: 100%;
      font-size: 0.95rem;
      transition: all 0.3s;
    }
    
    .form-control:focus, .form-select:focus {
      border-color: #667eea;
      box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
    }
    
    textarea.form-control {
      min-height: 100px;
      resize: vertical;
    }
    
    .btn-primary-custom {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      border: none;
      color: white;
      padding: 12px 30px;
      border-radius: 8px;
      text-decoration: none;
      transition: all 0.3s;
      font-size: 0.95rem;
      font-weight: 500;
      display: inline-flex;
      align-items: center;
      gap: 8px;
    }

    .btn-primary-custom:hover {
      transform: translateY(-2px);
      box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
      color: white;
    }

    .status-badge {
      display: inline-block;
      padding: 6px 14px;
      border-radius: 20px;
      font-size: 0.85rem;
      font-weight: 500;
    }
    
    .status-pending {
      background: #fff3cd;
      color: #856404;
    }
    
    .status-diproses {
      background: #cce5ff;
      color: #004085;
    }
    
    .status-diterima {
      background: #d4edda;
      color: #155724;
    }
    
    .status-ditolak {
      background: #f8d7da;
      color: #721c24;
    }

    /* RESPONSIVE DESIGN */
    @media (max-width: 992px) {
      .sidebar {
        width: 25%;
      }

      .main-content {
        margin-left: 25%;
      }
    }

    @media (max-width: 768px) {
      .sidebar {
        position: relative;
        width: 100%;
        height: auto;
        min-height: auto;
        top: 0;
      }

      .main-content {
        margin-left: 0;
        margin-top: 0;
        padding: 15px;
      }

      .topbar {
        height: auto;
        padding: 10px 0;
      }

      .topbar-container {
        flex-direction: column;
        gap: 10px;
        height: auto;
      }

      .brand-section,
      .user-section {
        width: 100%;
        justify-content: center;
      }

      .page-header {
        flex-direction: column;
        align-items: flex-start;
      }

      .detail-card,
      .action-form {
        padding: 20px;
      }

      .info-row {
        flex-direction: column;
        gap: 10px;
      }
      
      .info-label {
        width: 100%;
      }
      
      .brand-text h4 {
        font-size: 1.1rem;
      }

      .brand-text span {
        font-size: 0.8rem;
      }

      .user-info,
      .logout-btn {
        font-size: 0.85rem;
      }
    }

    @media (max-width: 576px) {
      .btn-primary-custom {
        padding: 10px 20px;
        font-size: 0.9rem;
        width: 100%;
        justify-content: center;
      }
      
      .btn-back {
        width: 100%;
        justify-content: center;
      }
    }

    .sidebar::-webkit-scrollbar {
      width: 6px;
    }

    .sidebar::-webkit-scrollbar-track {
      background: #f1f1f1;
    }

    .sidebar::-webkit-scrollbar-thumb {
      background: #667eea;
      border-radius: 3px;
    }

    .sidebar::-webkit-scrollbar-thumb:hover {
      background: #764ba2;
    }
  </style>
</head>
<body>
  <!-- TOPBAR IMPROVED -->
  <div class="topbar">
    <div class="container-fluid">
      <div class="topbar-container">
        <!-- Brand Section (Left) -->
        <div class="brand-section">
          <img src="<?= base_url('asset/logo 2.png'); ?>" alt="Logo KosCare" class="brand-logo">
          <div class="brand-text">
            <h4>KosCare</h4>
            <span>Super Admin Dashboard</span>
          </div>
        </div>

        <!-- User Section (Right) -->
        <div class="user-section">
          <div class="user-info">
            <i class="fas fa-user-shield"></i>
            <div>
              <span>Halo, <strong><?php echo $this->session->userdata('super_admin_name'); ?></strong></span>
            </div>
          </div>
          <a href="<?php echo site_url('superadmin/superadmin/logout'); ?>" class="logout-btn">
            <i class="fas fa-sign-out-alt"></i> Logout
          </a>
        </div>
      </div>
    </div>
  </div>

  <!-- SIDEBAR -->
  <div class="sidebar" id="sidebar">
    <h5><i class="fas fa-bars"></i> Menu</h5>
    <ul>
      <li><a href="<?php echo site_url('superadmin/superadmin/dashboard'); ?>" class="<?= strpos($current_url, 'dashboard') !== false ? 'active' : '' ?>"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
      <li><a href="<?php echo site_url('superadmin/superadmin/admin_list'); ?>" class="<?= (strpos($current_url, 'admin_list') !== false || strpos($current_url, 'admin_form') !== false) ? 'active' : '' ?>"><i class="fas fa-user-tie"></i> Kelola Admin</a></li>
      <li><a href="<?php echo site_url('superadmin/superadmin/kos_list'); ?>" class="<?= (strpos($current_url, 'kos_list') !== false || strpos($current_url, 'kos_form') !== false) ? 'active' : '' ?>"><i class="fas fa-building"></i> Kelola Kos</a></li>
      <li><a href="<?php echo site_url('superadmin/superadmin/report_list'); ?>" class="<?= strpos($current_url, 'report_list') !== false || strpos($current_url, 'report_detail') !== false ? 'active' : '' ?>">
        <i class="fas fa-flag"></i> Laporan Admin
      </a></li>
    </ul>
  </div>
  
  <div class="main-content">
    <div class="page-header">
      <h3><i class="fas fa-flag"></i> <?php echo isset($title) ? $title : 'Detail Laporan'; ?></h3>
      <div class="actions">
        <a href="<?php echo site_url('superadmin/superadmin/report_list'); ?>" class="btn-back">
          <i class="fas fa-arrow-left"></i> Kembali ke Daftar
        </a>
      </div>
    </div>
    
    <?php if (isset($error)): ?>
      <div class="alert alert-danger" style="background: #f8d7da; color: #721c24; padding: 15px; border-radius: 8px; border-left: 4px solid #dc3545; margin-bottom: 25px;">
        <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
      </div>
    <?php endif; ?>
    
    <?php if ($this->session->flashdata('success')): ?>
      <div class="alert alert-success" style="background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; border-left: 4px solid #28a745; margin-bottom: 25px;">
        <i class="fas fa-check-circle"></i> <?= $this->session->flashdata('success') ?>
      </div>
    <?php endif; ?>
    
    <?php if ($this->session->flashdata('error')): ?>
      <div class="alert alert-danger" style="background: #f8d7da; color: #721c24; padding: 15px; border-radius: 8px; border-left: 4px solid #dc3545; margin-bottom: 25px;">
        <i class="fas fa-exclamation-circle"></i> <?= $this->session->flashdata('error') ?>
      </div>
    <?php endif; ?>
    
    <div class="detail-card">
      <h4><i class="fas fa-info-circle"></i> Detail Laporan</h4>
      
      <div class="info-row">
        <div class="info-label">Pelapor:</div>
        <div class="info-value">
          <strong><?php echo isset($report->nama_penghuni) ? $report->nama_penghuni : 'Tidak Diketahui'; ?></strong><br>
          <small><?php echo isset($report->penghuni_email) ? $report->penghuni_email : '-'; ?></small>
        </div>
      </div>
      
      <div class="info-row">
        <div class="info-label">Admin Dilaporkan:</div>
        <div class="info-value">
          <strong><?php echo isset($report->admin_nama) ? $report->admin_nama : 'Tidak Diketahui'; ?></strong><br>
          <small><?php echo isset($report->admin_email) ? $report->admin_email : '-'; ?></small>
        </div>
      </div>
      
      <div class="info-row">
        <div class="info-label">Judul Laporan:</div>
        <div class="info-value"><?php echo isset($report->judul) ? htmlspecialchars($report->judul) : 'Tidak ada judul'; ?></div>
      </div>
      
      <div class="info-row">
        <div class="info-label">Deskripsi:</div>
        <div class="info-value">
          <div class="deskripsi-box">
            <?php echo isset($report->deskripsi) ? nl2br(htmlspecialchars($report->deskripsi)) : 'Tidak ada deskripsi'; ?>
          </div>
        </div>
      </div>
      
      <div class="info-row">
        <div class="info-label">Status:</div>
        <div class="info-value">
          <?php if(isset($report->status)): ?>
            <?php if($report->status == 'pending'): ?>
              <span class="status-badge status-pending">Pending</span>
            <?php elseif($report->status == 'diproses'): ?>
              <span class="status-badge status-diproses">Diproses</span>
            <?php elseif($report->status == 'diterima'): ?>
              <span class="status-badge status-diterima">Diterima</span>
            <?php else: ?>
              <span class="status-badge status-ditolak">Ditolak</span>
            <?php endif; ?>
          <?php else: ?>
            <span class="status-badge status-pending">Tidak Diketahui</span>
          <?php endif; ?>
        </div>
      </div>
      
      <div class="info-row">
        <div class="info-label">Tanggal Laporan:</div>
        <div class="info-value">
          <i class="far fa-calendar-alt"></i>
          <?php echo isset($report->created_at) ? date('d M Y H:i', strtotime($report->created_at)) : '-'; ?>
        </div>
      </div>
      
      <?php if(isset($report->tindakan) && $report->tindakan != 'none'): ?>
      <div class="info-row">
        <div class="info-label">Tindakan:</div>
        <div class="info-value">
          <strong><?php echo isset($report->tindakan) ? ucfirst(str_replace('_', ' ', $report->tindakan)) : 'Tidak ada'; ?></strong>
          <?php if(isset($report->durasi_nonaktif) && $report->durasi_nonaktif): ?>
            <br><small>Durasi: <?php echo $report->durasi_nonaktif; ?> hari</small>
          <?php endif; ?>
          <?php if(isset($report->tanggal_aktif_kembali) && $report->tanggal_aktif_kembali): ?>
            <br><small>Aktif kembali: <?php echo date('d M Y H:i', strtotime($report->tanggal_aktif_kembali)); ?></small>
          <?php endif; ?>
        </div>
      </div>
      <?php endif; ?>
    </div>
    
    <?php if(isset($report->status) && $report->status == 'pending'): ?>
    <div class="action-form">
      <h4><i class="fas fa-cogs"></i> Ambil Tindakan</h4>
      <form action="<?php echo site_url('superadmin/superadmin/process_report'); ?>" method="post">
        <input type="hidden" name="id_report" value="<?php echo isset($report->id_report) ? $report->id_report : ''; ?>">
        
        <div class="form-group">
          <label class="form-label">Pilih Tindakan:</label>
          <select name="action" id="action" class="form-select" required onchange="toggleDuration()">
            <option value="">-- Pilih Tindakan --</option>
            <option value="peringatan">Beri Peringatan</option>
            <option value="nonaktif_sementara">Nonaktifkan Sementara</option>
            <option value="nonaktif_permanen">Nonaktifkan Permanen</option>
          </select>
        </div>
        
        <div class="form-group" id="durationField" style="display: none;">
          <label class="form-label">Durasi Nonaktif (hari):</label>
          <input type="number" name="duration" class="form-control" min="1" max="365" placeholder="Masukkan jumlah hari (1-365)">
          <small style="color: #888; font-size: 0.85rem; margin-top: 5px; display: block;">Admin akan dinonaktifkan sementara untuk jangka waktu yang ditentukan</small>
        </div>
        
        <div class="form-group">
          <label class="form-label">Catatan Tindakan:</label>
          <textarea name="notes" class="form-control" rows="4" placeholder="Tambahkan catatan atau alasan tindakan yang diambil..."></textarea>
        </div>
        
        <button type="submit" class="btn-primary-custom" onclick="return confirm('Yakin ingin memproses laporan ini? Tindakan ini tidak dapat dibatalkan.')">
          <i class="fas fa-check-circle"></i> Proses Laporan
        </button>
      </form>
    </div>
    
    <script>
      function toggleDuration() {
        var action = document.getElementById('action').value;
        var durationField = document.getElementById('durationField');
        
        if (action === 'nonaktif_sementara') {
          durationField.style.display = 'block';
        } else {
          durationField.style.display = 'none';
        }
      }
      
      // Add hover effects to logout button
      document.addEventListener('DOMContentLoaded', function() {
        const logoutBtn = document.querySelector('.logout-btn');
        if (logoutBtn) {
          logoutBtn.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-1px) scale(1.02)';
          });
          logoutBtn.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0) scale(1)';
          });
        }
        
        // Auto hide alerts after 5 seconds
        const alerts = document.querySelectorAll('.alert');
        alerts.forEach(alert => {
          setTimeout(() => {
            alert.style.opacity = '0';
            alert.style.transition = 'opacity 0.5s';
            setTimeout(() => {
              alert.style.display = 'none';
            }, 500);
          }, 5000);
        });
      });
    </script>
    <?php endif; ?>
  </div>

  <script src="<?php echo site_url('asset/js/jquery-3.6.0.min.js'); ?>"></script>
  <script src="<?php echo site_url('asset/js/bootstrap.bundle.min.js'); ?>"></script>
</body>
</html>