<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title><?= $title ?> - KosCare</title>
    <link rel="stylesheet" href="<?= base_url('asset/css/bootstrap.min.css') ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        :root {
            --primary: #4a90e2;
            --primary-dark: #357abd;
            --secondary: #64748b;
            --success: #28a745;
            --warning: #ffc107;
            --danger: #dc3545;
            --light: #f8fafc;
            --dark: #0f172a;
            --border: #e2e8f0;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f0f8ff;
            color: var(--dark);
            line-height: 1.6;
        }

        /* Topbar */
        .topbar {
            background: white;
            padding: 16px 0;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1030;
            border-bottom: 1px solid var(--border);
        }

        .topbar-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 24px;
        }

        .brand {
            display: flex;
            align-items: center;
            gap: 12px;
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--primary);
        }

        .brand i {
            font-size: 1.5rem;
        }

        .user-menu {
            display: flex;
            align-items: center;
            gap: 16px;
        }

        .user-info-badge {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 8px 16px;
            background: var(--light);
            border-radius: 8px;
            font-size: 0.9rem;
        }

        .user-avatar {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: var(--primary);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
        }

        .logout-btn {
            padding: 8px 16px;
            background: var(--danger);
            color: white;
            border: none;
            border-radius: 8px;
            text-decoration: none;
            transition: all 0.2s;
            font-size: 0.9rem;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .logout-btn:hover {
            background: #dc2626;
            color: white;
            transform: translateY(-1px);
        }

        /* Sidebar */
        .sidebar {
            background: white;
            width: 260px;
            height: calc(100vh - 65px);
            position: fixed;
            top: 65px;
            left: 0;
            padding: 24px 0;
            box-shadow: 1px 0 3px rgba(0, 0, 0, 0.05);
            overflow-y: auto;
            border-right: 1px solid var(--border);
        }

        .nav-section {
            padding: 0 16px;
            margin-bottom: 24px;
        }

        .nav-title {
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
            color: var(--secondary);
            margin-bottom: 12px;
            letter-spacing: 0.5px;
        }

        .nav-item {
            margin-bottom: 4px;
        }

        .nav-link {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px 16px;
            color: var(--secondary);
            text-decoration: none;
            border-radius: 8px;
            transition: all 0.2s;
            font-size: 0.95rem;
        }

        .nav-link:hover {
            background: var(--light);
            color: var(--primary);
        }

        .nav-link.active {
            background: var(--primary);
            color: white;
        }

        .nav-link i {
            width: 20px;
            text-align: center;
        }

        /* Main Content */
        .main-content {
            margin-left: 260px;
            margin-top: 65px;
            padding: 32px;
            min-height: calc(100vh - 65px);
        }

        /* Admin Suspended Alert */
        .admin-suspended-alert {
            border-radius: 12px;
            margin-bottom: 24px;
            border-left: 5px solid;
            animation: slideDown 0.5s ease-out;
        }

        .admin-suspended-alert.permanent {
            background: linear-gradient(135deg, #ffebee 0%, #ffcdd2 100%);
            border-left-color: var(--danger);
        }

        .admin-suspended-alert.temporary {
            background: linear-gradient(135deg, #fff8e1 0%, #ffecb3 100%);
            border-left-color: var(--warning);
        }

        .admin-suspended-content {
            display: flex;
            align-items: flex-start;
            padding: 20px;
            gap: 15px;
        }

        .admin-suspended-icon {
            font-size: 2.5rem;
            flex-shrink: 0;
            margin-top: 5px;
        }

        .admin-suspended-details {
            flex: 1;
        }

        .admin-suspended-details h4 {
            margin: 0 0 10px 0;
            font-size: 1.1rem;
        }

        .admin-suspended-details p {
            margin: 5px 0;
            font-size: 0.95rem;
        }

        .suspended-timer {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            background: rgba(0, 0, 0, 0.1);
            padding: 6px 12px;
            border-radius: 20px;
            margin-top: 10px;
            font-weight: 600;
            animation: pulse 2s infinite;
        }

        /* Profile Header Card */
        .profile-header-card {
            background: white;
            border-radius: 16px;
            overflow: hidden;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            border: 1px solid var(--border);
            margin-bottom: 32px;
        }

        .profile-banner {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            height: 180px;
            position: relative;
        }

        .profile-banner::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            height: 80px;
            background: linear-gradient(to bottom, transparent, rgba(0, 0, 0, 0.2));
        }

        .profile-avatar-large {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            background: white;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: -60px auto 0;
            position: relative;
            z-index: 2;
            box-shadow: 0 4px 16px rgba(0, 0, 0, 0.15);
            border: 4px solid white;
        }

        .profile-avatar-large i {
            font-size: 60px;
            color: var(--primary);
        }

        .profile-info-section {
            padding: 1rem 2rem 2rem;
            text-align: center;
        }

        .profile-name {
            font-size: 1.75rem;
            font-weight: 700;
            color: var(--dark);
            margin: 1rem 0 0.5rem;
        }

        .profile-email {
            color: var(--secondary);
            font-size: 1rem;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .profile-stats {
            display: flex;
            justify-content: center;
            gap: 3rem;
            margin-top: 2rem;
            padding-top: 2rem;
            border-top: 1px solid var(--border);
        }

        .stat-item {
            text-align: center;
        }

        .stat-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 0.5rem;
            font-size: 1.5rem;
        }

        .stat-icon.room {
            background: rgba(255, 193, 7, 0.1);
            color: var(--warning);
        }

        .stat-icon.calendar {
            background: rgba(74, 144, 226, 0.1);
            color: var(--primary);
        }

        .stat-icon.phone {
            background: rgba(40, 167, 69, 0.1);
            color: var(--success);
        }

        .stat-label {
            font-size: 0.8rem;
            color: var(--secondary);
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .stat-value {
            font-size: 1.1rem;
            font-weight: 700;
            color: var(--dark);
            margin-top: 0.3rem;
        }

        /* Content Card */
        .content-card {
            background: white;
            border-radius: 12px;
            padding: 24px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            border: 1px solid var(--border);
            margin-bottom: 24px;
        }

        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 24px;
            padding-bottom: 16px;
            border-bottom: 1px solid var(--border);
        }

        .card-title {
            font-size: 1.125rem;
            font-weight: 600;
            color: var(--dark);
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .card-title i {
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 8px;
            font-size: 1rem;
        }

        .card-title .icon-info {
            background: rgba(74, 144, 226, 0.1);
            color: var(--primary);
        }

        .card-title .icon-edit {
            background: rgba(40, 167, 69, 0.1);
            color: var(--success);
        }

        /* Info Items */
        .info-item {
            background: var(--light);
            border-radius: 10px;
            padding: 16px;
            margin-bottom: 12px;
            border-left: 3px solid var(--primary);
            transition: all 0.2s;
        }

        .info-item:hover {
            transform: translateX(4px);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        }

        .info-label {
            font-size: 0.75rem;
            color: var(--secondary);
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 6px;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .info-value {
            font-size: 1rem;
            color: var(--dark);
            font-weight: 500;
        }

        .room-badge {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 8px 16px;
            background: linear-gradient(135deg, #fbbf24 0%, #f59e0b 100%);
            color: white;
            border-radius: 20px;
            font-weight: 700;
            font-size: 1.1rem;
            box-shadow: 0 2px 8px rgba(251, 191, 36, 0.3);
        }

        /* Alerts */
        .alert {
            padding: 16px 20px;
            border-radius: 10px;
            margin-bottom: 24px;
            display: flex;
            align-items: center;
            gap: 12px;
            animation: slideDown 0.3s ease-out;
            border: none;
        }

        .alert-success {
            background: #d4edda;
            border-left: 4px solid var(--success);
            color: #155724;
        }

        .alert-danger {
            background: #f8d7da;
            border-left: 4px solid var(--danger);
            color: #721c24;
        }

        .alert-info {
            background: #d1ecf1;
            border-left: 4px solid #17a2b8;
            color: #0c5460;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Form Styles */
        .form-label {
            font-weight: 600;
            color: var(--dark);
            margin-bottom: 8px;
            font-size: 0.9rem;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .form-control {
            padding: 12px 16px;
            border: 2px solid var(--border);
            border-radius: 8px;
            font-size: 0.95rem;
            transition: all 0.2s;
        }

        .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(74, 144, 226, 0.1);
            outline: none;
        }

        .form-control:disabled {
            background: #f1f5f9;
            cursor: not-allowed;
        }

        textarea.form-control {
            resize: vertical;
            min-height: 100px;
        }

        /* Password Section */
        .password-section {
            background: var(--light);
            padding: 20px;
            border-radius: 12px;
            margin-top: 20px;
            border: 2px dashed var(--border);
        }

        .section-title {
            font-size: 1rem;
            font-weight: 700;
            color: var(--dark);
            margin-bottom: 12px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        /* Buttons */
        .btn-primary {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 12px 24px;
            background: var(--primary);
            color: white;
            border: none;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.2s;
            cursor: pointer;
            font-size: 1rem;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 4px 6px rgba(37, 99, 235, 0.2);
        }

        .btn-primary:disabled {
            background: #ccc;
            color: #666;
            cursor: not-allowed;
            transform: none;
            box-shadow: none;
        }

        .btn-primary:disabled:hover {
            background: #ccc;
            color: #666;
            transform: none;
            box-shadow: none;
        }

        .btn-secondary {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 12px 24px;
            background: white;
            color: var(--secondary);
            border: 2px solid var(--border);
            border-radius: 8px;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.2s;
            cursor: pointer;
            font-size: 1rem;
        }

        .btn-secondary:hover {
            background: var(--light);
            color: var(--dark);
            border-color: var(--secondary);
        }

        /* Disabled action styles */
        .disabled-action {
            opacity: 0.6;
            cursor: not-allowed;
            position: relative;
        }

        .disabled-action::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(255, 255, 255, 0.5);
            border-radius: 8px;
            z-index: 1;
        }

        .disabled-action-text {
            position: relative;
            z-index: 2;
        }

        /* Modal */
        .modal-content {
            border-radius: 16px;
            border: none;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
        }

        .modal-header {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
            border-radius: 16px 16px 0 0;
            padding: 20px 24px;
            border-bottom: none;
        }

        .modal-title {
            font-weight: 700;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .btn-close {
            filter: brightness(0) invert(1);
        }

        .modal-body {
            padding: 24px;
        }

        .modal-footer {
            padding: 16px 24px;
            border-top: 1px solid var(--border);
        }

        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }

            .main-content {
                margin-left: 0;
                padding: 16px;
            }

            .topbar-content {
                padding: 0 16px;
            }

            .user-info-badge {
                display: none;
            }

            .profile-stats {
                flex-direction: column;
                gap: 1.5rem;
            }

            .profile-name {
                font-size: 1.5rem;
            }

            .admin-suspended-content {
                flex-direction: column;
                text-align: center;
            }

            .admin-suspended-icon {
                margin: 0 auto 15px;
            }
        }

        /* Scrollbar */
        .sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .sidebar::-webkit-scrollbar-track {
            background: transparent;
        }

        .sidebar::-webkit-scrollbar-thumb {
            background: var(--border);
            border-radius: 3px;
        }

        .sidebar::-webkit-scrollbar-thumb:hover {
            background: var(--secondary);
        }

        @keyframes pulse {
            0% {
                transform: scale(1);
            }

            50% {
                transform: scale(1.05);
            }

            100% {
                transform: scale(1);
            }
        }

        @keyframes slideUp {
            from {
                opacity: 1;
                transform: translateY(0);
            }

            to {
                opacity: 0;
                transform: translateY(-20px);
            }
        }
    </style>
</head>

<body>
    <!-- Topbar -->
    <div class="topbar">
        <div class="topbar-content">
            <div class="brand">
                <i class="fas fa-building"></i>
                <span>KosCare</span>
            </div>
            <div class="user-menu">
                <div class="user-info-badge">
                    <div class="user-avatar">
                        <?= strtoupper(substr($user->nama_penghuni, 0, 1)) ?>
                    </div>
                    <div>
                        <div style="font-weight: 600; font-size: 0.9rem;"><?= $user->nama_penghuni ?></div>
                        <div style="font-size: 0.75rem; color: var(--secondary);">Penghuni</div>
                    </div>
                </div>
                <a href="<?= site_url('user/login/logout') ?>" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </div>
    </div>

    <!-- Sidebar -->
    <div class="sidebar">
        <nav class="nav-section">
            <div class="nav-title">Menu Utama</div>
            <div class="nav-item">
                <a href="<?= site_url('user/dashboard') ?>" class="nav-link">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
            </div>
            <div class="nav-item">
                <a href="<?= site_url('user/dashboard/laporan') ?>" class="nav-link <?= isset($admin_suspended['suspended']) && $admin_suspended['suspended'] ? 'disabled-action' : '' ?>">
                    <i class="fas fa-clipboard-list"></i>
                    <span class="<?= isset($admin_suspended['suspended']) && $admin_suspended['suspended'] ? 'disabled-action-text' : '' ?>">Laporan Saya</span>
                    <?php if (isset($admin_suspended['suspended']) && $admin_suspended['suspended']): ?>
                        <span style="margin-left: auto; font-size: 0.7rem; color: var(--danger);">
                            <i class="fas fa-ban"></i>
                        </span>
                    <?php endif; ?>
                </a>
            </div>
            <div class="nav-item">
                <a href="<?= site_url('user/dashboard/tambah') ?>" class="nav-link <?= isset($admin_suspended['suspended']) && $admin_suspended['suspended'] ? 'disabled-action' : '' ?>">
                    <i class="fas fa-plus-circle"></i>
                    <span class="<?= isset($admin_suspended['suspended']) && $admin_suspended['suspended'] ? 'disabled-action-text' : '' ?>">Buat Laporan</span>
                    <?php if (isset($admin_suspended['suspended']) && $admin_suspended['suspended']): ?>
                        <span style="margin-left: auto; font-size: 0.7rem; color: var(--danger);">
                            <i class="fas fa-ban"></i>
                        </span>
                    <?php endif; ?>
                </a>
            </div>
        </nav>

        <nav class="nav-section">
            <div class="nav-title">Pengaturan</div>
            <div class="nav-item">
                <a href="<?= site_url('user/dashboard/profile') ?>" class="nav-link active">
                    <i class="fas fa-user"></i>
                    <span>Profil Saya</span>
                </a>
            </div>
        </nav>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Admin Suspended Alert -->
        <?php if (isset($admin_suspended['suspended']) && $admin_suspended['suspended']): ?>
            <div class="admin-suspended-alert <?= $admin_suspended['type'] ?>">
                <div class="admin-suspended-content">
                    <div class="admin-suspended-icon">
                        <?php if ($admin_suspended['type'] == 'permanent'): ?>
                            <i class="fas fa-ban text-danger"></i>
                        <?php else: ?>
                            <i class="fas fa-clock text-warning"></i>
                        <?php endif; ?>
                    </div>
                    <div class="admin-suspended-details">
                        <h4>
                            <?php if ($admin_suspended['type'] == 'permanent'): ?>
                                <i class="fas fa-exclamation-triangle"></i> Admin Dinonaktifkan Permanen
                            <?php else: ?>
                                <i class="fas fa-clock"></i> Admin Dinonaktifkan Sementara
                            <?php endif; ?>
                        </h4>

                        <?php if ($admin_suspended['type'] == 'permanent'): ?>
                            <p><strong>Admin pengelola kos Anda telah dinonaktifkan permanen.</strong></p>
                            <p>Fitur pengajuan laporan dan edit profil saat ini tidak tersedia.</p>
                            <p><strong>Alasan:</strong> <?= $admin_suspended['reason'] ?></p>
                            <p><small>Hubungi Super Admin untuk informasi lebih lanjut.</small></p>
                        <?php else: ?>
                            <p><strong>Admin pengelola kos sedang dinonaktifkan sementara.</strong></p>
                            <p>Fitur pengajuan laporan dan edit profil akan tersedia kembali pada:</p>
                            <p><strong><?= date('d M Y H:i', strtotime($admin_suspended['until'])) ?></strong></p>
                            <div class="suspended-timer">
                                <i class="fas fa-hourglass-half"></i>
                                <span>Sisa waktu: <?= $admin_suspended['days_left'] ?> hari</span>
                            </div>
                            <p style="margin-top: 10px;"><strong>Alasan:</strong> <?= $admin_suspended['reason'] ?></p>
                            <p><small>Anda hanya dapat melihat profil tanpa dapat mengeditnya.</small></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Alerts -->
        <?php if ($this->session->flashdata('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <span><?= $this->session->flashdata('success') ?></span>
            </div>
        <?php endif; ?>

        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle"></i>
                <span><?= $this->session->flashdata('error') ?></span>
            </div>
        <?php endif; ?>

        <!-- Profile Header Card -->
        <div class="profile-header-card">
            <div class="profile-banner"></div>
            <div class="profile-info-section">
                <div class="profile-avatar-large">
                    <i class="fas fa-user-circle"></i>
                </div>
                <h1 class="profile-name"><?= $user->nama_penghuni ?></h1>
                <div class="profile-email">
                    <i class="fas fa-envelope"></i>
                    <span><?= $user->email ?></span>
                </div>

                <div class="profile-stats">
                    <div class="stat-item">
                        <div class="stat-icon room">
                            <i class="fas fa-door-open"></i>
                        </div>
                        <div class="stat-label">Kamar</div>
                        <div class="stat-value"><?= $user->kamar ?: '-' ?></div>
                    </div>

                    <div class="stat-item">
                        <div class="stat-icon phone">
                            <i class="fas fa-phone"></i>
                        </div>
                        <div class="stat-label">No. HP</div>
                        <div class="stat-value"><?= $user->no_hp ?: '-' ?></div>
                    </div>

                    <div class="stat-item">
                        <div class="stat-icon calendar">
                            <i class="fas fa-calendar-alt"></i>
                        </div>
                        <div class="stat-label">Bergabung</div>
                        <div class="stat-value"><?= date('M Y', strtotime($user->created_at)) ?></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Info Detail -->
            <div class="col-lg-4 mb-4">
                <div class="content-card">
                    <div class="card-header">
                        <h2 class="card-title">
                            <i class="fas fa-info-circle icon-info"></i>
                            <span>Detail Profil</span>
                        </h2>
                    </div>

                    <div class="info-item">
                        <div class="info-label"><i class="fas fa-user"></i> Nama Lengkap</div>
                        <div class="info-value"><?= $user->nama_penghuni ?></div>
                    </div>

                    <div class="info-item">
                        <div class="info-label"><i class="fas fa-envelope"></i> Email</div>
                        <div class="info-value"><?= $user->email ?></div>
                    </div>

                    <div class="info-item">
                        <div class="info-label"><i class="fas fa-phone"></i> Nomor HP</div>
                        <div class="info-value"><?= $user->no_hp ?: '-' ?></div>
                    </div>

                    <div class="info-item">
                        <div class="info-label"><i class="fas fa-map-marker-alt"></i> Alamat</div>
                        <div class="info-value"><?= $user->alamat ?: '-' ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label"><i class="fas fa-building"></i> Nama Kos</div>
                        <div class="info-value">
                            <?= $user->nama_kos ? $user->nama_kos : '<span class="badge bg-secondary">Tidak Terdaftar</span>' ?>
                        </div>
                    </div>

                    <div class="info-item">
                        <div class="info-label"><i class="fas fa-door-open"></i> Kamar Saat Ini</div>
                        <div class="info-value">
                            <?php if ($user->kamar): ?>
                                <span class="room-badge">
                                    <i class="fas fa-home"></i>
                                    <?= $user->kamar ?>
                                </span>
                            <?php else: ?>
                                <span class="badge bg-secondary">Belum Ada Kamar</span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Form Edit Profil -->
            <div class="col-lg-8 mb-4">
                <div class="content-card">
                    <div class="card-header">
                        <h2 class="card-title">
                            <i class="fas fa-edit icon-edit"></i>
                            <span>Edit Profil</span>
                        </h2>
                    </div>

                    <form action="<?= site_url('user/dashboard/update_profile') ?>" method="post" id="formProfile">

                        <!-- Validation Errors -->
                        <?php if (validation_errors()): ?>
                            <div class="alert alert-danger">
                                <?= validation_errors() ?>
                            </div>
                        <?php endif; ?>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">
                                    <i class="fas fa-user" style="color: var(--primary);"></i>
                                    <span>Nama Lengkap <span class="text-danger">*</span></span>
                                </label>
                                <input type="text" class="form-control" name="nama_penghuni"
                                    value="<?= isset($_POST['nama_penghuni']) ? $_POST['nama_penghuni'] : $user->nama_penghuni ?>"
                                    <?= isset($admin_suspended['suspended']) && $admin_suspended['suspended'] ? 'disabled' : 'required' ?>>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">
                                    <i class="fas fa-envelope" style="color: var(--primary);"></i>
                                    <span>Email <span class="text-danger">*</span></span>
                                </label>
                                <input type="email" class="form-control" name="email"
                                    value="<?= isset($_POST['email']) ? $_POST['email'] : $user->email ?>"
                                    <?= isset($admin_suspended['suspended']) && $admin_suspended['suspended'] ? 'disabled' : 'required' ?>>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">
                                    <i class="fas fa-phone" style="color: var(--primary);"></i>
                                    <span>Nomor HP <span class="text-danger">*</span></span>
                                </label>
                                <input type="text" class="form-control" name="no_hp"
                                    value="<?= isset($_POST['no_hp']) ? $_POST['no_hp'] : $user->no_hp ?>"
                                    <?= isset($admin_suspended['suspended']) && $admin_suspended['suspended'] ? 'disabled' : 'required' ?>>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label">
                                    <i class="fas fa-door-open" style="color: var(--warning);"></i>
                                    <span>Kamar</span>
                                </label>
                                <input type="text" class="form-control" value="<?= $user->kamar ?: 'Belum Ada Kamar' ?>" disabled>
                            </div>

                            <div class="col-md-12 mb-3">
                                <label class="form-label">
                                    <i class="fas fa-map-marker-alt" style="color: var(--primary);"></i>
                                    <span>Alamat <span class="text-danger">*</span></span>
                                </label>
                                <textarea class="form-control" name="alamat" rows="3"
                                    <?= isset($admin_suspended['suspended']) && $admin_suspended['suspended'] ? 'disabled' : 'required' ?>><?= isset($_POST['alamat']) ? $_POST['alamat'] : $user->alamat ?></textarea>
                            </div>
                        </div>

                        <div class="password-section">
                            <div class="section-title">
                                <i class="fas fa-lock"></i>
                                <span>Ubah Password (Opsional)</span>
                            </div>
                            <small class="text-muted d-block mb-3">Kosongkan jika tidak ingin mengubah password</small>

                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <label class="form-label">Password Lama</label>
                                    <input type="password" class="form-control" name="password_lama" id="password_lama"
                                        <?= isset($admin_suspended['suspended']) && $admin_suspended['suspended'] ? 'disabled' : '' ?>>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Password Baru</label>
                                    <input type="password" class="form-control" name="password_baru" id="password_baru"
                                        <?= isset($admin_suspended['suspended']) && $admin_suspended['suspended'] ? 'disabled' : '' ?>>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Konfirmasi Password Baru</label>
                                    <input type="password" class="form-control" name="konfirmasi_password"
                                        <?= isset($admin_suspended['suspended']) && $admin_suspended['suspended'] ? 'disabled' : '' ?>>
                                </div>
                            </div>
                        </div>

                        <div class="d-grid gap-2 d-md-flex justify-content-md-end mt-4">
                            <a href="<?= site_url('user/dashboard') ?>" class="btn-secondary">
                                <i class="fas fa-arrow-left"></i>
                                <span>Kembali</span>
                            </a>
                            <?php if (isset($admin_suspended['suspended']) && $admin_suspended['suspended']): ?>
                                <button type="button" class="btn-primary" disabled>
                                    <i class="fas fa-ban"></i>
                                    <span>Edit Dinonaktifkan</span>
                                </button>
                                <div style="margin-top: 10px; font-size: 0.9rem; color: var(--secondary); width: 100%;">
                                    <i class="fas fa-info-circle"></i>
                                    <?php if ($admin_suspended['type'] == 'permanent'): ?>
                                        Hubungi Super Admin untuk informasi lebih lanjut.
                                    <?php else: ?>
                                        Anda dapat mengedit profil kembali dalam <?= $admin_suspended['days_left'] ?> hari.
                                    <?php endif; ?>
                                </div>
                            <?php else: ?>
                                <button type="submit" class="btn-primary">
                                    <i class="fas fa-save"></i>
                                    <span>Simpan Perubahan</span>
                                </button>
                            <?php endif; ?>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="<?= base_url('asset/js/jquery-3.6.0.min.js') ?>"></script>
    <script src="<?= base_url('asset/js/bootstrap.bundle.min.js') ?>"></script>

    <script>
        // Auto hide alerts
        document.addEventListener('DOMContentLoaded', function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(alert => {
                setTimeout(() => {
                    alert.style.animation = 'slideUp 0.3s ease-out';
                    setTimeout(() => alert.remove(), 300);
                }, 5000);
            });

            // Disable click on disabled menu items
            document.querySelectorAll('.disabled-action').forEach(item => {
                item.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();

                    const alertMsg = document.createElement('div');
                    alertMsg.className = 'alert alert-warning';
                    alertMsg.style.position = 'fixed';
                    alertMsg.style.top = '80px';
                    alertMsg.style.right = '20px';
                    alertMsg.style.zIndex = '9999';
                    alertMsg.style.maxWidth = '300px';
                    alertMsg.innerHTML = `
                        <i class="fas fa-exclamation-triangle"></i>
                        <span>Fitur ini tidak tersedia saat admin dinonaktifkan.</span>
                    `;

                    document.body.appendChild(alertMsg);

                    setTimeout(() => {
                        alertMsg.style.opacity = '0';
                        alertMsg.style.transition = 'opacity 0.5s';
                        setTimeout(() => alertMsg.remove(), 500);
                    }, 3000);
                });
            });

            // Auto-refresh untuk cek status admin setiap 5 menit
            setTimeout(() => {
                location.reload();
            }, 300000); // 5 menit
        });

        // Validation: If user fills password_baru, password_lama must be filled
        document.getElementById('formProfile')?.addEventListener('submit', function(e) {
            const passwordBaru = document.getElementById('password_baru')?.value;
            const passwordLama = document.getElementById('password_lama')?.value;

            if (passwordBaru && !passwordLama) {
                e.preventDefault();
                alert('Harap isi password lama jika ingin mengubah password!');
                document.getElementById('password_lama')?.focus();
            }
        });
    </script>

</body>

</html>