<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title><?= $title ?> - KosCare</title>
    <link rel="stylesheet" href="<?= base_url('asset/css/bootstrap.min.css') ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        /* Gunakan style yang sama dengan laporan_admin.php */
        :root {
            --primary: #4a90e2;
            --primary-dark: #357abd;
            --secondary: #64748b;
            --success: #28a745;
            --warning: #ffc107;
            --danger: #dc3545;
            --info: #17a2b8;
            --light: #f8fafc;
            --dark: #0f172a;
            --border: #e2e8f0;
        }

        /* ... (copy semua CSS dari laporan_admin.php) ... */

        .form-container {
            max-width: 800px;
            margin: 0 auto;
        }

        .form-group {
            margin-bottom: 20px;
        }

        .form-label {
            font-weight: 600;
            margin-bottom: 8px;
            display: block;
            color: var(--dark);
        }

        .form-control,
        .form-select {
            width: 100%;
            padding: 12px 16px;
            border: 1px solid var(--border);
            border-radius: 8px;
            font-size: 1rem;
            transition: all 0.2s;
        }

        .form-control:focus,
        .form-select:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(74, 144, 226, 0.1);
        }

        .form-text {
            font-size: 0.875rem;
            color: var(--secondary);
            margin-top: 4px;
        }

        .btn-submit {
            background: var(--primary);
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 8px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s;
        }

        .btn-submit:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(37, 99, 235, 0.2);
        }

        .btn-back {
            background: var(--secondary);
            color: white;
            text-decoration: none;
            padding: 10px 20px;
            border-radius: 8px;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            margin-bottom: 20px;
        }

        .btn-back:hover {
            background: #475569;
            color: white;
        }
    </style>
</head>

<body>
    <!-- Topbar (sama seperti laporan_admin.php) -->
    <div class="topbar">
        <div class="topbar-content">
            <div class="brand">
                <div class="login-icon">
                    <img src="<?= base_url('asset/logo.png'); ?>" alt="Logo KosCare" style="width: 50px; height: auto;">
                </div>
                <span>KosCare</span>
            </div>
            <div class="user-menu">
                <div class="user-info-badge">
                    <div class="user-avatar">
                        <?= strtoupper(substr($user->nama_penghuni, 0, 1)) ?>
                    </div>
                    <div>
                        <div style="font-weight: 600; font-size: 0.9rem;"><?= $user->nama_penghuni ?></div>
                        <div style="font-size: 0.75rem; color: var(--secondary);">Penghuni</div>
                    </div>
                </div>
                <a href="<?= site_url('user/login/logout') ?>" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Logout</span>
                </a>
            </div>
        </div>
    </div>

    <!-- Sidebar (sama seperti laporan_admin.php) -->
    <div class="sidebar">
        <nav class="nav-section">
            <div class="nav-title">Menu Utama</div>
            <div class="nav-item">
                <a href="<?= site_url('user/dashboard') ?>" class="nav-link">
                    <i class="fas fa-home"></i>
                    <span>Dashboard</span>
                </a>
            </div>
            <div class="nav-item">
                <a href="<?= site_url('user/dashboard/laporan') ?>" class="nav-link">
                    <i class="fas fa-clipboard-list"></i>
                    <span>Laporan Kos</span>
                </a>
            </div>
            <div class="nav-item">
                <a href="<?= site_url('user/laporan_admin') ?>" class="nav-link">
                    <i class="fas fa-user-shield"></i>
                    <span>Laporan Admin</span>
                </a>
            </div>
            <div class="nav-item">
                <a href="<?= site_url('user/dashboard/tambah') ?>" class="nav-link">
                    <i class="fas fa-plus-circle"></i>
                    <span>Buat Laporan Kos</span>
                </a>
            </div>
            <div class="nav-item">
                <a href="<?= site_url('user/laporan_admin/tambah') ?>" class="nav-link active">
                    <i class="fas fa-flag"></i>
                    <span>Laporkan Admin</span>
                </a>
            </div>
        </nav>

        <nav class="nav-section">
            <div class="nav-title">Pengaturan</div>
            <div class="nav-item">
                <a href="<?= site_url('user/dashboard/profile') ?>" class="nav-link">
                    <i class="fas fa-user"></i>
                    <span>Profil Saya</span>
                </a>
            </div>
        </nav>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Alerts -->
        <?php if ($this->session->flashdata('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <span><?= $this->session->flashdata('success') ?></span>
            </div>
        <?php endif; ?>

        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-circle"></i>
                <span><?= $this->session->flashdata('error') ?></span>
            </div>
        <?php endif; ?>

        <!-- Page Header -->
        <div class="page-header">
            <h1>🚨 Laporkan Admin</h1>
            <p>Buat laporan untuk admin yang bermasalah</p>
        </div>

        <!-- Form Container -->
        <div class="content-card">
            <a href="<?= site_url('user/laporan_admin') ?>" class="btn-back">
                <i class="fas fa-arrow-left"></i> Kembali ke Daftar Laporan
            </a>

            <div class="form-container">
                <form action="<?= site_url('user/laporan_admin/simpan') ?>" method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label class="form-label" for="id_admin">Admin yang Dilaporkan *</label>
                        <select name="id_admin" id="id_admin" class="form-select" required>
                            <option value="">-- Pilih Admin --</option>
                            <?php if (!empty($admins)): ?>
                                <?php foreach ($admins as $admin): ?>
                                    <option value="<?= $admin->id ?>">
                                        <?= htmlspecialchars($admin->nama) ?>
                                        (<?= htmlspecialchars($admin->email) ?>)
                                    </option>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <option value="" disabled>Tidak ada admin tersedia</option>
                            <?php endif; ?>
                        </select>
                        <div class="form-text">
                            Pilih admin yang ingin Anda laporkan. Hanya admin yang aktif yang ditampilkan.
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="form-label" for="judul">Judul Laporan *</label>
                        <input type="text" name="judul" id="judul" class="form-control"
                            placeholder="Contoh: Admin tidak responsif terhadap keluhan"
                            required maxlength="255">
                        <div class="form-text">
                            Buat judul yang jelas dan deskriptif tentang masalahnya.
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="form-label" for="deskripsi">Deskripsi Lengkap *</label>
                        <textarea name="deskripsi" id="deskripsi" class="form-control"
                            rows="6" placeholder="Jelaskan secara detail masalah yang terjadi..."
                            required></textarea>
                        <div class="form-text">
                            Jelaskan kronologi kejadian, waktu, dan detail lainnya yang relevan.
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="form-label" for="bukti">Bukti Pendukung (Opsional)</label>
                        <input type="file" name="bukti" id="bukti" class="form-control"
                            accept="image/*,.pdf,.doc,.docx">
                        <div class="form-text">
                            Upload foto, screenshot, atau dokumen pendukung (max 2MB).
                            Format: JPG, PNG, PDF, DOC, DOCX
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle"></i>
                            <div>
                                <strong>Perhatian:</strong> Laporan yang dibuat akan dikirim ke Super Admin untuk ditinjau.
                                Pastikan laporan Anda akurat dan sesuai fakta. Laporan palsu dapat berakibat pada sanksi.
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <button type="submit" class="btn-submit">
                            <i class="fas fa-paper-plane"></i> Kirim Laporan
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="<?= base_url('asset/js/jquery-3.6.0.min.js') ?>"></script>
    <script src="<?= base_url('asset/js/bootstrap.bundle.min.js') ?>"></script>

    <script>
        // Form validation
        document.querySelector('form').addEventListener('submit', function(e) {
            const judul = document.getElementById('judul').value.trim();
            const deskripsi = document.getElementById('deskripsi').value.trim();
            const admin = document.getElementById('id_admin').value;

            if (!admin) {
                e.preventDefault();
                alert('Silakan pilih admin yang akan dilaporkan');
                return false;
            }

            if (judul.length < 10) {
                e.preventDefault();
                alert('Judul laporan minimal 10 karakter');
                return false;
            }

            if (deskripsi.length < 50) {
                e.preventDefault();
                alert('Deskripsi laporan minimal 50 karakter');
                return false;
            }

            // File validation
            const fileInput = document.getElementById('bukti');
            if (fileInput.files.length > 0) {
                const file = fileInput.files[0];
                const maxSize = 2 * 1024 * 1024; // 2MB
                const allowedTypes = ['image/jpeg', 'image/png', 'image/jpg', 'application/pdf', 'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'];

                if (file.size > maxSize) {
                    e.preventDefault();
                    alert('Ukuran file terlalu besar. Maksimal 2MB.');
                    return false;
                }

                if (!allowedTypes.includes(file.type)) {
                    e.preventDefault();
                    alert('Format file tidak didukung. Gunakan JPG, PNG, PDF, DOC, atau DOCX.');
                    return false;
                }
            }
            return true;
        });
    </script>
</body>

</html>