<!doctype html>
<html>

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Registrasi Penghuni - KosCare</title>
  <link rel="stylesheet" href="<?= base_url('asset/css/bootstrap.min.css') ?>">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      position: relative;
      overflow-x: hidden;
      padding: 40px 0;
    }

    /* Animated background circles */
    body::before,
    body::after {
      content: '';
      position: absolute;
      border-radius: 50%;
      background: rgba(255, 255, 255, 0.1);
      animation: float 20s infinite ease-in-out;
    }

    body::before {
      width: 300px;
      height: 300px;
      top: -100px;
      left: -100px;
      animation-delay: 0s;
    }

    body::after {
      width: 400px;
      height: 400px;
      bottom: -150px;
      right: -150px;
      animation-delay: 3s;
    }

    @keyframes float {

      0%,
      100% {
        transform: translateY(0) rotate(0deg);
      }

      50% {
        transform: translateY(-50px) rotate(180deg);
      }
    }

    .register-container {
      position: relative;
      z-index: 10;
      width: 100%;
      max-width: 500px;
      padding: 20px;
      animation: slideIn 0.5s ease-out;
    }

    @keyframes slideIn {
      from {
        opacity: 0;
        transform: translateY(-30px);
      }

      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .register-card {
      background: white;
      border-radius: 20px;
      box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
      overflow: hidden;
      transition: transform 0.3s ease;
    }

    .register-card:hover {
      transform: translateY(-5px);
    }

    .register-header {
      background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
      padding: 35px 30px;
      text-align: center;
      color: white;
      position: relative;
    }

    .register-header::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: url('data:image/svg+xml,<svg width="100" height="100" xmlns="http://www.w3.org/2000/svg"><circle cx="50" cy="50" r="40" fill="rgba(255,255,255,0.05)"/></svg>');
      opacity: 0.3;
    }

    .register-icon {
      width: 70px;
      height: 70px;
      background: rgba(255, 255, 255, 0.2);
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      margin: 0 auto 15px;
      font-size: 2rem;
      backdrop-filter: blur(10px);
      border: 3px solid rgba(255, 255, 255, 0.3);
      animation: pulse 2s infinite;
    }

    @keyframes pulse {

      0%,
      100% {
        transform: scale(1);
        box-shadow: 0 0 0 0 rgba(255, 255, 255, 0.4);
      }

      50% {
        transform: scale(1.05);
        box-shadow: 0 0 0 10px rgba(255, 255, 255, 0);
      }
    }

    .register-header h4 {
      margin: 0;
      font-size: 1.6rem;
      font-weight: 600;
      position: relative;
      z-index: 1;
    }

    .register-header p {
      margin: 8px 0 0;
      opacity: 0.95;
      font-size: 0.9rem;
      position: relative;
      z-index: 1;
    }

    .register-body {
      padding: 35px 30px;
      max-height: 65vh;
      overflow-y: auto;
    }

    .register-body::-webkit-scrollbar {
      width: 8px;
    }

    .register-body::-webkit-scrollbar-track {
      background: #f1f1f1;
      border-radius: 10px;
    }

    .register-body::-webkit-scrollbar-thumb {
      background: #4a90e2;
      border-radius: 10px;
    }

    .register-body::-webkit-scrollbar-thumb:hover {
      background: #357abd;
    }

    .alert {
      border-radius: 10px;
      border: none;
      padding: 15px;
      margin-bottom: 25px;
      animation: shake 0.5s ease-in-out;
    }

    @keyframes shake {

      0%,
      100% {
        transform: translateX(0);
      }

      25% {
        transform: translateX(-10px);
      }

      75% {
        transform: translateX(10px);
      }
    }

    .alert-danger {
      background: #fee;
      color: #c33;
      border-left: 4px solid #c33;
    }

    .alert-warning {
      background: #fff3cd;
      color: #856404;
      border-left: 4px solid #ffc107;
    }

    .form-group {
      margin-bottom: 20px;
      position: relative;
    }

    .form-group label {
      font-weight: 600;
      color: #555;
      margin-bottom: 8px;
      font-size: 0.85rem;
      display: block;
    }

    .form-group label .required {
      color: #dc3545;
      margin-left: 2px;
    }

    .input-wrapper {
      position: relative;
    }

    .input-icon {
      position: absolute;
      left: 15px;
      top: 50%;
      transform: translateY(-50%);
      color: #4a90e2;
      font-size: 1rem;
      z-index: 1;
    }

    .form-control {
      border: 2px solid #e3f2fd;
      border-radius: 10px;
      padding: 11px 15px 11px 45px;
      font-size: 0.9rem;
      transition: all 0.3s ease;
      background: #f8fbff;
      width: 100%;
    }

    textarea.form-control {
      padding: 11px 15px;
      resize: vertical;
      min-height: 80px;
    }

    .form-control:focus {
      border-color: #4a90e2;
      box-shadow: 0 0 0 4px rgba(74, 144, 226, 0.1);
      background: white;
      outline: none;
    }

    .form-control.is-valid {
      border-color: #28a745;
      background: #f0fff4;
    }

    .form-control.is-invalid {
      border-color: #dc3545;
      background: #fff5f5;
    }

    .validation-message {
      font-size: 0.8rem;
      margin-top: 5px;
      display: none;
      animation: fadeIn 0.3s ease;
    }

    @keyframes fadeIn {
      from {
        opacity: 0;
        transform: translateY(-5px);
      }

      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .validation-message.success {
      color: #28a745;
      display: block;
    }

    .validation-message.error {
      color: #dc3545;
      display: block;
    }

    .validation-message i {
      margin-right: 5px;
    }

    .checking-kamar {
      display: none;
      font-size: 0.8rem;
      color: #6c757d;
      margin-top: 5px;
    }

    .checking-kamar.show {
      display: block;
    }

    .checking-kamar i {
      animation: spin 1s linear infinite;
    }

    .password-toggle {
      position: absolute;
      right: 15px;
      top: 50%;
      transform: translateY(-50%);
      cursor: pointer;
      color: #888;
      font-size: 1rem;
      transition: color 0.3s;
      z-index: 2;
    }

    .password-toggle:hover {
      color: #4a90e2;
    }

    .btn-register {
      background: linear-gradient(135deg, #4a90e2 0%, #357abd 100%);
      color: white;
      border: none;
      border-radius: 10px;
      padding: 13px;
      font-size: 1rem;
      font-weight: 600;
      width: 100%;
      cursor: pointer;
      transition: all 0.3s ease;
      position: relative;
      overflow: hidden;
      margin-top: 10px;
    }

    .btn-register::before {
      content: '';
      position: absolute;
      top: 0;
      left: -100%;
      width: 100%;
      height: 100%;
      background: rgba(255, 255, 255, 0.2);
      transition: left 0.5s ease;
    }

    .btn-register:hover::before {
      left: 100%;
    }

    .btn-register:hover {
      transform: translateY(-2px);
      box-shadow: 0 8px 20px rgba(74, 144, 226, 0.4);
    }

    .btn-register:active {
      transform: translateY(0);
    }

    .btn-register:disabled {
      opacity: 0.6;
      cursor: not-allowed;
      transform: none;
    }

    .btn-register i {
      margin-left: 8px;
      transition: transform 0.3s;
    }

    .btn-register:not(:disabled):hover i {
      transform: translateX(5px);
    }

    .register-footer {
      text-align: center;
      padding: 20px 30px;
      background: #f8fbff;
      color: #888;
      font-size: 0.85rem;
    }

    .register-footer a {
      color: #4a90e2;
      text-decoration: none;
      font-weight: 600;
      transition: color 0.3s;
    }

    .register-footer a:hover {
      color: #357abd;
      text-decoration: underline;
    }

    /* Loading state */
    .btn-register.loading {
      pointer-events: none;
      opacity: 0.7;
    }

    .btn-register.loading::after {
      content: '';
      position: absolute;
      width: 20px;
      height: 20px;
      top: 50%;
      left: 50%;
      margin-left: -10px;
      margin-top: -10px;
      border: 3px solid rgba(255, 255, 255, 0.3);
      border-top-color: white;
      border-radius: 50%;
      animation: spin 0.8s linear infinite;
    }

    @keyframes spin {
      to {
        transform: rotate(360deg);
      }
    }

    .floating-shapes {
      position: absolute;
      width: 100%;
      height: 100%;
      top: 0;
      left: 0;
      pointer-events: none;
      overflow: hidden;
    }

    .shape {
      position: absolute;
      background: rgba(255, 255, 255, 0.05);
      border-radius: 50%;
    }

    .shape:nth-child(1) {
      width: 80px;
      height: 80px;
      top: 20%;
      left: 10%;
      animation: float 15s infinite ease-in-out;
    }

    .shape:nth-child(2) {
      width: 120px;
      height: 120px;
      top: 60%;
      left: 80%;
      animation: float 20s infinite ease-in-out 2s;
    }

    .shape:nth-child(3) {
      width: 60px;
      height: 60px;
      top: 80%;
      left: 20%;
      animation: float 18s infinite ease-in-out 4s;
    }

    @media (max-width: 576px) {
      .register-container {
        padding: 15px;
      }

      .register-header {
        padding: 25px 20px;
      }

      .register-body {
        padding: 25px 20px;
      }

      .register-header h4 {
        font-size: 1.4rem;
      }

      .form-group {
        margin-bottom: 18px;
      }
    }
  </style>
</head>

<body>
  <div class="floating-shapes">
    <div class="shape"></div>
    <div class="shape"></div>
    <div class="shape"></div>
  </div>

  <div class="register-container">
    <div class="register-card">
      <div class="register-header">
        <div class="register-icon">
          <img src="<?= base_url('asset/logo 2.png'); ?>" alt="Logo KosCare" style="width: 70px; height: auto;">
        </div>
        <h4>KosCare</h4>
        <p>Registrasi Penghuni Baru</p>
      </div>

      <div class="register-body">
        <?php if (!empty($error)): ?>
          <div class="alert alert-danger">
            <i class="fas fa-exclamation-circle"></i>
            <?= htmlspecialchars($error) ?>
          </div>
        <?php endif; ?>

        <form method="post" action="<?= site_url('user/register/process') ?>" id="registerForm">
          <!-- 🔥 Tambahan: Pilih Kos -->
          <div class="form-group">
            <label for="id_kos"><i class="fas fa-home"></i> Pilih Kos</label>
            <div class="input-wrapper">
              <i class="fas fa-building input-icon"></i>
              <select name="id_kos" id="id_kos" class="form-control" required>
                <option value="">-- Pilih Kos --</option>
                <?php foreach ($list_kos as $kos): ?>
                  <option value="<?= $kos->id_kos ?>">
                    <?= $kos->nama_kos ?> - <?= $kos->alamat ?>
                  </option>
                <?php endforeach; ?>
              </select>
            </div>
          </div>
          <div class="form-group">
            <label for="nama_penghuni"><i class="fas fa-user"></i> Nama Lengkap<span class="required">*</span></label>
            <div class="input-wrapper">
              <i class="fas fa-user input-icon"></i>
              <input
                type="text"
                name="nama_penghuni"
                id="nama_penghuni"
                class="form-control"
                placeholder="Masukkan nama lengkap"
                required
                autocomplete="name">
            </div>
          </div>

          <div class="form-group">
            <label for="email"><i class="fas fa-envelope"></i> Email<span class="required">*</span></label>
            <div class="input-wrapper">
              <i class="fas fa-envelope input-icon"></i>
              <input
                type="email"
                name="email"
                id="email"
                class="form-control"
                placeholder="Masukkan email"
                required
                autocomplete="email">
            </div>
          </div>

          <div class="form-group">
            <label for="password"><i class="fas fa-lock"></i> Password<span class="required">*</span></label>
            <div class="input-wrapper">
              <i class="fas fa-key input-icon"></i>
              <input
                type="password"
                name="password"
                id="password"
                class="form-control"
                placeholder="Buat password"
                required
                autocomplete="new-password">
              <i class="fas fa-eye password-toggle" id="togglePassword"></i>
            </div>
          </div>

          <div class="form-group">
            <label for="no_hp"><i class="fas fa-phone"></i> No HP</label>
            <div class="input-wrapper">
              <i class="fas fa-phone input-icon"></i>
              <input
                type="text"
                name="no_hp"
                id="no_hp"
                class="form-control"
                placeholder="Contoh: 08123456789"
                autocomplete="tel">
            </div>
          </div>

          <div class="form-group">
            <label for="kamar"><i class="fas fa-door-open"></i> Nomor Kamar<span class="required">*</span></label>
            <div class="input-wrapper">
              <i class="fas fa-door-open input-icon"></i>
              <input
                type="text"
                name="kamar"
                id="kamar"
                class="form-control"
                placeholder="Contoh: A-01, B-12, C-05"
                required
                autocomplete="off">
            </div>
            <div class="checking-kamar" id="checkingKamar">
              <i class="fas fa-spinner"></i> Mengecek ketersediaan kamar...
            </div>
            <div class="validation-message" id="kamarValidation"></div>
          </div>

          <div class="form-group">
            <label for="alamat"><i class="fas fa-map-marker-alt"></i> Alamat</label>
            <textarea
              name="alamat"
              id="alamat"
              class="form-control"
              placeholder="Masukkan alamat lengkap"
              rows="3"></textarea>
          </div>

          <button class="btn-register" type="submit" id="registerBtn">
            <span>Daftar Sekarang</span>
            <i class="fas fa-user-plus"></i>
          </button>
        </form>
      </div>

      <div class="register-footer">
        <p>Sudah punya akun? <a href="<?= site_url('user/login') ?>">Login di sini</a></p>
      </div>
    </div>
  </div>

  <script>
    let kamarCheckTimeout;
    let isKamarValid = false;

    const kamarInput = document.getElementById('kamar');
    const idKosSelect = document.getElementById('id_kos');
    const checkingKamar = document.getElementById('checkingKamar');
    const kamarValidation = document.getElementById('kamarValidation');

    // Jalankan pengecekan saat user mengetik kamar
    kamarInput.addEventListener('input', function() {
      const kamarValue = this.value.trim().toUpperCase();
      const idKosValue = idKosSelect.value;

      this.value = kamarValue;

      kamarValidation.className = 'validation-message';
      kamarValidation.textContent = '';
      this.classList.remove('is-valid', 'is-invalid');
      isKamarValid = false;

      clearTimeout(kamarCheckTimeout);

      if (kamarValue === '' || idKosValue === '') {
        checkingKamar.classList.remove('show');
        return;
      }

      checkingKamar.classList.add('show');

      kamarCheckTimeout = setTimeout(function() {
        checkKamarAvailability(idKosValue, kamarValue);
      }, 500);
    });

    // Fungsi AJAX untuk cek kamar berdasarkan kos
    function checkKamarAvailability(idKos, kamar) {
      fetch('<?= site_url('user/register/check_kamar_per_kos') ?>', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
          },
          body: 'id_kos=' + encodeURIComponent(idKos) + '&kamar=' + encodeURIComponent(kamar),
        })
        .then(response => response.json())
        .then(data => {
          checkingKamar.classList.remove('show');

          if (data.available) {
            kamarInput.classList.add('is-valid');
            kamarValidation.className = 'validation-message success';
            kamarValidation.innerHTML = '<i class="fas fa-check-circle"></i> ' + data.message;
            isKamarValid = true;
          } else {
            kamarInput.classList.add('is-invalid');
            kamarValidation.className = 'validation-message error';
            kamarValidation.innerHTML = '<i class="fas fa-times-circle"></i> ' + data.message;
            isKamarValid = false;
          }
        })
        .catch(error => {
          console.error('Error:', error);
          checkingKamar.classList.remove('show');
          kamarValidation.className = 'validation-message error';
          kamarValidation.innerHTML = '<i class="fas fa-exclamation-triangle"></i> Gagal mengecek kamar.';
          isKamarValid = false;
        });
    }


    // Toggle password visibility
    const togglePassword = document.getElementById('togglePassword');
    const passwordInput = document.getElementById('password');

    togglePassword.addEventListener('click', function() {
      const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
      passwordInput.setAttribute('type', type);

      // Toggle icon
      this.classList.toggle('fa-eye');
      this.classList.toggle('fa-eye-slash');
    });

    // Form submission with validation
    const registerForm = document.getElementById('registerForm');

    registerForm.addEventListener('submit', function(e) {
      const kamarValue = kamarInput.value.trim();

      // Check if kamar is filled
      if (kamarValue === '') {
        e.preventDefault();
        kamarInput.classList.add('is-invalid');
        kamarValidation.className = 'validation-message error';
        kamarValidation.innerHTML = '<i class="fas fa-times-circle"></i> Nomor kamar harus diisi!';
        kamarInput.focus();
        return false;
      }

      // Check if kamar is valid (prevent submission if not valid)
      if (!isKamarValid) {
        e.preventDefault();
        kamarInput.classList.add('is-invalid');
        kamarValidation.className = 'validation-message error';
        kamarValidation.innerHTML = '<i class="fas fa-times-circle"></i> Mohon pilih nomor kamar yang tersedia!';
        kamarInput.focus();
        return false;
      }

      // Add loading state
      registerBtn.classList.add('loading');
      registerBtn.querySelector('span').textContent = 'Memproses...';
    });

    // Input focus effects
    const inputs = document.querySelectorAll('.form-control');

    inputs.forEach(input => {
      input.addEventListener('focus', function() {
        const icon = this.parentElement.querySelector('.input-icon');
        if (icon) {
          icon.style.color = '#4a90e2';
        }
      });

      input.addEventListener('blur', function() {
        const icon = this.parentElement.querySelector('.input-icon');
        if (!this.value && icon) {
          icon.style.color = '#aaa';
        }
      });
    });

    // Phone number validation
    const noHpInput = document.getElementById('no_hp');
    noHpInput.addEventListener('input', function(e) {
      // Only allow numbers
      this.value = this.value.replace(/[^0-9]/g, '');
    });
  </script>
</body>

</html>