<?php
/**
 * setup.php
 * Simple setup script to create an initial admin user.
 * Place this file in the CI3 project root (where index.php is). 
 * Only run once, then delete the file for security.
 */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $db_host = 'localhost';
    $db_user = 'root';
    $db_pass = '';
    $db_name = 'sistemkos_db';

    $email = $_POST['email'] ?? '';
    $nama = $_POST['nama'] ?? 'Admin';
    $password = $_POST['password'] ?? '';

    if (!$email || !$password) {
        $msg = 'Isi email dan password.';
    } else {
        try {
            $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $hash = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare('INSERT INTO admin (nama, email, password) VALUES (?, ?, ?)');
            $stmt->execute([$nama, $email, $hash]);
            $msg = 'Admin berhasil dibuat. Silakan hapus file setup.php dari server.';
        } catch (PDOException $e) {
            $msg = 'Error: ' . $e->getMessage();
        }
    }
}
?>
<!doctype html>
<html>
<head><meta charset="utf-8"><title>Setup KosCare- Buat Admin</title></head>
<body style="font-family: Arial, Helvetica, sans-serif; padding:20px;">
<h2>Setup KosCare- Buat Admin Awal</h2>
<?php if (!empty($msg)) echo '<p><strong>' . htmlentities($msg) . '</strong></p>'; ?>
<form method="post">
  <label>Nama: <input type="text" name="nama" value="Admin"></label><br><br>
  <label>Email: <input type="email" name="email" required></label><br><br>
  <label>Password: <input type="password" name="password" required></label><br><br>
  <button type="submit">Create Admin</button>
</form>
<p>Setelah sukses, <strong>hapus file setup.php</strong> dari server.</p>
</body>
</html>
